/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.util.Cache;
import com.mathworks.util.tree.DefaultMutableTree;
import com.mathworks.util.tree.Tree;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.util.tree.VisitStrategy;
import com.mathworks.widgets.text.mcode.MLint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.Validate;

public final class MTree
implements Iterable<Node> {
    private final List<Node> fNodes;
    private final boolean fValid;
    private final Cache<Set<NodeType>, Tree<Node>> fSearchResultsCache = new Cache((Cache.Loader)new Cache.Loader<Set<NodeType>, Tree<Node>>(){

        public Tree<Node> load(Set<NodeType> set) throws IOException {
            Node node = new Node(1, 0, 0, 0, 0, 0, 0, 0, 0, null, false, false, false, false, 0, 0, 0, 0, 0, 0, 0, 0, false);
            DefaultMutableTree defaultMutableTree = new DefaultMutableTree((Object)node);
            MTree.find((DefaultMutableTree<Node>)defaultMutableTree, node, MTree.this.getRoot(), set);
            return defaultMutableTree;
        }
    }, 5);
    public static final Node NULL_NODE = new Node(NodeType.access$200(NodeType.JAVA_NULL_NODE), -1, -1, -1, -1, -1, -1, -1, -1, null, false, false, false, false, -1, 0, -1, -1, -1, -1, -1, Attribute.NONE.ordinal(), false);

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<Node> iterator() {
        return new NodeIterator();
    }

    public Node getNode(int n) {
        return this.fNodes.get(n);
    }

    public int size() {
        return this.fNodes.size();
    }

    MTree(int n, boolean bl) {
        this.fNodes = new ArrayList<Node>(n);
        this.fValid = bl;
    }

    private void add(Node node) {
        Validate.notNull((Object)node);
        node.setList(this.fNodes);
        this.fNodes.add(node);
    }

    public Node getRoot() {
        return this.fNodes.isEmpty() ? NULL_NODE : this.fNodes.get(0);
    }

    public boolean isValid() {
        return this.fValid;
    }

    public Tree<Node> findAsTree(NodeType ... nodeTypeArray) {
        try {
            EnumSet<NodeType> enumSet = EnumSet.copyOf(Arrays.asList(nodeTypeArray));
            return (Tree)this.fSearchResultsCache.get(enumSet);
        }
        catch (IOException iOException) {
            assert (false) : iOException;
            return null;
        }
    }

    public List<Node> findAsList(NodeType ... nodeTypeArray) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        TreeUtils.find(this.findAsTree(nodeTypeArray), (VisitStrategy)new VisitStrategy(TreeUtils.yes()), arrayList);
        assert (!arrayList.isEmpty());
        arrayList.remove(0);
        return arrayList;
    }

    private static void find(DefaultMutableTree<Node> defaultMutableTree, Node node, Node node2, Set<NodeType> set) {
        for (Node node3 = node2; node3 != NULL_NODE; node3 = node3.getNext()) {
            Node node4 = node;
            if (set.contains((Object)node3.getType())) {
                defaultMutableTree.addChild((Object)node, (Object)node3);
                node4 = node3;
            }
            MTree.find(defaultMutableTree, node4, node3.getLeft(), set);
            MTree.find(defaultMutableTree, node4, node3.getRight(), set);
        }
    }

    public static MTree parse(File file) throws IOException {
        return MTree.parse(file, false);
    }

    public static MTree parse(File file, boolean bl) throws IOException {
        Validate.notNull((Object)file, (String)"'file' cannot be null");
        return MTree.parse(FileUtils.readFileToString((File)file), bl);
    }

    public static MTree parse(String string) {
        return MTree.parse(string, false);
    }

    public static MTree parse(String string, boolean bl) {
        Validate.notNull((Object)string, (String)"'mcode' cannot be null");
        return MLint.parse(string, bl);
    }

    private class NodeIterator
    implements Iterator<Node> {
        private int iIndex = 0;

        private NodeIterator() {
        }

        @Override
        public boolean hasNext() {
            return !MTree.this.isEmpty() && this.iIndex < MTree.this.size();
        }

        @Override
        public Node next() {
            if (this.iIndex >= MTree.this.size()) {
                throw new NoSuchElementException();
            }
            return MTree.this.getNode(this.iIndex++);
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }
    }

    public static class Node {
        private final NodeType fType;
        private final String fText;
        private final int fLeftIndex;
        private final int fRightIndex;
        private final int fNextIndex;
        private final int fStartLine;
        private final int fStartColumn;
        private final int fEndLine;
        private final int fEndColumn;
        private final boolean fClosed;
        private final boolean fUpLevel;
        private final boolean fGlobal;
        private final boolean fPersistent;
        private List<Node> fNodes;
        private final int fParentIndex;
        private final int fSize;
        private final int fPosition;
        private final int fTrueParentIndex;
        private final int fLeftTreePosition;
        private final int fRightTreePosition;
        private final int fRightTreeIndex;
        private final int fSymbolTableIndex;
        private final Attribute fAttribute;
        private final boolean fIsTextSupported;

        private Node(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, boolean bl5) {
            this.fIsTextSupported = bl5;
            this.fType = NodeType.valueOf(n);
            this.fText = this.isTextSupported() ? string : null;
            this.fLeftIndex = n2;
            this.fRightIndex = n3;
            this.fNextIndex = n4;
            this.fStartLine = n6;
            this.fStartColumn = n7;
            this.fEndLine = n8;
            this.fEndColumn = n9;
            this.fClosed = bl;
            this.fUpLevel = bl2;
            this.fGlobal = bl3;
            this.fPersistent = bl4;
            this.fParentIndex = n5;
            this.fPosition = n10;
            this.fSize = n11;
            this.fTrueParentIndex = n12;
            this.fLeftTreePosition = n13;
            this.fRightTreePosition = n14;
            this.fRightTreeIndex = n15;
            this.fSymbolTableIndex = n16;
            this.fAttribute = Attribute.values()[n17];
        }

        public int getIndex() {
            return this.fNodes.indexOf(this);
        }

        public NodeType getType() {
            return this.fType;
        }

        public String getText() {
            if (!this.isTextSupported()) {
                assert (false) : "getText() should not be called unless isTextSupported() is true";
                return "";
            }
            return this.fText;
        }

        public boolean isTextSupported() {
            return this.fIsTextSupported;
        }

        public int getStartLine() {
            return this.fStartLine == 0 ? this.assertNonZero("startLine", this.getParent().getStartLine()) : this.fStartLine;
        }

        public int getStartColumn() {
            return this.fStartColumn == 0 ? this.assertNonZero("startColumn", this.getParent().getStartColumn()) : this.fStartColumn;
        }

        public int getEndLine() {
            return this.fEndLine;
        }

        public int getEndColumn() {
            return this.fEndColumn;
        }

        public Node getNext() {
            return this.safelyGet(this.fNextIndex);
        }

        public Node getLeft() {
            return this.safelyGet(this.fLeftIndex);
        }

        public Node getRight() {
            return this.safelyGet(this.fRightIndex);
        }

        public String toString() {
            return this.getType().toString() + (this.fText != null ? " (" + this.fText + ")" : "") + " [" + this.getStartLine() + ", " + this.getStartColumn() + "] to" + " [" + this.getEndLine() + ", " + this.getEndColumn() + "]";
        }

        private void setList(List<Node> list) {
            assert (this.fNodes == null) : "setList called more than once";
            this.fNodes = list;
        }

        private Node safelyGet(int n) {
            return n != -1 ? this.fNodes.get(n) : NULL_NODE;
        }

        public boolean hasEnd() {
            if (this.getType() != NodeType.FUNCTION) {
                throw new IllegalStateException("hasEnd() is only valid on nodes of type FUNCTION");
            }
            return this.fClosed;
        }

        public boolean isUsedCrossFunctions() {
            if (this.getType() != NodeType.ID) {
                throw new IllegalStateException("isUsedCrossFunctions() is only valid on nodes of type ID");
            }
            return this.fUpLevel;
        }

        public boolean isPersistent() {
            if (this.getType() != NodeType.ID) {
                throw new IllegalStateException("isPersistent() is only valid on nodes of type ID");
            }
            return this.fPersistent;
        }

        public boolean isGlobal() {
            if (this.getType() != NodeType.ID) {
                throw new IllegalStateException("isGlobal() is only valid on nodes of type ID");
            }
            return this.fGlobal;
        }

        public Node getParent() {
            return this.safelyGet(this.fParentIndex);
        }

        public Node getPrevious() {
            Node node = this.getParent();
            return node.getNext() == this ? node : NULL_NODE;
        }

        public List<Node> getListOfNextNodes() {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Node node = this; node != NULL_NODE; node = node.getNext()) {
                arrayList.add(node);
            }
            return arrayList;
        }

        int getMinimumPosition() {
            return this.fLeftTreePosition == 0 ? this.assertNonZero("minimumPosition", this.getParent().getMinimumPosition()) : this.fLeftTreePosition;
        }

        int getMaximumPosition() {
            return this.fRightTreePosition == 0 ? this.assertNonZero("maximumPosition", this.getParent().getMaximumPosition()) : this.fRightTreePosition;
        }

        public int getPosition() {
            return this.fPosition == 0 ? this.assertNonZero("position", this.getParent().getPosition()) : this.fPosition;
        }

        private int assertNonZero(String string, int n) {
            assert (n > 0) : "Node " + this.toString() + " has a value of zero for property '" + string + "'. " + "Its parent node, " + this.getParent() + ", should have a positive value for this property. " + "Instead, the value was: " + n + ".";
            return n;
        }

        public int getSize() {
            return this.fSize;
        }

        public Node getBody() {
            return this.getType().canHaveBody() ? this.getRight() : NULL_NODE;
        }

        public Node getTrueParent() {
            return this.safelyGet(this.fTrueParentIndex);
        }

        public List<Node> getInputArguments() {
            List<Node> list = Collections.emptyList();
            if (this.getType().canHaveInputArguments()) {
                Node node = this.getLeft();
                Node node2 = node.getRight();
                Node node3 = node2.getRight();
                list = node3.getListOfNextNodes();
            }
            return list;
        }

        public List<Node> getOutputArguments() {
            List<Node> list = Collections.emptyList();
            if (this.getType().canHaveOutputArguments()) {
                Node node = this.getLeft();
                Node node2 = node.getLeft();
                list = node2.getListOfNextNodes();
            }
            return list;
        }

        public Node getFunctionName() {
            Validate.isTrue((boolean)this.getType().isFunction(), (String)(this + " is not a Function Node"));
            Node node = this.getLeft();
            Node node2 = node.getRight();
            return node2.getLeft();
        }

        public List<Node> getSubtree() {
            int n = this.getRightTreeIndex() + 1;
            int n2 = this.fNodes.indexOf(this);
            ArrayList<Node> arrayList = new ArrayList<Node>(n - n2);
            for (Node node : this.fNodes.subList(n2, n)) {
                arrayList.add(node);
            }
            return arrayList;
        }

        public int getRightTreeIndex() {
            return this.fRightTreeIndex;
        }

        public int getSymbolTableIndex() {
            return this.fSymbolTableIndex;
        }

        public Attribute getAttribute() {
            return this.fAttribute;
        }

        public Node getRightmostNode() {
            return this.safelyGet(this.getRightTreeIndex());
        }
    }

    public static enum Attribute {
        NONE,
        VARIABLE,
        CLASS,
        FUNCTION,
        METHOD;

    }

    public static final class NodeType
    extends Enum<NodeType> {
        public static final /* enum */ NodeType ERROR = new NodeType(1);
        public static final /* enum */ NodeType IF = new NodeType(2);
        public static final /* enum */ NodeType ELSE = new NodeType(3);
        public static final /* enum */ NodeType ELSEIF = new NodeType(4);
        public static final /* enum */ NodeType SWITCH = new NodeType(5);
        public static final /* enum */ NodeType WHILE = new NodeType(6);
        public static final /* enum */ NodeType BREAK = new NodeType(7);
        public static final /* enum */ NodeType RETURN = new NodeType(8);
        public static final /* enum */ NodeType GLOBAL = new NodeType(9);
        public static final /* enum */ NodeType PERSISTENT = new NodeType(10);
        public static final /* enum */ NodeType TRY = new NodeType(11);
        public static final /* enum */ NodeType CATCH = new NodeType(12);
        public static final /* enum */ NodeType CONTINUE = new NodeType(13);
        public static final /* enum */ NodeType FUNCTION = new NodeType(14);
        public static final /* enum */ NodeType FOR = new NodeType(15);
        public static final /* enum */ NodeType PARFOR = new NodeType(16);
        public static final /* enum */ NodeType LEFT_PAREN = new NodeType(17);
        public static final /* enum */ NodeType RIGHT_PAREN = new NodeType(18);
        public static final /* enum */ NodeType LEFT_BRACKET = new NodeType(19);
        public static final /* enum */ NodeType RIGHT_BRACKET = new NodeType(20);
        public static final /* enum */ NodeType LEFT_CURLY_BRACE = new NodeType(21);
        public static final /* enum */ NodeType RIGHT_CURLY_BRACE = new NodeType(22);
        public static final /* enum */ NodeType AT_SIGN = new NodeType(23);
        public static final /* enum */ NodeType DOT_LEFT_PAREN = new NodeType(24);
        public static final /* enum */ NodeType PLUS = new NodeType(25);
        public static final /* enum */ NodeType MINUS = new NodeType(26);
        public static final /* enum */ NodeType MULTIPLY = new NodeType(27);
        public static final /* enum */ NodeType DIVIDE = new NodeType(28);
        public static final /* enum */ NodeType LEFT_DIVIDE = new NodeType(29);
        public static final /* enum */ NodeType EXPONENTIATION = new NodeType(30);
        public static final /* enum */ NodeType COLON = new NodeType(31);
        public static final /* enum */ NodeType DOT = new NodeType(32);
        public static final /* enum */ NodeType DOT_MULTIPLY = new NodeType(33);
        public static final /* enum */ NodeType DOT_DIVIDE = new NodeType(34);
        public static final /* enum */ NodeType DOT_LEFT_DIVIDE = new NodeType(35);
        public static final /* enum */ NodeType DOT_EXPONENTIATION = new NodeType(36);
        public static final /* enum */ NodeType AND = new NodeType(37);
        public static final /* enum */ NodeType OR = new NodeType(38);
        public static final /* enum */ NodeType ANDAND = new NodeType(39);
        public static final /* enum */ NodeType OROR = new NodeType(40);
        public static final /* enum */ NodeType LT = new NodeType(41);
        public static final /* enum */ NodeType GT = new NodeType(42);
        public static final /* enum */ NodeType LE = new NodeType(43);
        public static final /* enum */ NodeType GE = new NodeType(44);
        public static final /* enum */ NodeType EQ = new NodeType(45);
        public static final /* enum */ NodeType NE = new NodeType(46);
        public static final /* enum */ NodeType CASE = new NodeType(47);
        public static final /* enum */ NodeType OTHERWISE = new NodeType(48);
        public static final /* enum */ NodeType DUAL = new NodeType(49);
        public static final /* enum */ NodeType TRANS = new NodeType(50);
        public static final /* enum */ NodeType DOTTRANS = new NodeType(51);
        public static final /* enum */ NodeType NOT = new NodeType(52);
        public static final /* enum */ NodeType ID = new NodeType(53);
        public static final /* enum */ NodeType INT = new NodeType(54);
        public static final /* enum */ NodeType DOUBLE = new NodeType(55);
        public static final /* enum */ NodeType STRING = new NodeType(56);
        public static final /* enum */ NodeType SEMI = new NodeType(57);
        public static final /* enum */ NodeType COMMA = new NodeType(58);
        public static final /* enum */ NodeType EOL = new NodeType(59);
        public static final /* enum */ NodeType BANG = new NodeType(60);
        public static final /* enum */ NodeType END = new NodeType(61);
        public static final /* enum */ NodeType EQUALS = new NodeType(62);
        public static final /* enum */ NodeType CLASSDEF = new NodeType(63);
        public static final /* enum */ NodeType PROPERTIES = new NodeType(64);
        public static final /* enum */ NodeType METHODS = new NodeType(65);
        public static final /* enum */ NodeType EVENTS = new NodeType(66);
        public static final /* enum */ NodeType QUEST = new NodeType(67);
        public static final /* enum */ NodeType ENUMERATION = new NodeType(68);
        public static final /* enum */ NodeType ERR = new NodeType(69);
        public static final /* enum */ NodeType CELL = new NodeType(70);
        public static final /* enum */ NodeType SUBSCR = new NodeType(71);
        public static final /* enum */ NodeType CALL = new NodeType(72);
        public static final /* enum */ NodeType EXPR = new NodeType(73);
        public static final /* enum */ NodeType PRINT_EXPR = new NodeType(74);
        public static final /* enum */ NodeType ANON = new NodeType(75);
        public static final /* enum */ NodeType ANONID = new NodeType(76);
        public static final /* enum */ NodeType DCALL = new NodeType(77);
        public static final /* enum */ NodeType JOIN = new NodeType(78);
        public static final /* enum */ NodeType LIST = new NodeType(79);
        public static final /* enum */ NodeType EVENT = new NodeType(80);
        public static final /* enum */ NodeType FIELD = new NodeType(81);
        public static final /* enum */ NodeType UMINUS = new NodeType(82);
        public static final /* enum */ NodeType UPLUS = new NodeType(83);
        public static final /* enum */ NodeType ATBASE = new NodeType(84);
        public static final /* enum */ NodeType CEXPR = new NodeType(85);
        public static final /* enum */ NodeType ROW = new NodeType(86);
        public static final /* enum */ NodeType ATTR = new NodeType(87);
        public static final /* enum */ NodeType ETC = new NodeType(88);
        public static final /* enum */ NodeType DISTFOR = new NodeType(89);
        public static final /* enum */ NodeType CELL_TITLE = new NodeType(90);
        public static final /* enum */ NodeType COMMENT = new NodeType(91);
        public static final /* enum */ NodeType BLOCK_COMMENT = new NodeType(92);
        public static final /* enum */ NodeType BLOCK_COMMENT_END = new NodeType(93);
        public static final /* enum */ NodeType OLDFUN = new NodeType(94);
        public static final /* enum */ NodeType PARENS = new NodeType(95);
        public static final /* enum */ NodeType IFHEAD = new NodeType(96);
        public static final /* enum */ NodeType PROTO = new NodeType(97);
        public static final /* enum */ NodeType ATTRIBUTES = new NodeType(98);
        public static final /* enum */ NodeType SPMD = new NodeType(99);
        public static final /* enum */ NodeType JAVA_NULL_NODE = new NodeType(-100);
        private final int fValue;
        private static final Map<Integer, NodeType> MAP;
        private static final Collection<NodeType> COMMENT_TYPES;
        private static final /* synthetic */ NodeType[] $VALUES;

        public static NodeType[] values() {
            return (NodeType[])$VALUES.clone();
        }

        public static NodeType valueOf(String string) {
            return Enum.valueOf(NodeType.class, string);
        }

        private NodeType(int n2) {
            this.fValue = n2;
        }

        private int getValue() {
            return this.fValue;
        }

        public static NodeType valueOf(int n) {
            if (MAP.isEmpty()) {
                for (NodeType nodeType : NodeType.values()) {
                    assert (MAP.get(nodeType.getValue()) == null);
                    MAP.put(nodeType.getValue(), nodeType);
                }
            }
            assert (MAP.get(n) != null) : "No NodeType with value: " + n;
            return MAP.get(n);
        }

        private boolean isBinaryOperation() {
            return EnumSet.of(DOT_LEFT_PAREN, new NodeType[]{PLUS, MINUS, MULTIPLY, DIVIDE, LEFT_DIVIDE, EXPONENTIATION, COLON, DOT, DOT_MULTIPLY, DOT_DIVIDE, DOT_LEFT_DIVIDE, DOT_EXPONENTIATION, AND, OR, ANDAND, OROR, LT, GT, LE, GE, EQ, NE, CELL, SUBSCR, ANON, ATBASE, ATTR}).contains((Object)this);
        }

        private boolean isUnaryOperation() {
            return EnumSet.of(DOTTRANS, new NodeType[]{TRANS, NOT, QUEST, UMINUS, UPLUS, ROW, AT_SIGN, LEFT_CURLY_BRACE, LEFT_BRACKET}).contains((Object)this);
        }

        private boolean isStatement() {
            return EnumSet.of(EXPR, new NodeType[]{PRINT_EXPR, GLOBAL, PERSISTENT, BREAK, RETURN, CONTINUE, WHILE, SWITCH, CASE, IF, TRY, FOR, PARFOR, OTHERWISE, DISTFOR, CELL_TITLE, COMMENT, BLOCK_COMMENT, SPMD}).contains((Object)this);
        }

        private boolean hasLeftAndBody() {
            return EnumSet.of(WHILE, new NodeType[]{SWITCH, CASE, CATCH, SPMD, IFHEAD, ELSEIF}).contains((Object)this);
        }

        public boolean isFunction() {
            return EnumSet.of(FUNCTION, PROTO).contains((Object)this);
        }

        public boolean isFor() {
            return EnumSet.of(FOR, PARFOR, DISTFOR).contains((Object)this);
        }

        public boolean isClass() {
            return this == CLASSDEF;
        }

        private boolean isClassSection() {
            return EnumSet.of(PROPERTIES, METHODS, EVENTS, ENUMERATION).contains((Object)this);
        }

        public boolean isComment() {
            return COMMENT_TYPES.contains((Object)this);
        }

        private boolean canHaveBody() {
            return this.hasLeftAndBody() || this.isFunction() || this.isFor() || this.isClass() || this.isClassSection();
        }

        private boolean canHaveInputArguments() {
            return this.isFunction();
        }

        private boolean canHaveOutputArguments() {
            return this.isFunction();
        }

        static /* synthetic */ int access$200(NodeType nodeType) {
            return nodeType.getValue();
        }

        static {
            $VALUES = new NodeType[]{ERROR, IF, ELSE, ELSEIF, SWITCH, WHILE, BREAK, RETURN, GLOBAL, PERSISTENT, TRY, CATCH, CONTINUE, FUNCTION, FOR, PARFOR, LEFT_PAREN, RIGHT_PAREN, LEFT_BRACKET, RIGHT_BRACKET, LEFT_CURLY_BRACE, RIGHT_CURLY_BRACE, AT_SIGN, DOT_LEFT_PAREN, PLUS, MINUS, MULTIPLY, DIVIDE, LEFT_DIVIDE, EXPONENTIATION, COLON, DOT, DOT_MULTIPLY, DOT_DIVIDE, DOT_LEFT_DIVIDE, DOT_EXPONENTIATION, AND, OR, ANDAND, OROR, LT, GT, LE, GE, EQ, NE, CASE, OTHERWISE, DUAL, TRANS, DOTTRANS, NOT, ID, INT, DOUBLE, STRING, SEMI, COMMA, EOL, BANG, END, EQUALS, CLASSDEF, PROPERTIES, METHODS, EVENTS, QUEST, ENUMERATION, ERR, CELL, SUBSCR, CALL, EXPR, PRINT_EXPR, ANON, ANONID, DCALL, JOIN, LIST, EVENT, FIELD, UMINUS, UPLUS, ATBASE, CEXPR, ROW, ATTR, ETC, DISTFOR, CELL_TITLE, COMMENT, BLOCK_COMMENT, BLOCK_COMMENT_END, OLDFUN, PARENS, IFHEAD, PROTO, ATTRIBUTES, SPMD, JAVA_NULL_NODE};
            MAP = new HashMap<Integer, NodeType>();
            COMMENT_TYPES = EnumSet.of(COMMENT, BLOCK_COMMENT, CELL_TITLE);
        }
    }
}

