/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.tokenmatch;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.SimpleStringTrimmer;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.util.ArrayUtils;
import com.mathworks.widgets.SyntaxTextLabel;
import com.mathworks.widgets.Tokenizer;
import com.mathworks.widgets.TokenizerFactory;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicLabelUI;

public class TokenMatchSyntaxLabel
extends MJLabel {
    private int[] fMarkRegion;
    private boolean fUnderlineMarkedRegion;
    private Color fHighlightColor;
    private Color fSelectedTextColor;
    private String fLineNumber;
    protected Object[] fTokens;
    private static final int BORDER_GAP = 2;

    public TokenMatchSyntaxLabel() {
        this.putClientProperty("html.disable", Boolean.TRUE);
        this.setOpaque(true);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("ToolBar.shadow"), 2), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.setupDefaults();
    }

    private void setupDefaults() {
        this.fMarkRegion = null;
        this.fUnderlineMarkedRegion = true;
        this.fHighlightColor = this.getBackground();
        this.fSelectedTextColor = this.getForeground();
        this.fLineNumber = "";
        this.fTokens = null;
    }

    public void updateUI() {
        this.setUI(new PaintedBasicLabelUI());
    }

    public void setStyleUnderline() {
        this.fUnderlineMarkedRegion = true;
    }

    public boolean isStyleUnderline() {
        return this.fUnderlineMarkedRegion;
    }

    public void setStyleHighlighted(Color color, Color color2) {
        this.fUnderlineMarkedRegion = false;
        this.fHighlightColor = color;
        this.fSelectedTextColor = color2;
    }

    public int[] getMarkCharPositions() {
        if (this.fMarkRegion == null) {
            return null;
        }
        return new int[]{this.fMarkRegion[0], this.fMarkRegion[1]};
    }

    public void clearMarks() {
        this.fMarkRegion = null;
        this.repaint();
    }

    public int getLineNumberWidth() {
        return this.getFontMetrics(this.getFont()).stringWidth(this.fLineNumber);
    }

    private static int getCompleteBorderGap() {
        return 4;
    }

    public void setText(String string) {
        this.setupDefaults();
        super.setText(string, false);
    }

    public SetTextResult setTextProperties(String string, Tokenizer tokenizer, Rectangle rectangle, ShowLocation showLocation) {
        return this.setTextProperties(null, string, tokenizer, rectangle, showLocation);
    }

    public SetTextResult setTextProperties(int[] nArray, String string, Tokenizer tokenizer, Rectangle rectangle, ShowLocation showLocation) {
        return this.setTextProperties(nArray, string, 0, string.length(), -1, tokenizer, rectangle, showLocation);
    }

    public SetTextResult setTextProperties(int[] nArray, String string, int n, int n2, int n3, Tokenizer tokenizer, Rectangle rectangle, ShowLocation showLocation) {
        int n4;
        assert (n < n2) : "endIndex must be greater than startIndex";
        assert (n2 <= string.length()) : "endIndex must be less than or greater to complete line length";
        assert (n >= 0) : "startIndex can't be negative";
        assert (rectangle != null) : "viewportBounds cannot be null";
        String string2 = string.substring(n, n2);
        int n5 = this.getFontMetrics(this.getFont()).stringWidth(string2);
        ShowLocation showLocation2 = showLocation;
        int[] nArray2 = null;
        if (nArray != null) {
            assert (nArray.length == 2) : "marks must be null or of length 2";
            assert (nArray[0] >= n) : "marks can't be before start of text";
            assert (nArray[1] <= n2) : "marks can't be after end of text";
            assert (nArray[0] < nArray[1]) : "marks must be increasing";
            nArray2 = new int[]{nArray[0], nArray[1]};
        }
        int n6 = rectangle.x;
        int n7 = n6 + rectangle.width;
        int n8 = WindowUtils.getVirtualScreenBounds().x;
        int n9 = n8 + WindowUtils.getVirtualScreenBounds().width;
        String string3 = "";
        String string4 = "";
        if (showLocation != ShowLocation.SHOW_COMPLETE_LINE_LEFT && showLocation != ShowLocation.SHOW_COMPLETE_LINE_RIGHT) {
            int n10;
            if (showLocation == ShowLocation.SHOW_LEFT && n6 - n5 < n8) {
                n10 = n2 - this.truncateText(true, string2, string2.length(), n6 - n8);
                if (TokenMatchSyntaxLabel.cantTruncateRight(n, n10, nArray2)) {
                    showLocation2 = ShowLocation.SHOW_COMPLETE_LINE_LEFT;
                } else {
                    n2 = n10;
                    string4 = "...";
                    string2 = string.substring(n, n2);
                }
            } else if (showLocation == ShowLocation.SHOW_RIGHT && n9 - n7 - n5 < 0) {
                n10 = n + this.truncateText(false, string2, 0, n9 - n7);
                if (TokenMatchSyntaxLabel.cantTruncateLeft(n10, n2, nArray2)) {
                    showLocation2 = ShowLocation.SHOW_COMPLETE_LINE_RIGHT;
                } else {
                    string3 = "...";
                    n = n10;
                    string2 = string.substring(n, n2);
                }
            }
        }
        String string5 = "";
        if (n3 != -1 && (showLocation2 == ShowLocation.SHOW_COMPLETE_LINE_LEFT || showLocation2 == ShowLocation.SHOW_COMPLETE_LINE_RIGHT)) {
            string5 = String.valueOf(n3) + " ";
        }
        if ((showLocation2 == ShowLocation.SHOW_COMPLETE_LINE_LEFT || showLocation2 == ShowLocation.SHOW_COMPLETE_LINE_RIGHT) && n6 + n5 > n9) {
            if (showLocation2 == ShowLocation.SHOW_COMPLETE_LINE_LEFT) {
                if (TokenMatchSyntaxLabel.cantTruncateRight(n, n2 -= this.truncateText(true, string2, string2.length(), n9 - n6), nArray2)) {
                    return this.notEnoughRoom();
                }
                string4 = "...";
                string2 = string.substring(n, n2);
            } else {
                if (TokenMatchSyntaxLabel.cantTruncateLeft(n += this.truncateText(false, string2, 0, n9 - n6), n2, nArray2)) {
                    return this.notEnoughRoom();
                }
                string3 = "...";
                string2 = string.substring(n, n2);
            }
        }
        this.setText(string5 + string3 + string2 + string4);
        this.fLineNumber = string5;
        TokenMatchSyntaxLabel.adjustMarks(this.fLineNumber.length() + string3.length() - n, nArray2);
        this.fMarkRegion = nArray2;
        Object[] objectArray = SyntaxTextLabel.getStringTokens(string, tokenizer);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n11 = this.fLineNumber.length();
        if (n11 > 0) {
            arrayList.add(0);
            arrayList2.add(null);
        }
        if (string3.length() > 0) {
            arrayList.add(n11);
            arrayList2.add(null);
            n11 += string3.length();
        }
        int[] nArray3 = (int[])objectArray[0];
        String[] stringArray = (String[])objectArray[1];
        boolean bl = false;
        for (int i = 0; i != nArray3.length; ++i) {
            n4 = nArray3[i];
            if (n4 >= n2) continue;
            if ((n4 = n11 + n4 - n) < n11) {
                if (bl) {
                    TokenMatchSyntaxLabel.replaceLastColor(arrayList2, stringArray[i]);
                    continue;
                }
                arrayList.add(n11);
                arrayList2.add(stringArray[i]);
                bl = true;
                continue;
            }
            if (n4 == n11 && bl) {
                TokenMatchSyntaxLabel.replaceLastColor(arrayList2, stringArray[i]);
                continue;
            }
            arrayList.add(n4);
            arrayList2.add(stringArray[i]);
        }
        if (string4.length() > 0) {
            arrayList.add(this.getText().length() - string4.length());
            arrayList2.add(null);
        }
        int[] nArray4 = new int[arrayList.size()];
        for (n4 = 0; n4 != arrayList.size(); ++n4) {
            nArray4[n4] = (Integer)arrayList.get(n4);
        }
        this.fTokens = new Object[]{nArray4, arrayList2.toArray(ArrayUtils.EmptyObjects.STRING)};
        if (this.fTokens == null) {
            this.fTokens = this.createPlainToken();
        }
        return showLocation2 == ShowLocation.SHOW_COMPLETE_LINE_LEFT || showLocation2 == ShowLocation.SHOW_COMPLETE_LINE_RIGHT ? SetTextResult.SUCCESS_COMPLETE_LINE : SetTextResult.SUCCESS_PARTIAL_LINE;
    }

    private static void replaceLastColor(List<String> list, String string) {
        assert (!list.isEmpty());
        list.remove(list.size() - 1);
        list.add(string);
    }

    private SetTextResult notEnoughRoom() {
        this.setText("");
        return SetTextResult.NOT_ENOUGH_ROOM;
    }

    private static boolean cantTruncateRight(int n, int n2, int[] nArray) {
        return n >= n2 || nArray != null && nArray[1] > n2;
    }

    private static boolean cantTruncateLeft(int n, int n2, int[] nArray) {
        return n >= n2 || nArray != null && nArray[0] < n;
    }

    private int truncateText(boolean bl, String string, int n, int n2) {
        SimpleStringTrimmer simpleStringTrimmer = new SimpleStringTrimmer(bl ? 2 : 1, n);
        String string2 = simpleStringTrimmer.shortenString(string, this.getFontMetrics(this.getFont()), n2);
        if (bl) {
            assert (string2.endsWith("...")) : "Truncated text does not end with ellipses";
        } else assert (string2.startsWith("...")) : "Truncated text does not start with ellipses";
        return string.length() - (string2.length() - "...".length());
    }

    private static void adjustMarks(int n, int[] nArray) {
        if (nArray != null) {
            nArray[0] = nArray[0] + n;
            nArray[1] = nArray[1] + n;
        }
    }

    private Object[] createPlainToken() {
        Tokenizer.TokenInfo[] tokenInfoArray = TokenizerFactory.getPlainTokenizer().tokenize(this.getText());
        return SyntaxTextLabel.convertToOffsetColorArray(tokenInfoArray);
    }

    public void adjustShowLocationForLabelSize(boolean bl, boolean bl2, boolean bl3, Point point) {
        point.y = bl2 ? point.y - this.getPreferredSize().height + TokenMatchSyntaxLabel.getCompleteBorderGap() : (point.y -= TokenMatchSyntaxLabel.getCompleteBorderGap());
        point.x = bl && !bl2 && !bl3 ? point.x - this.getPreferredSize().width + TokenMatchSyntaxLabel.getCompleteBorderGap() : (point.x -= TokenMatchSyntaxLabel.getCompleteBorderGap());
        if (bl2 || bl3) {
            point.x -= this.getLineNumberWidth();
        }
    }

    private class PaintedBasicLabelUI
    extends BasicLabelUI {
        private PaintedBasicLabelUI() {
        }

        @Override
        protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
            graphics.setColor(jLabel.getForeground());
            if (TokenMatchSyntaxLabel.this.fTokens == null) {
                TokenMatchSyntaxLabel.this.fTokens = TokenMatchSyntaxLabel.this.createPlainToken();
            }
            SyntaxTextLabel.paintFromTokens(TokenMatchSyntaxLabel.this.fTokens, TokenMatchSyntaxLabel.this.getFontMetrics(TokenMatchSyntaxLabel.this.getFont()), jLabel, graphics, string, n, n2);
            if (TokenMatchSyntaxLabel.this.getMarkCharPositions() != null) {
                int[] nArray = TokenMatchSyntaxLabel.this.getMarkCharPositions();
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n3 = n + fontMetrics.stringWidth(string.substring(0, nArray[0]));
                char[] cArray = string.substring(nArray[0], nArray[1]).toCharArray();
                int n4 = fontMetrics.charsWidth(cArray, 0, cArray.length);
                Color color = graphics.getColor();
                if (TokenMatchSyntaxLabel.this.isStyleUnderline()) {
                    graphics.setColor(TokenMatchSyntaxLabel.this.getForeground());
                    graphics.drawLine(n3, n2 + 2, n3 + n4, n2 + 2);
                } else {
                    graphics.setColor(TokenMatchSyntaxLabel.this.fHighlightColor);
                    graphics.fillRect(n3, TokenMatchSyntaxLabel.getCompleteBorderGap(), n4, TokenMatchSyntaxLabel.this.getHeight() - TokenMatchSyntaxLabel.getCompleteBorderGap() * 2);
                    graphics.setColor(TokenMatchSyntaxLabel.this.fSelectedTextColor);
                    graphics.drawChars(cArray, 0, cArray.length, n3, n2);
                }
                graphics.setColor(color);
            }
        }
    }

    public static enum SetTextResult {
        SUCCESS_PARTIAL_LINE,
        SUCCESS_COMPLETE_LINE,
        NOT_ENOUGH_ROOM;

    }

    public static enum ShowLocation {
        SHOW_LEFT,
        SHOW_RIGHT,
        SHOW_COMPLETE_LINE_LEFT,
        SHOW_COMPLETE_LINE_RIGHT;

    }
}

