/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.LineBox;
import ice.pilots.html4.TextBox;
import java.awt.FontMetrics;
import java.awt.Graphics;

class BulletBox
extends CSSBox {
    private int type;
    private int lineHeight;
    private int ascent;
    private int descent;
    private int size;

    BulletBox(DElement dElement, CSSAttribs cSSAttribs, int n, CSSLayout cSSLayout) {
        super(dElement, cSSAttribs, cSSLayout);
        this.type = n;
    }

    void dispose() {
        super.dispose();
        this.element = null;
    }

    DNode getDomNode() {
        return this.element;
    }

    int calcBreaks() {
        FontMetrics fontMetrics = this.css.getFontMetrics();
        long l = TextBox.calculateCompressedFontSize(fontMetrics.getAscent(), fontMetrics.getDescent(), this.css);
        this.ascent = BulletBox.unwrapAscent(l);
        this.descent = BulletBox.unwrapDescent(l);
        this.size = (this.ascent + this.descent) / 3;
        this.lineHeight = TextBox.calculateLineHeight(this.css);
        this.totalWidth = this.size;
        return 0;
    }

    int getBreaks(int[] nArray, int n) {
        return 0;
    }

    long getChunkDescentAscent(int n, int n2, LineBox lineBox) {
        return BulletBox.wrapDescentAscent(this.descent, this.ascent, this.lineHeight);
    }

    void paintChunk(Graphics graphics, int n, int n2, LineBox lineBox, int n3) {
        if ((this.css.misc & 1) == 0) {
            return;
        }
        graphics.setColor(this.css.color);
        int n4 = (this.ascent + this.descent) * 2 / 5;
        if (this.type == 98) {
            graphics.drawOval(n, n4, this.size, this.size);
        } else if (this.type == 99) {
            graphics.drawRect(n, n4, this.size, this.size);
        } else if (this.type == 97) {
            graphics.fillOval(n, n4, this.size, this.size);
        }
    }
}

