/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DMutationEvent;
import ice.pilots.html4.DNode;
import ice.storm.DynEnv;
import java.text.BreakIterator;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DTextNode
extends DNode
implements Text,
CharacterData {
    boolean isPre = false;
    private boolean isReversed;
    char[] text;
    int[] breakOffset;
    int numBreaks = 0;
    private static final int Field_data = 1;
    private static final int Field_length = 2;
    private static final int Method_appendData = -1;
    private static final int Method_deleteData = -2;
    private static final int Method_insertData = -3;
    private static final int Method_replaceData = -4;
    private static final int Method_splitText = -5;
    private static final int Method_substringData = -6;

    DTextNode(DDocument dDocument, char[] cArray, int n, int n2, boolean bl) {
        super(dDocument, 92);
        this.isPre = bl;
        this.initializeText(cArray, n, n2);
    }

    DTextNode(DDocument dDocument, String string, boolean bl) {
        super(dDocument, 92);
        this.isPre = bl;
        this.initializeText(string);
    }

    public void init() {
        if (this.isPre) {
            this.numBreaks = this.calculatePreNumbreaks(this.text);
            this.breakOffset = this.calculatePreLinebreaks(this.text, this.numBreaks);
        } else {
            this.numBreaks = this.calculateNonPreNumbreaks(this.text);
            this.breakOffset = this.calculateNonPreLinebreaks(this.text, this.numBreaks);
        }
    }

    void reverseText() {
        if (!this.isReversed) {
            this.isReversed = true;
            this.initializeText(this.text, 0, this.text.length);
        }
    }

    private void initializeText(String string) {
        this.initializeText(string.toCharArray(), 0, string.length());
    }

    private void initializeText(char[] cArray, int n, int n2) {
        this.text = new char[n2];
        if (this.isReversed) {
            for (int i = 0; i < n2; ++i) {
                this.text[i] = cArray[n + n2 - 1 - i];
            }
        } else {
            System.arraycopy(cArray, n, this.text, 0, n2);
        }
        this.init();
    }

    private int calculateNonPreNumbreaks(char[] cArray) {
        int n = 0;
        BreakIterator breakIterator = this.doc.getWordIterator();
        if (breakIterator != null) {
            breakIterator.setText(new String(cArray));
            breakIterator.first();
            while (breakIterator.next() != -1) {
                ++n;
            }
            if (n > 0) {
                --n;
            }
        } else {
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] != ' ' && cArray[i] != '\n' && cArray[i] != '\u200b') continue;
                ++n;
            }
        }
        return n;
    }

    private int calculatePreNumbreaks(char[] cArray) {
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\n') continue;
            ++n;
        }
        return n;
    }

    private int[] calculateNonPreLinebreaks(char[] cArray, int n) {
        if (n == 0) {
            return new int[0];
        }
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[n];
        BreakIterator breakIterator = this.doc.getWordIterator();
        if (breakIterator != null) {
            breakIterator.setText(new String(cArray));
        }
        while (n3 < cArray.length) {
            if (breakIterator != null) {
                int n4 = breakIterator.next();
                if (n4 == -1) break;
                n3 = n4;
            } else {
                while (n3 < cArray.length && cArray[n3] != ' ' && cArray[n3] != '\n' && cArray[n3] != '\u200b') {
                    ++n3;
                }
            }
            if (n3 >= cArray.length) break;
            if (cArray[n3] == '\n') {
                nArray[n2++] = -(++n3);
                continue;
            }
            if (cArray[n3] == '\u200b') {
                nArray[n2++] = ++n3;
                continue;
            }
            while (n3 < cArray.length && cArray[n3] == ' ') {
                ++n3;
            }
            nArray[n2++] = n3;
        }
        return nArray;
    }

    private int[] calculatePreLinebreaks(char[] cArray, int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\n') continue;
            nArray[n2++] = -i - 1;
        }
        return nArray;
    }

    boolean isEmpty() {
        return this.text.length == 1 && this.text[0] == ' ';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void normalize() {
        if (this.next != null && this.next.tagId == 92) {
            DTextNode dTextNode = (DTextNode)this.next;
            if (this.isPre == dTextNode.isPre) {
                StringBuffer stringBuffer;
                StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
                synchronized (stringBuffer2) {
                    stringBuffer.append(this.text);
                    do {
                        stringBuffer.append(dTextNode.text);
                        this.parent.removeDChild(dTextNode);
                        if (this.next == null || this.next.tagId != 92) break;
                        dTextNode = (DTextNode)this.next;
                    } while (this.isPre == dTextNode.isPre);
                    this.setData(stringBuffer.toString());
                }
            }
        }
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return "#text";
    }

    public String getNodeValue() {
        return this.getData();
    }

    public void setNodeValue(String string) {
        this.setData(string);
    }

    protected DNode appendDChild(DNode dNode) {
        return null;
    }

    protected DNode removeDChild(DNode dNode) {
        return null;
    }

    protected DNode getFirstDChild() {
        return null;
    }

    protected DNode getLastDChild() {
        return null;
    }

    public String getData() {
        return new String(this.text);
    }

    public void setData(String string) {
        int n = this.numBreaks;
        int n2 = this.text.length;
        int[] nArray = new int[this.numBreaks];
        System.arraycopy(this.breakOffset, 0, nArray, 0, this.breakOffset.length);
        this.initializeText(string);
        if (n != this.numBreaks || n2 != this.text.length) {
            this.doc.mutate();
        } else {
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == this.breakOffset[i]) continue;
                this.doc.mutate();
                break;
            }
        }
        DMutationEvent dMutationEvent = (DMutationEvent)this.doc.createDOMEvent(28);
        dMutationEvent.target = this;
        this.doc.processEvent(dMutationEvent);
    }

    public int getLength() {
        return this.text.length;
    }

    public String substringData(int n, int n2) {
        return new String(this.text, n, n2);
    }

    public void appendData(String string) {
        this.setData(this.getData() + string);
    }

    public void insertData(int n, String string) {
        String string2 = this.getData();
        string2 = string2.substring(0, n) + string + string2.substring(n);
        this.setData(string2);
    }

    public void deleteData(int n, int n2) {
    }

    public void replaceData(int n, int n2, String string) {
    }

    public Text splitText(int n) {
        return null;
    }

    public Node cloneNode(boolean bl) {
        return new DTextNode(this.doc, this.text, 0, this.text.length, this.isPre);
    }

    public String toString() {
        return this.getData();
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        int n = DTextNode.toDynamicId(string);
        if (n < 0) {
            return dynEnv.wrapMethod(this, string);
        }
        if (n > 0) {
            return this.getDynamicValue(n, dynEnv);
        }
        return super.getDynamicValue(string, dynEnv);
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n = DTextNode.toDynamicId(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.setDynamicValue(n, object, dynEnv);
        }
        return super.setDynamicValue(string, object, dynEnv);
    }

    public Object execDynamicMethod(String string, Object[] objectArray, DynEnv dynEnv) {
        int n = DTextNode.toDynamicId(string);
        if (n < 0) {
            return this.execDynamicMethod(n, objectArray, dynEnv);
        }
        return super.execDynamicMethod(string, objectArray, dynEnv);
    }

    private Object getDynamicValue(int n, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                return this.getData();
            }
            case 2: {
                return dynEnv.wrapInt(this.getLength());
            }
        }
        return null;
    }

    private int setDynamicValue(int n, Object object, DynEnv dynEnv) {
        if (n == 1) {
            this.setData(dynEnv.toStr(object));
            return 1;
        }
        if (n == 2) {
            return 1;
        }
        return 2;
    }

    private Object execDynamicMethod(int n, Object[] objectArray, DynEnv dynEnv) {
        switch (n) {
            case -1: {
                this.appendData(dynEnv.toStr(objectArray, 0));
                break;
            }
            case -2: {
                int n2 = dynEnv.toInt(objectArray, 0);
                int n3 = dynEnv.toInt(objectArray, 1);
                this.deleteData(n2, n3);
                break;
            }
            case -3: {
                int n4 = dynEnv.toInt(objectArray, 0);
                String string = dynEnv.toStr(objectArray, 1);
                this.insertData(n4, string);
                break;
            }
            case -4: {
                int n5 = dynEnv.toInt(objectArray, 0);
                int n6 = dynEnv.toInt(objectArray, 1);
                String string = dynEnv.toStr(objectArray, 2);
                this.replaceData(n5, n6, string);
                break;
            }
            case -5: {
                int n7 = dynEnv.toInt(objectArray, 0);
                return this.splitText(n7);
            }
            case -6: {
                int n8 = dynEnv.toInt(objectArray, 0);
                int n9 = dynEnv.toInt(objectArray, 1);
                return this.substringData(n8, n9);
            }
        }
        return dynEnv.wrapVoid();
    }

    private static int toDynamicId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 4: {
                string2 = "data";
                n = 1;
                break;
            }
            case 6: {
                string2 = "length";
                n = 2;
                break;
            }
            case 9: {
                string2 = "splitText";
                n = -5;
                break;
            }
            case 10: {
                char c = string.charAt(0);
                if (c == 'a') {
                    string2 = "appendData";
                    n = -1;
                    break;
                }
                if (c == 'd') {
                    string2 = "deleteData";
                    n = -2;
                    break;
                }
                if (c != 'i') break;
                string2 = "insertData";
                n = -3;
                break;
            }
            case 11: {
                string2 = "replaceData";
                n = -4;
                break;
            }
            case 13: {
                string2 = "substringData";
                n = -6;
                break;
            }
        }
        if (string2 != null && (string2 == string || string2.equals(string))) {
            return n;
        }
        return 0;
    }
}

