/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DIFrameElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ObjectPool;
import ice.storm.LPilot;
import ice.storm.Pilot;
import ice.storm.StormBase;
import ice.storm.Viewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;

public class EmbeddedObject
extends Viewport
implements ObjectPainter {
    private static int embed_counter = 0;
    private DElement element;
    ObjectBox box;
    private int defaultHeight = 10;
    private int defaultWidth = 10;
    private int aa = 0;

    EmbeddedObject(StormBase stormBase, DElement dElement) {
        super(stormBase, EmbeddedObject.getViewportName(dElement));
        this.element = dElement;
        this.element.getPilot().getPilotViewport().addChild(this);
    }

    private static String getViewportName(DElement dElement) {
        ++embed_counter;
        String string = dElement.getAttribute(63);
        if (string == null && (string = dElement.getAttribute(50)) == null) {
            string = "embed" + embed_counter;
        }
        return string;
    }

    void setDefaultSize(int n, int n2) {
        this.defaultWidth = n;
        this.defaultHeight = n2;
    }

    public void dispose() {
        Container container;
        if (this.container != null && (container = this.container.getParent()) != null) {
            container.remove(this.container);
        }
        this.element = null;
        this.box = null;
        super.dispose();
    }

    public void setForeground(Color color) {
    }

    public void setBackground(Color color) {
    }

    public void setBorderVisible(boolean bl) {
    }

    public void setFontHints(CSSAttribs cSSAttribs) {
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
        if (this.container != null) {
            this.element.getPilot().getCSSLayout().docPane.checkAwtTree(objectBox, this.container);
        }
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public void setPainterSize(int n, int n2) {
        if (this.container != null) {
            this.container.setSize(n, n2);
            return;
        }
        Pilot pilot = this.getPilot();
        if (pilot instanceof LPilot) {
            ((LPilot)pilot).setSize(n, n2);
        }
    }

    public int getPrefWidth() {
        if (this.container != null) {
            Dimension dimension = this.container.getPreferredSize();
            if (dimension != null) {
                return dimension.width;
            }
        } else {
            Pilot pilot = this.getPilot();
            if (pilot instanceof LPilot) {
                return ((LPilot)pilot).getWidth();
            }
        }
        return this.defaultWidth;
    }

    public int getPrefHeight() {
        if (this.container != null) {
            Dimension dimension = this.container.getPreferredSize();
            if (dimension != null) {
                return dimension.height;
            }
        } else {
            Pilot pilot = this.getPilot();
            if (pilot instanceof LPilot) {
                return ((LPilot)pilot).getHeight();
            }
        }
        return this.defaultHeight;
    }

    public void draw(Graphics graphics) {
        if (this.container != null) {
            if (this.container.isVisible()) {
                return;
            }
            graphics.setColor(Color.lightGray);
            Dimension dimension = this.container.getSize();
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        } else {
            Pilot pilot = this.getPilot();
            if (pilot instanceof LPilot) {
                if (this.aa == 0 && this.getPrefWidth() > 0) {
                    this.box.reqReflow();
                    this.box.reqRepaint();
                    this.aa = 1;
                } else {
                    ((LPilot)pilot).paint(graphics);
                }
            }
        }
    }

    public void setPilot(Pilot pilot) {
        if (pilot instanceof LPilot) {
            if (this.pilot != null) {
                this.removePilot();
            }
            this.pilot = pilot;
        } else {
            super.setPilot(pilot);
            Component component = this.getPilotComponent();
            if (component != null && this.container == null) {
                this.container = this.element.getPilot().getCSSLayout().docPane.createEmbeddedContainer(this, component);
            }
        }
    }

    public Container getContainer() {
        if (this.container == null) {
            return this.element.getPilot().getViewportContainer();
        }
        return this.container;
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        if (dAttr.nameId == 119 || dAttr.nameId == 45) {
            this.element.doc.mutate();
            this.element.doc.pilot.getCSSLayout().validateLayout();
        } else if (dElement.tagId == 45) {
            DIFrameElement dIFrameElement = (DIFrameElement)dElement;
            ObjectPool objectPool = dIFrameElement.getPilot().objectPool;
            objectPool.loadIFrame(dIFrameElement, this);
        }
    }
}

