/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ObjectPool;
import ice.pilots.html4.ThePilot;
import ice.util.Defs;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;

class ImageObjectPainter
implements ObjectPainter,
ImageObserver {
    private ObjectBox box;
    private Image image;
    private Image completedImage;
    private int iwidth = -1;
    private int iheight = -1;
    private boolean flagError = false;
    private boolean flagDone = false;
    private int forcedWidth = -1;
    private int forcedHeight = -1;
    private long lastPaintTime = System.currentTimeMillis();
    private static final long THROTTLE_DELAY = 50L;
    static final int NOTFOUND_WIDTH = 10;
    static final int NOTFOUND_HEIGHT = 10;
    private static boolean doReflow = !Defs.sysPropertyBoolean((String)"ice.pilots.html4.doNotReflowOnImages", (boolean)false);

    ImageObjectPainter(Image image) {
        this.image = image;
    }

    void setImage(Image image) {
        this.image = image;
        boolean bl = ThePilot.prepareImage(image, this);
        if (bl) {
            this.completedImage = image;
        }
        if (this.box != null) {
            this.box.reqRepaint();
        }
    }

    protected Image getImage() {
        return this.image;
    }

    public void dispose() {
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public void setPainterSize(int n, int n2) {
        this.forcedWidth = n;
        this.forcedHeight = n2;
    }

    public int getPrefWidth() {
        if (this.image != null && this.iwidth < 0) {
            this.iwidth = this.image.getWidth(this);
        }
        if (this.iwidth < 0) {
            return 10;
        }
        return this.iwidth;
    }

    public int getPrefHeight() {
        if (this.image != null && this.iheight < 0) {
            this.iheight = this.image.getHeight(this);
        }
        if (this.iheight < 0) {
            return 10;
        }
        return this.iheight;
    }

    public void setForeground(Color color) {
    }

    public void setBackground(Color color) {
    }

    public void setBorderVisible(boolean bl) {
    }

    public void setFontHints(CSSAttribs cSSAttribs) {
    }

    public void draw(Graphics graphics) {
        if (this.image == null || this.flagError) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, 9, 9);
            if (this.forcedWidth > 0 && this.forcedHeight > 0) {
                graphics.setColor(Color.gray);
                graphics.draw3DRect(0, 0, this.forcedWidth - 1, this.forcedHeight - 1, false);
            }
            graphics.setColor(Color.red);
            graphics.drawLine(2, 2, 7, 7);
            graphics.drawLine(2, 7, 7, 2);
            return;
        }
        if (this.iwidth < 0 && this.iheight < 0) {
            return;
        }
        if (this.forcedWidth == 0 || this.forcedHeight == 0) {
            return;
        }
        if (this.completedImage != null && this.completedImage != this.image) {
            ImageObjectPainter.paintImage(graphics, this.completedImage, null, this.iwidth, this.iheight, this.forcedWidth, this.forcedHeight);
        } else {
            ImageObjectPainter.paintImage(graphics, this.image, this, this.iwidth, this.iheight, this.forcedWidth, this.forcedHeight);
        }
    }

    private static void paintImage(Graphics graphics, Image image, ImageObserver imageObserver, int n, int n2, int n3, int n4) {
        if (n3 < 0 || n4 < 0 || n3 == n && n4 == n2) {
            graphics.drawImage(image, 0, 0, imageObserver);
        } else {
            graphics.drawImage(image, 0, 0, n3, n4, imageObserver);
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        block12: {
            try {
                ObjectBox objectBox = this.box;
                if (image != this.image || objectBox == null) {
                    return (n & 0xF0) == 0;
                }
                if ((n & 0xC0) != 0) {
                    this.flagError = true;
                    return false;
                }
                if (!((n & 3) == 0 || this.iwidth >= 0 && this.iheight >= 0 || this.flagDone)) {
                    ((CSSBox)objectBox).invalidate();
                    if (doReflow) {
                        ((CSSBox)objectBox).reqReflow();
                    }
                }
                if ((n & 0x20) != 0) {
                    DNode dNode = ((CSSBox)objectBox).getDomNode();
                    if (dNode != null) {
                        dNode.doc.processEvent(13, dNode);
                    }
                    this.flagDone = true;
                    ((CSSBox)objectBox).reqRepaint();
                    this.completedImage = this.image;
                }
                if ((n & 0x10) == 0) break block12;
                long l = System.currentTimeMillis() - this.lastPaintTime;
                if (l < 50L) {
                    try {
                        Thread.sleep(50L - l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.flagDone = true;
                this.completedImage = this.image;
                if (objectBox != null && objectBox.cssLayout != null && objectBox.cssLayout.doImageAnimation) {
                    ((CSSBox)objectBox).reqRepaint();
                }
                this.lastPaintTime = System.currentTimeMillis();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        int n = dAttr.nameId;
        if (n == 102 || n == 119 || n == 45) {
            String string;
            Image image;
            ObjectPool objectPool = dElement.getPilot().objectPool;
            String string2 = dAttr.getValue();
            if (string2 != null && (image = objectPool.loadImage(string = dElement.doc.resolveUrl(string2))) != null) {
                this.setImage(image);
            }
        }
    }
}

