/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.SimpleSelector;

class Selector {
    byte pseudo = 0;
    int weight = 0;
    private SimpleSelector[] simpleSelectors = new SimpleSelector[10];
    private int numSelectors = 0;

    Selector() {
    }

    int getSelectorKey() {
        return this.simpleSelectors[this.numSelectors - 1].elementNameId;
    }

    String getUniversalClassKey() {
        return this.simpleSelectors[this.numSelectors - 1].getUniversalClassKey();
    }

    boolean isEmpty() {
        return this.numSelectors == 0;
    }

    void addSimpleSelector(SimpleSelector simpleSelector) {
        this.pseudo = (byte)(this.pseudo | simpleSelector.pseudo);
        int n = this.numSelectors;
        if (n == this.simpleSelectors.length) {
            SimpleSelector[] simpleSelectorArray = new SimpleSelector[n * 2 + 1];
            System.arraycopy(this.simpleSelectors, 0, simpleSelectorArray, 0, n);
            this.simpleSelectors = simpleSelectorArray;
        }
        this.simpleSelectors[n] = simpleSelector;
        this.numSelectors = n + 1;
    }

    int computeWeight() {
        for (int i = 0; i != this.numSelectors; ++i) {
            SimpleSelector simpleSelector = this.simpleSelectors[i];
            this.weight += simpleSelector.computeWeight();
        }
        return this.weight;
    }

    boolean match(DElement dElement) {
        int n = this.numSelectors - 1;
        SimpleSelector simpleSelector = this.simpleSelectors[n];
        if (!simpleSelector.match(dElement)) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        return this.matchSimpleSelector_r(dElement, n - 1);
    }

    private final boolean matchSimpleSelector_r(DElement dElement, int n) {
        SimpleSelector simpleSelector = this.simpleSelectors[n];
        int n2 = simpleSelector.combinator;
        if (n2 == 62) {
            DNode dNode = dElement.getParentDNode();
            if (!(dNode instanceof DElement)) {
                return false;
            }
            dElement = (DElement)dNode;
            if (!simpleSelector.match(dElement)) {
                return false;
            }
        } else if (n2 == 43) {
            DNode dNode;
            for (dNode = dElement.getPreviousDSibling(); dNode != null && !(dNode instanceof DElement); dNode = dNode.getPreviousDSibling()) {
            }
            if (dNode == null) {
                return false;
            }
            dElement = (DElement)dNode;
            if (!simpleSelector.match(dElement)) {
                return false;
            }
        } else if (n2 == 32) {
            for (DNode dNode = dElement.getParentDNode(); dNode != null; dNode = dNode.getParentDNode()) {
                if (!(dNode instanceof DElement)) {
                    return false;
                }
                if (!simpleSelector.match((DElement)dNode)) continue;
                if (n == 0) {
                    return true;
                }
                if (!this.matchSimpleSelector_r((DElement)dNode, n - 1)) continue;
                return true;
            }
            return false;
        }
        if (n == 0) {
            return true;
        }
        return this.matchSimpleSelector_r(dElement, n - 1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.numSelectors; ++i) {
            stringBuffer.append(this.simpleSelectors[i]);
        }
        return stringBuffer.toString();
    }
}

