/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSMatcher;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.EmbeddedObject;
import ice.pilots.html4.FramesDivider;
import ice.pilots.html4.FramesetData;
import ice.pilots.html4.FramesetInfo;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.StormData;
import ice.pilots.html4.TableBox;
import ice.pilots.html4.TableRowGroupBox;
import ice.pilots.html4.ThePilot;
import ice.storm.Viewport;
import ice.storm.print.AbstractStormPrinter;
import ice.storm.print.PageDecoration;
import ice.storm.print.StormPageFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

class ThePrinter
extends AbstractStormPrinter {
    private Vector pageLayoutCache = new Vector();
    private HTMLDocument htmlDocument;
    private Vector naturalPageBreaks = new Vector();
    private Vector forcedPageBreaks = new Vector();
    private Vector naturalTablePageBreaks = new Vector();
    private int originalWidth = 0;
    private Vector viewports = null;
    private Viewport viewport = null;
    private int zoom = 256;

    protected ThePrinter(StormData stormData, DDocument dDocument, CSSMatcher cSSMatcher) {
        this.htmlDocument = new HTMLDocument(stormData, dDocument, cSSMatcher);
        this.htmlDocument.layout((int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        this.originalWidth = this.htmlDocument.getWidth();
    }

    protected ThePrinter(CSSLayout cSSLayout) {
        this.htmlDocument = (HTMLDocument)cSSLayout;
        this.htmlDocument.setPrintBack(this.pageFormat.isBackgroundVisible());
        this.htmlDocument.layout((int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
    }

    protected ThePrinter(CSSLayout cSSLayout, Viewport viewport) {
        this.viewports = new Vector();
        viewport.getViewAndAllChildren(this.viewports);
        this.viewport = viewport;
        this.htmlDocument = (HTMLDocument)cSSLayout;
        if (viewport.getPilot() instanceof ThePilot) {
            ThePilot thePilot = (ThePilot)viewport.getPilot();
            FramesetData framesetData = thePilot.framesetData;
            if (framesetData != null) {
                framesetData.layout(0, 0, (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
            }
        }
        this.htmlDocument.setPrintBack(this.pageFormat.isBackgroundVisible());
        this.htmlDocument.layout((int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
    }

    public void printPage(Graphics graphics, int n) {
        if (this.numberOfPages > 0) {
            if (n < 0) {
                n = 0;
            } else if (n > this.numberOfPages - 1) {
                n = this.numberOfPages - 1;
            }
            Graphics graphics2 = graphics.create((int)this.pageFormat.getMargin(2), (int)this.pageFormat.getMargin(1), (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
            Point[] pointArray = (Point[])this.pageLayoutCache.elementAt(n);
            graphics2.setClip(0, 0, pointArray[1].x - pointArray[0].x, pointArray[2].y - pointArray[0].y);
            graphics2.translate(-pointArray[0].x, -pointArray[0].y);
            this.htmlDocument.setImageablePrintArea(pointArray[0].x, pointArray[0].y, (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
            this.htmlDocument.paint(graphics2);
            this.paintChildViewports(this.viewport, graphics2, null);
            graphics2.dispose();
            Graphics graphics3 = graphics.create(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
            graphics3.translate(0, 0);
            graphics3.setClip(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
            Vector vector = this.pageFormat.getDecoration();
            for (int i = vector.size() - 1; i >= 0; --i) {
                PageDecoration pageDecoration = (PageDecoration)vector.elementAt(i);
                pageDecoration.paint(graphics3, n, this.numberOfPages, this.pageFormat);
            }
            graphics3.dispose();
        } else {
            graphics.setColor(Color.black);
            graphics.setFont(new Font("dialog", 0, 14));
            graphics.drawString("No renderable content", (int)this.pageFormat.getImageableWidth() / 2, (int)this.pageFormat.getImageableHeight() / 2);
        }
    }

    private void paintFrameset(FramesetInfo framesetInfo, Graphics graphics, int n, int n2) {
        graphics.setColor(Color.lightGray);
        graphics.fillRect(n, n2, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
        int n3 = 4;
        int n4 = 4;
        int n5 = n;
        int n6 = n2;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (int i = 0; i < framesetInfo.children.size(); ++i) {
            Object object;
            n7 = framesetInfo.viewportSizes[n9];
            n8 = framesetInfo.viewportSizes[n9 + 1];
            n9 = 2;
            if (framesetInfo.children.elementAt(i) instanceof Viewport) {
                object = (Viewport)framesetInfo.children.elementAt(i);
                n3 = ((FramesDivider)framesetInfo.framesetDividers.elementAt((int)i)).x_width;
                n4 = ((FramesDivider)framesetInfo.framesetDividers.elementAt((int)i)).y_width;
                if (((Viewport)object).getPilot() instanceof ThePilot) {
                    ThePilot thePilot = (ThePilot)((Viewport)object).getPilot();
                    Rectangle rectangle = new Rectangle(n5, n6, n7, n8);
                    int n10 = this.zoom;
                    thePilot.getCSSLayout().setLayoutZoom(n10);
                    thePilot.getCSSLayout().layout(rectangle.width, rectangle.height);
                    if (this.pageFormat.isScaleToFitEnabled()) {
                        double d = 1.0 / (double)thePilot.getCSSLayout().getWidth() * (double)rectangle.width;
                        n10 = (int)Math.round(256.0 * d);
                        thePilot.getCSSLayout().setLayoutZoom(n10);
                        thePilot.getCSSLayout().layout(rectangle.width, rectangle.height);
                    }
                    Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    thePilot.getCSSLayout().paint(graphics2);
                    graphics2.dispose();
                }
            } else if (framesetInfo.children.elementAt(i) instanceof FramesetInfo) {
                object = (FramesetInfo)framesetInfo.children.elementAt(i);
                this.paintFrameset((FramesetInfo)object, graphics, n5, n6);
            }
            if (framesetInfo.getOrientation() == 2) {
                n5 += n7 + n3;
                continue;
            }
            if (framesetInfo.getOrientation() != 1) continue;
            n6 += n8 + n4;
        }
    }

    private void paintChildViewports(Viewport viewport, Graphics graphics, Rectangle rectangle) {
        FramesetData framesetData;
        Object object;
        if (viewport.getPilot() instanceof ThePilot) {
            object = (ThePilot)viewport.getPilot();
            framesetData = ((ThePilot)object).framesetData;
            if (framesetData != null) {
                if (rectangle != null) {
                    framesetData.layout(0, 0, rectangle.width, rectangle.height);
                } else {
                    framesetData.layout(0, 0, (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
                }
                this.paintFrameset(framesetData.frameset, graphics, 0, 0);
            }
        }
        object = viewport.getChildren();
        while (object != null && object.hasMoreElements()) {
            EmbeddedObject embeddedObject;
            framesetData = object.nextElement();
            if (!(framesetData instanceof EmbeddedObject) || !((embeddedObject = (EmbeddedObject)((Object)framesetData)).getPilot() instanceof ThePilot)) continue;
            ThePilot thePilot = (ThePilot)embeddedObject.getPilot();
            thePilot.getCSSLayout().setLayoutZoom(this.zoom);
            ObjectBox objectBox = embeddedObject.getBox();
            Rectangle rectangle2 = new Rectangle();
            objectBox.findAbsolutePosition(rectangle2);
            thePilot.getCSSLayout().layout(rectangle2.width, rectangle2.height);
            Graphics graphics2 = graphics.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            FramesetData framesetData2 = thePilot.framesetData;
            if (framesetData2 != null) {
                this.paintChildViewports(thePilot.getPilotViewport(), graphics2, rectangle2);
            } else {
                thePilot.getCSSLayout().paint(graphics2);
            }
            graphics2.dispose();
        }
    }

    public Dimension getDimension() {
        return new Dimension(this.htmlDocument.getWidth(), this.htmlDocument.getHeight());
    }

    public void print(Graphics graphics) {
        Graphics graphics2 = graphics.create(0, 0, this.htmlDocument.getWidth(), this.htmlDocument.getHeight());
        this.htmlDocument.setImageablePrintArea(0, 0, this.htmlDocument.getWidth(), this.htmlDocument.getHeight());
        this.htmlDocument.paint(graphics2);
        this.paintChildViewports(this.viewport, graphics2, null);
        graphics2.dispose();
    }

    public void dispose() {
        this.htmlDocument.clear();
    }

    public void setStormPageFormat(StormPageFormat stormPageFormat) {
        this.htmlDocument.setPrintBack(stormPageFormat.isBackgroundVisible());
        super.setStormPageFormat(stormPageFormat);
    }

    public void setZoom(int n) {
        double d = (double)Math.abs(n) / 256.0;
        this.pageFormat.setScale(d);
        this.zoom = n;
        this.getPageCount();
    }

    public void paintCallback(Graphics graphics, ObjectPainter objectPainter) {
        this.htmlDocument.paintCallback(graphics, objectPainter);
    }

    public int getPageCount() {
        if (this.pageFormat == null) {
            this.pageFormat = new StormPageFormat();
        }
        if (this.pageFormat.hasImageableAreaChanged()) {
            Point[] pointArray;
            int n;
            if (this.pageFormat.isScaleToFitEnabled()) {
                double d = 1.0 / (double)this.originalWidth * this.pageFormat.getImageableWidth();
                this.pageFormat.setScale(d);
            }
            this.zoom = n = (int)Math.round(256.0 * this.pageFormat.getScale());
            this.htmlDocument.setLayoutZoom(this.zoom);
            this.htmlDocument.layout((int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
            this.pageLayoutCache = new Vector(5);
            this.naturalPageBreaks = new Vector(5);
            this.forcedPageBreaks = new Vector(5);
            this.naturalTablePageBreaks = new Vector(5);
            this.recordHorizontalPageBreaks(this.htmlDocument.topBox, 0);
            this.naturalPageBreaks = this.sortPageBreaks(this.naturalPageBreaks);
            int n2 = 0;
            Point[] pointArray2 = new Point[]{new Point(0, 0), new Point((int)this.pageFormat.getImageableWidth(), 0)};
            while (n2 < this.htmlDocument.getHeight()) {
                n2 = this.findHorizontalPageBreak(n2, (int)this.pageFormat.getImageableHeight());
                pointArray = new Point[]{new Point(pointArray2[0].x, pointArray2[0].y), new Point(pointArray2[1].x, pointArray2[1].y), new Point(0, n2), new Point((int)this.pageFormat.getImageableWidth(), n2)};
                this.pageLayoutCache.addElement(pointArray);
                pointArray2[0] = new Point(pointArray[2].x, pointArray[2].y);
                pointArray2[1] = new Point(pointArray[3].x, pointArray[3].y);
            }
            this.naturalPageBreaks = null;
            this.forcedPageBreaks = null;
            pointArray = (Point[])this.pageLayoutCache.clone();
            if (pointArray.size() > 0) {
                int n3 = 0;
                for (int i = 0; i < this.pageLayoutCache.size(); ++i) {
                    Point[] pointArray3;
                    Point[] pointArray4 = (Point[])this.pageLayoutCache.elementAt(i);
                    Vector vector = new Vector(10);
                    VerticalTablePageBreaks verticalTablePageBreaks = new VerticalTablePageBreaks(0, 0, 0, 0, null);
                    for (int j = 0; j < this.naturalTablePageBreaks.size(); ++j) {
                        VerticalTablePageBreaks verticalTablePageBreaks2 = (VerticalTablePageBreaks)this.naturalTablePageBreaks.elementAt(j);
                        if (!verticalTablePageBreaks2.contains(pointArray4) || verticalTablePageBreaks2.getTotalWidth() <= verticalTablePageBreaks.getTotalWidth()) continue;
                        verticalTablePageBreaks = verticalTablePageBreaks2;
                        pointArray3 = verticalTablePageBreaks.getColumnBreaks().elements();
                        while (pointArray3.hasMoreElements()) {
                            vector.addElement(pointArray3.nextElement());
                        }
                    }
                    vector = this.sortPageBreaks(vector);
                    if (!((double)verticalTablePageBreaks.getTotalWidth() > this.pageFormat.getImageableWidth())) continue;
                    Vector vector2 = verticalTablePageBreaks.getColumnBreaks();
                    if (vector2 != null) {
                        n2 = 0;
                        pointArray2[0] = pointArray4[1];
                        pointArray2[1] = pointArray4[3];
                        int n4 = 0;
                        while (n2 <= verticalTablePageBreaks.getTotalWidth()) {
                            n2 = this.findVerticalPageBreak(n2, (int)this.pageFormat.getImageableWidth(), vector);
                            if (n4 == 0) {
                                pointArray4[1].x = n2;
                                pointArray4[3].x = n2;
                                pointArray2[0] = pointArray4[1];
                                pointArray2[1] = pointArray4[3];
                            } else {
                                pointArray3 = new Point[]{pointArray2[0], new Point(n2, pointArray2[0].y), pointArray2[1], new Point(n2, pointArray2[1].y)};
                                pointArray.insertElementAt(pointArray3, n3 + 1);
                                ++n3;
                                pointArray2[0] = pointArray3[1];
                                pointArray2[1] = pointArray3[3];
                            }
                            ++n4;
                        }
                    }
                    ++n3;
                }
                this.pageLayoutCache = pointArray;
                this.numberOfPages = this.pageLayoutCache.size();
                this.currentPageIndex = -1;
                this.pageFormat.setImageableAreaChangedFlag(false);
            }
        }
        return this.numberOfPages;
    }

    public int getZoom() {
        if (this.pageFormat.isScaleToFitEnabled()) {
            double d = 1.0 / (double)this.originalWidth * this.pageFormat.getImageableWidth();
            this.pageFormat.setScale(d);
        }
        return (int)Math.round(this.pageFormat.getScale() * 256.0);
    }

    protected CSSLayout getCSSLayout() {
        return this.htmlDocument.getCSSLayout();
    }

    private int findHorizontalPageBreak(int n, int n2) {
        if (this.forcedPageBreaks.size() > 0) {
            for (int i = 0; i < this.forcedPageBreaks.size(); ++i) {
                int n3 = (Integer)this.forcedPageBreaks.elementAt(i);
                if (n3 <= n || n3 > n + n2) continue;
                return n3;
            }
            return n + n2;
        }
        if (this.pageFormat.isHtmlSmartPagingEnabled()) {
            for (int i = 0; i < this.naturalPageBreaks.size() - 1; ++i) {
                int n4 = (Integer)this.naturalPageBreaks.elementAt(i);
                int n5 = (Integer)this.naturalPageBreaks.elementAt(i + 1);
                if (n4 <= n || n4 >= n + n2 || n4 <= n + n2 / 4 || n5 <= n + n2 || n5 >= n + n2 + n2) continue;
                return n4;
            }
        }
        return n + n2;
    }

    private int findVerticalPageBreak(int n, int n2, Vector vector) {
        if (vector.size() > 0 && this.pageFormat.isHtmlSmartPagingEnabled()) {
            for (int i = 0; i < vector.size() - 1; ++i) {
                double d;
                int n3 = (Integer)vector.elementAt(i);
                int n4 = (Integer)vector.elementAt(i + 1);
                if (n3 <= n || n3 >= n + n2 || n4 <= n + n2 || n4 >= n + n2 + n2 || !((d = (double)(n3 - n) / (double)n2) > 0.5)) continue;
                return n3;
            }
        }
        return n + n2;
    }

    private void recordHorizontalPageBreaks(CSSBox cSSBox, int n) {
        block18: {
            Point point;
            block17: {
                if (!(cSSBox instanceof TableBox)) break block17;
                TableBox tableBox = (TableBox)cSSBox;
                if ((double)tableBox.width > this.pageFormat.getImageableWidth() && tableBox.colWidth != null) {
                    this.naturalTablePageBreaks.addElement(new VerticalTablePageBreaks(tableBox));
                }
                CSSBox cSSBox2 = tableBox.getfirstRowGroup();
                while (cSSBox2 != null && cSSBox2 instanceof TableRowGroupBox) {
                    CSSBox cSSBox3 = ((TableRowGroupBox)cSSBox2).firstRow;
                    CSSBox cSSBox4 = ((TableRowGroupBox)cSSBox2).lastRow;
                    while (cSSBox3 != null) {
                        int n2;
                        Point point2 = new Point();
                        cSSBox3.findAbsolutePosition(point2);
                        int n3 = 0;
                        int n4 = 0;
                        if (tableBox.element != null) {
                            n3 = tableBox.element.getAttributeAsInt("border");
                            n4 = tableBox.element.getAttributeAsInt("cellspacing");
                        }
                        if ((n2 = tableBox.css.border_top_width) == 0) {
                            n2 = n3;
                        }
                        this.naturalPageBreaks.addElement(new Integer(point2.y - (n2 += n4)));
                        int n5 = 0;
                        if (cSSBox3.equals(cSSBox4)) {
                            n5 = tableBox.css.border_bottom_width;
                            if (n5 == 0) {
                                n5 = n3;
                            }
                            n5 += n4;
                            this.naturalPageBreaks.addElement(new Integer(point2.y + cSSBox3.height));
                        } else {
                            this.naturalPageBreaks.addElement(new Integer(point2.y + cSSBox3.height));
                        }
                        CSSBox cSSBox5 = cSSBox3.getFirstChild();
                        while (cSSBox5 != null) {
                            CSSBox cSSBox6 = ((BlockBox)cSSBox5).first;
                            while (cSSBox6 != null) {
                                if (cSSBox6 != null && cSSBox6 instanceof TableBox) {
                                    this.recordHorizontalPageBreaks(cSSBox6, n++);
                                }
                                cSSBox6 = cSSBox6.next;
                            }
                            cSSBox5 = cSSBox5.next;
                        }
                        cSSBox3 = cSSBox3.next;
                    }
                    cSSBox2 = cSSBox2.next;
                }
                break block18;
            }
            if (!(cSSBox instanceof BlockBox)) break block18;
            BlockBox blockBox = (BlockBox)cSSBox;
            int n6 = blockBox.css.getPageBreak(0);
            int n7 = blockBox.css.getPageBreak(1);
            if (n6 != 0 || n7 != 0) {
                point = new Point();
                blockBox.findAbsolutePosition(point);
                point.y -= blockBox.css.border_top_width;
                if (n6 == 1) {
                    this.forcedPageBreaks.addElement(new Integer(point.y));
                }
                if (n7 == 1) {
                    this.forcedPageBreaks.addElement(new Integer(point.y + blockBox.height));
                }
            }
            point = new Point();
            blockBox.findAbsolutePosition(point);
            this.naturalPageBreaks.addElement(new Integer(point.y));
            int n8 = 0;
            int n9 = 0;
            int n10 = point.y;
            int n11 = point.y;
            while (n9 < 10 && n8 + 3 < blockBox.lines.length) {
                int n12 = blockBox.lines[n8 + 2];
                if ((n10 += n12) != n11) {
                    n11 = n10;
                    this.naturalPageBreaks.addElement(new Integer(n10));
                }
                n8 += 3;
            }
            this.naturalPageBreaks.addElement(new Integer(point.y + blockBox.height));
            CSSBox cSSBox7 = blockBox.first;
            while (cSSBox7 != null) {
                this.recordHorizontalPageBreaks(cSSBox7, n++);
                cSSBox7 = cSSBox7.next;
            }
        }
    }

    private Vector sortPageBreaks(Vector vector) {
        for (int i = vector.size() - 1; i >= 0; --i) {
            boolean bl = false;
            for (int j = 0; j < i; ++j) {
                int n;
                int n2 = (Integer)vector.elementAt(j);
                if (n2 <= (n = ((Integer)vector.elementAt(j + 1)).intValue())) continue;
                vector.removeElementAt(j);
                vector.insertElementAt(new Integer(n), j);
                vector.removeElementAt(j + 1);
                vector.insertElementAt(new Integer(n2), j + 1);
                bl = true;
            }
            if (!bl) break;
        }
        return vector;
    }

    class HTMLDocument
    extends CSSLayout {
        HTMLDocument(StormData stormData, DDocument dDocument, CSSMatcher cSSMatcher) {
            super(stormData, dDocument, cSSMatcher);
            this.inPrintMode = true;
            this.doc = dDocument;
        }

        void paintCallback(Graphics graphics, ObjectPainter objectPainter) {
            if (objectPainter instanceof Component) {
                ((Component)((Object)objectPainter)).printAll(graphics);
            } else if (objectPainter instanceof EmbeddedObject) {
                Component component = ((EmbeddedObject)objectPainter).getPilotComponent();
                if (component != null && component.getSize().width > 2 && component.getSize().height > 2) {
                    component.printAll(graphics);
                } else {
                    super.paintCallback(graphics, objectPainter);
                }
            } else {
                super.paintCallback(graphics, objectPainter);
            }
        }

        CSSLayout getCSSLayout() {
            return this;
        }

        void setImageablePrintArea(int n, int n2, int n3, int n4) {
            super.setImageablePrintArea(new Rectangle(n, n2, n3, n4));
        }
    }

    class VerticalTablePageBreaks {
        private int x;
        private int y;
        private int width;
        private int height;
        private Vector columnBreaks;

        VerticalTablePageBreaks(int n, int n2, int n3, int n4, Vector vector) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.columnBreaks = vector;
        }

        VerticalTablePageBreaks(TableBox tableBox) {
            int n;
            this.x = tableBox.ox;
            this.y = tableBox.oy;
            this.width = tableBox.width;
            this.height = tableBox.height;
            int[] nArray = tableBox.colWidth;
            this.columnBreaks = new Vector(nArray.length);
            int n2 = this.x;
            int n3 = tableBox.element.getAttributeAsInt("cellspacing");
            int n4 = tableBox.css.border_left_width;
            if (n4 == 0) {
                n4 = tableBox.element.getAttributeAsInt("border");
            }
            if ((n = tableBox.css.border_right_width) == 0) {
                n = tableBox.element.getAttributeAsInt("border");
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (i == 0) {
                    n2 += n4 + n3 + nArray[i];
                    if (nArray.length == 1) {
                        n2 += n3 + n;
                    }
                    this.columnBreaks.addElement(new Integer(n2));
                    continue;
                }
                if (i == nArray.length - 1) {
                    this.columnBreaks.addElement(new Integer(n2 += nArray[i] + n3 + n + n3));
                    continue;
                }
                this.columnBreaks.addElement(new Integer(n2 += nArray[i] + n3));
            }
        }

        public boolean contains(Point[] pointArray) {
            boolean bl = false;
            if (pointArray == null) {
                throw new NullPointerException();
            }
            int n = pointArray[0].y;
            int n2 = pointArray[2].y;
            int n3 = pointArray[0].x;
            int n4 = pointArray[1].x;
            if ((this.y >= n & this.y < n2 || this.y < n & (this.y + this.height >= n2 || this.y + this.height < n2 & this.y + this.height >= n)) && (this.x >= n3 & this.x < n4 || this.x < n3 & (this.x + this.width >= n3 || this.x + this.width < n4 & this.x + this.height >= n3))) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            String string = "";
            string = string + "Table x=" + this.x + " y=" + this.y + " w=" + this.width + " h=" + this.height + " ";
            string = string + "Colum Breaks: ";
            Enumeration enumeration = this.columnBreaks.elements();
            while (enumeration.hasMoreElements()) {
                string = string + (Integer)enumeration.nextElement() + " ";
            }
            return string;
        }

        public void setX(int n) {
            this.x = n;
        }

        public int getTableArea() {
            return this.width * this.height;
        }

        public int getTotalWidth() {
            return this.x + this.width;
        }

        public void setColumnBreaks(Vector vector) {
            this.columnBreaks = vector;
        }

        public void setHeight(int n) {
            this.height = n;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public void setY(int n) {
            this.y = n;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public Vector getColumnBreaks() {
            return this.columnBreaks;
        }
    }
}

