/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.debug.Debug;
import ice.pilots.html4.AccessibleHyperPanel;
import ice.pilots.html4.ComponentFactory;
import ice.pilots.html4.Html4DocumentAccess;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ScreenReaderStatusComponent;
import ice.pilots.html4.swing.AccessibleHypertextPanel;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import ice.pilots.html4.swing.SwingScreenReaderStatusPanel;
import ice.util.Defs;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

class DocPanel
extends JPanel {
    DocView docView;
    int sx = 0;
    int sy = 0;
    int nsx = 0;
    int nsy = 0;
    private int selectButton = 0;
    private int scrollButton = 1;
    private int scrollMouseX = -1;
    private int scrollMouseY = -1;
    private int selectMouseX = -1;
    private int selectMouseY = -1;
    private int scrollHeight = 14;
    private int scrollTimeout = 100;
    private long scrollTimestamp;
    private int lastDraggedY;
    private boolean afterScrollBarShowHide = false;

    DocPanel(DocView docView) {
        this.docView = docView;
        this.enableEvents(60L);
        this.setLayout(null);
        this.scrollHeight = Defs.sysPropertyInt((String)"ice.pilots.html4.scrollHeight", (int)this.scrollHeight);
        this.scrollTimeout = Defs.sysPropertyInt((String)"ice.pilots.html4.scrollTimeout", (int)this.scrollTimeout);
        String string = Defs.sysProperty((String)"ice.pilots.html4.selectButton");
        if (!docView.enableTextSelection) {
            string = "none";
        }
        this.selectButton = ComponentFactory.parseButton(string, this.selectButton);
        string = Defs.sysProperty((String)"ice.pilots.html4.scrollButton");
        this.scrollButton = ComponentFactory.parseButton(string, this.scrollButton);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isManagingFocus() {
        return true;
    }

    void scrollLightweightChildren() {
        int n = this.getComponentCount();
        try {
            for (int i = 0; i < n; ++i) {
                Component component = this.getComponent(i);
                if (component == null || !(component instanceof JComponent)) continue;
                if (component instanceof Movable) {
                    Movable movable = (Movable)((Object)component);
                    ObjectBox objectBox = movable.getBox();
                    if (objectBox == null) continue;
                    Point point = new Point(0, 0);
                    objectBox.findAbsolutePosition(point);
                    movable.syncDom(point.x - this.sx, point.y - this.sy, objectBox.checkIfVisible());
                    continue;
                }
                if (component.isVisible()) continue;
                component.setVisible(true);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = dimension.width <= 0 ? DocView.headlessLayoutWidth : dimension.width;
        int n2 = dimension.height <= 0 ? DocView.headlessLayoutHeight : dimension.height;
        this.doLayout(n, n2);
    }

    public void doLayout(int n, int n2) {
        if (this.docView.isPilotDisposed()) {
            return;
        }
        this.docView.docLayout(n, n2);
        JScrollBar jScrollBar = this.docView.vbar;
        JScrollBar jScrollBar2 = this.docView.hbar;
        JPanel jPanel = this.docView.spacer;
        Color color = this.docView.spacerBackColor;
        if (jScrollBar != null && this.isVisible()) {
            int n3 = jScrollBar.getValue();
            int n4 = n2;
            int n5 = this.docView.getDocHeight();
            if (n4 > n5) {
                n4 = n5;
            }
            if (n3 + n4 > n5) {
                this.sy = this.nsy = (n3 = n5 - n4);
            }
            jScrollBar.setValues(n3, n4, 0, n5);
            jScrollBar.setBlockIncrement(n4);
            jScrollBar.setUnitIncrement(20);
            int n6 = jScrollBar2.getValue();
            int n7 = this.docView.getDocWidth();
            int n8 = n;
            if (n8 > n7) {
                n8 = n7;
            }
            if (n6 + n8 > n7) {
                this.sx = this.nsx = (n6 = n7 - n8);
            }
            jScrollBar2.setValues(n6, n8, 0, n7);
            jScrollBar2.setBlockIncrement(n8);
            jScrollBar2.setUnitIncrement(20);
            boolean bl = false;
            if (n5 <= n4) {
                if (jScrollBar.isVisible() && this.docView.validateTreeNesting <= 1) {
                    jScrollBar.setVisible(false);
                    bl = true;
                }
            } else if (!jScrollBar.isVisible()) {
                jScrollBar.setVisible(true);
                bl = true;
            }
            if (n7 <= n8) {
                if (jScrollBar2.isVisible() && this.docView.validateTreeNesting <= 1) {
                    jScrollBar2.setVisible(false);
                    bl = true;
                }
            } else if (!jScrollBar2.isVisible()) {
                jScrollBar2.setVisible(true);
                bl = true;
            }
            if (bl) {
                if (this.docView.fVerticalScrollbarSpacer) {
                    if (jScrollBar.isVisible()) {
                        if (jScrollBar2.isVisible()) {
                            this.docView.southPanel.add((Component)jPanel, "East");
                            jPanel.setVisible(true);
                            jPanel.setBackground(color);
                        } else {
                            jPanel.setVisible(false);
                        }
                    } else {
                        this.docView.eastPanel.add((Component)jPanel, "South");
                        jPanel.setVisible(true);
                        jPanel.setBackground(Color.white);
                    }
                }
                this.docView._panePanel.validateTree();
                return;
            }
        }
        this.docView.docPostLayout();
        this.scrollLightweightChildren();
    }

    void scroll(int n, int n2) {
        if (!this.docView.canScroll(n, n2)) {
            return;
        }
        this.nsx = n;
        this.nsy = n2;
        this.sx = this.nsx;
        this.sy = this.nsy;
        this.scrollLightweightChildren();
        this.repaint();
    }

    public AccessibleContext getAccessibleContext() {
        if (!DocView.isAccessible) {
            return null;
        }
        if (this.accessibleContext == null) {
            Object object;
            if (DocView.accessibility.equalsIgnoreCase("java")) {
                object = new AccessibleHypertextPanel(this.docView, super.getAccessibleContext());
                SwingScreenReaderStatusPanel swingScreenReaderStatusPanel = new SwingScreenReaderStatusPanel();
                this.docView._panePanel.add((Component)swingScreenReaderStatusPanel, "North");
                swingScreenReaderStatusPanel.setVisible(false);
                ((AccessibleHypertextPanel)object).setAccessibleStatus(swingScreenReaderStatusPanel);
                this.accessibleContext = object;
            }
            if (DocView.accessibility.equalsIgnoreCase("jaws")) {
                object = new SwingScreenReaderStatusPanel();
                this.docView._panePanel.add((Component)object, "North");
                ((JComponent)object).setVisible(false);
                this.accessibleContext = new AccessibleHyperPanel(this.docView.getPilot(), super.getAccessibleContext(), (ScreenReaderStatusComponent)object);
            }
        }
        if (Debug.trace) {
            Debug.trace((String)("AccessibleContext <" + DocView.accessibility + " > created for " + this));
        }
        return this.accessibleContext;
    }

    public void paintComponent(Graphics graphics) {
        if (this.docView.isPilotDisposed()) {
            return;
        }
        long l = System.currentTimeMillis();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
            rectangle = graphics.getClipBounds();
        }
        this.paintInto(graphics, rectangle);
        this.scrollLightweightChildren();
        l = System.currentTimeMillis() - l;
    }

    private void paintInto(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.white);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.translate(-this.sx, -this.sy);
        graphics.setClip(rectangle.x + this.sx, rectangle.y + this.sy, rectangle.width, rectangle.height);
        this.docView.docPaint(graphics);
        graphics.translate(this.sx, this.sy);
        this.docView.docPaintFixed(graphics);
    }

    private void mouseDragged(MouseEvent mouseEvent) {
        this.lastDraggedY = mouseEvent.getY();
        if (this.isButtonDown(this.scrollButton, mouseEvent)) {
            if (this.scrollMouseX >= 0) {
                int n = this.scrollMouseX - mouseEvent.getX();
                int n2 = this.scrollMouseY - mouseEvent.getY();
                if (Math.abs(n) > Math.abs(n2)) {
                    n2 = 0;
                } else {
                    n = 0;
                }
                this.docView.setScrollPosition(this.sx + n, this.sy + n2);
            }
            this.scrollMouseX = mouseEvent.getX();
            this.scrollMouseY = mouseEvent.getY();
        } else if (this.isButtonDown(this.selectButton, mouseEvent)) {
            if (this.selectMouseX >= 0) {
                int n = 0;
                if (mouseEvent.getY() > this.getSize().height) {
                    n = this.scrollHeight;
                } else if (mouseEvent.getY() < 0) {
                    n = -this.scrollHeight;
                }
                this.scrollAndSelect(n, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.selectMouseX = mouseEvent.getX();
                this.selectMouseY = mouseEvent.getY();
            }
        }
    }

    private void scrollAndSelect(int n, int n2, int n3) {
        if (n != 0) {
            long l = System.currentTimeMillis();
            if (l - this.scrollTimestamp > (long)this.scrollTimeout) {
                int n4 = this.docView.vbar.getMaximum();
                int n5 = this.docView.vbar.getVisibleAmount();
                int n6 = this.docView.vbar.getValue();
                if (n > 0 && n6 + n5 == n4) {
                    return;
                }
                if (n < 0 && n6 == 0) {
                    return;
                }
                this.docView.setScrollPosition(this.sx, this.sy + n);
                this.scrollTimestamp = l;
                this.selectMouseY -= n;
            }
            DelayedScroll delayedScroll = new DelayedScroll(this, n2, n3, n);
            this.docView.getPilot().getStorm().runOnEventThreadLater(delayedScroll, this.scrollTimeout + 10);
        }
        this.docView.docSetSelection(this.selectMouseX, this.selectMouseY, n2, n3 + n);
    }

    private void verifyScrollTime(DelayedScroll delayedScroll) {
        if (this.selectMouseX != -1 && delayedScroll.dragY == this.lastDraggedY) {
            this.scrollAndSelect(delayedScroll.scr, delayedScroll.selX, delayedScroll.dragY);
        }
    }

    private void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        if (this.isButtonDown(this.selectButton, mouseEvent) && (!System.getProperty("os.name").startsWith("Mac OS") || (mouseEvent.getModifiers() & 2) == 0)) {
            this.docView.docClearSelection();
        }
    }

    private void mouseReleased(MouseEvent mouseEvent) {
        this.scrollMouseX = -1;
        this.selectMouseX = -1;
    }

    private void mouseExited(MouseEvent mouseEvent) {
        this.scrollMouseX = -1;
    }

    private void mouseClicked(MouseEvent mouseEvent) {
        if (this.isButtonDown(this.selectButton, mouseEvent)) {
            int n = mouseEvent.getClickCount();
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            Html4DocumentAccess html4DocumentAccess = new Html4DocumentAccess(this.docView.getPilot());
            switch (n) {
                case 4: {
                    html4DocumentAccess.setSelection(0, n2, n3);
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    html4DocumentAccess.setSelection(2, n2, n3);
                }
            }
        }
    }

    private boolean isButtonDown(int n, InputEvent inputEvent) {
        if (n < 0) {
            return false;
        }
        int n2 = inputEvent.getModifiers();
        if (n == 0 && (n2 == 0 || (n2 & 0x10) != 0)) {
            return true;
        }
        return n == 1 && (n2 & 4) != 0;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.docView.onComponentEvent(this, aWTEvent)) {
            super.processEvent(aWTEvent);
            switch (aWTEvent.getID()) {
                case 506: {
                    this.mouseDragged((MouseEvent)aWTEvent);
                    break;
                }
                case 501: {
                    this.mousePressed((MouseEvent)aWTEvent);
                    break;
                }
                case 502: {
                    this.mouseReleased((MouseEvent)aWTEvent);
                    break;
                }
                case 505: {
                    this.mouseExited((MouseEvent)aWTEvent);
                    break;
                }
                case 500: {
                    this.mouseClicked((MouseEvent)aWTEvent);
                }
            }
        }
    }

    private static class DelayedScroll
    implements Runnable {
        private final DocPanel owner;
        private final int dragY;
        private final int selX;
        private final int scr;

        DelayedScroll(DocPanel docPanel, int n, int n2, int n3) {
            this.owner = docPanel;
            this.dragY = n2;
            this.scr = n3;
            this.selX = n;
        }

        public void run() {
            this.owner.verifyScrollTime(this);
        }
    }
}

