/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.DocLocation;
import com.mathworks.help.helpui.HelpBrowserResourceBundle;
import com.mathworks.help.helpui.SearchResultPageWrapper;
import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.product.DocProduct;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class HelpBrowserUtils {
    private static HelpBrowserResourceBundle sResBundle = new HelpBrowserResourceBundle();
    private static final String INDEX_FILE = HelpBrowserUtils.getString("helpbrowser.index.file");
    private static final String DOC_CENTER_FILE = HelpBrowserUtils.getString("helpbrowser.doccenter.file");
    private static final String QUERY_STRING_DOCVIEWER_FIELD = "docviewer";
    private static final String QUERY_STRING_DOCRELEASE_FIELD = "docrelease";
    private static final String QUERY_STRING_DOCLANGUAGE_FIELD = "doclanguage";
    private static final String QUERY_STRING_DOCVIEWER_VALUE = "helpbrowser";

    private HelpBrowserUtils() {
    }

    public static String getString(String string) {
        return sResBundle.getString(string);
    }

    public static URL getImageURL(String string) {
        return HelpBrowserUtils.getImageURL(HelpBrowserUtils.getString("helpbrowser.resource.directory.path"), string);
    }

    public static URL getImageURL(String string, String string2) {
        String string3 = string + string2;
        ClassLoader classLoader = HelpBrowserUtils.class.getClassLoader();
        return classLoader.getResource(string3);
    }

    static Icon createBadgedIcon(ImageIcon imageIcon, ImageIcon imageIcon2, int n, int n2, int n3, int n4) {
        Image image = HelpBrowserUtils.createBadgedImage(imageIcon, imageIcon2, n, n2, n3, n4);
        return new ImageIcon(image);
    }

    static Image createBadgedImage(ImageIcon imageIcon, ImageIcon imageIcon2, int n, int n2, int n3, int n4) {
        if (imageIcon == null) {
            throw new IllegalArgumentException("'baseIcon' cannot be null");
        }
        if (imageIcon2 == null) {
            throw new IllegalArgumentException("'baseIcon' cannot be null");
        }
        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        graphics.drawImage(imageIcon.getImage(), 0, 0, null);
        graphics.drawImage(imageIcon2.getImage(), n, n2, n3, n4, null);
        return bufferedImage;
    }

    public static boolean isWebAddress(String string) {
        return string != null && string.startsWith("http://");
    }

    public static DocLocation getDocLocationForUrl(String string) {
        if (string == null) {
            return null;
        }
        return HelpBrowserUtils.isWebAddress(string) ? DocLocation.WEB : DocLocation.INSTALLED;
    }

    public static boolean compareUrlDocLocation(String string, String string2) {
        DocLocation docLocation;
        assert (string != null && string2 != null);
        DocLocation docLocation2 = HelpBrowserUtils.getDocLocationForUrl(string);
        return docLocation2 == (docLocation = HelpBrowserUtils.getDocLocationForUrl(string2));
    }

    static String getArgument(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            String string3;
            String string4 = string2.toLowerCase();
            if (!string4.startsWith(string3 = string.toLowerCase()) && !string4.startsWith("-" + string3)) continue;
            return string2.substring(string2.indexOf(61) + 1);
        }
        return null;
    }

    public static String buildUrl(String string) {
        if (string.matches(".*\\.html([?#;].*)?$")) {
            return string;
        }
        return HelpBrowserUtils.isWebAddress(string) ? HelpBrowserUtils.buildWebUrl(string) : HelpBrowserUtils.buildInstalledUrl(string);
    }

    private static String buildInstalledUrl(String string) {
        assert (string != null);
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (string.endsWith("help" + File.separator)) {
            return string + DOC_CENTER_FILE;
        }
        return string + INDEX_FILE;
    }

    private static String buildWebUrl(String string) {
        assert (string != null);
        String string2 = "/";
        if (!string.endsWith(string2)) {
            string = string + string2;
        }
        if (string.matches("^.*/R20\\d\\d[ab]/$")) {
            return string + DOC_CENTER_FILE;
        }
        if (string.endsWith(string2 + "help" + string2)) {
            return string + DOC_CENTER_FILE;
        }
        return string + INDEX_FILE;
    }

    public static String getQueryStringValue(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = HelpBrowserUtils.getQueryString(string);
        Map<String, String> map = HelpBrowserUtils.getQueryMap(string3);
        return map != null ? map.get(string2) : null;
    }

    static String getQueryString(String string) {
        try {
            URL uRL = new URL(string);
            return uRL.getQuery() != null ? uRL.getQuery() : "";
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static Map<String, String> getQueryMap(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("&");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length != 2) continue;
            hashMap.put(stringArray2[0], stringArray2[1]);
        }
        return hashMap;
    }

    public static String escapeSpecialCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (c == '\'') {
                stringBuilder.append("\\'");
            } else {
                stringBuilder.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    public static String appendQueryStringToUrl(String string, String string2) {
        return HelpBrowserUtils.appendQueryStringToUrl(string, string2, null);
    }

    public static String appendQueryStringToUrl(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (HelpBrowserUtils.getQueryStringValue(string, QUERY_STRING_DOCVIEWER_FIELD) == null) {
            stringBuilder.append(HelpBrowserUtils.urlHasQueryString(string) ? (char)'&' : '?');
            stringBuilder.append(QUERY_STRING_DOCVIEWER_FIELD).append("=").append(QUERY_STRING_DOCVIEWER_VALUE);
        }
        if (HelpBrowserUtils.getQueryStringValue(string, QUERY_STRING_DOCLANGUAGE_FIELD) == null && string3 != null) {
            string3 = string3.toLowerCase(Locale.ENGLISH);
            stringBuilder.append('&').append(QUERY_STRING_DOCLANGUAGE_FIELD).append("=").append(string3);
        }
        if (HelpBrowserUtils.getQueryStringValue(string, QUERY_STRING_DOCRELEASE_FIELD) == null && string2 != null) {
            string2 = string2.toLowerCase(Locale.ENGLISH);
            stringBuilder.append('&').append(QUERY_STRING_DOCRELEASE_FIELD).append("=").append(string2);
        }
        return stringBuilder.toString();
    }

    public static String addToUrlQueryString(String string, String string2, String string3) {
        String string4 = HelpBrowserUtils.getQueryStringValue(string, string2) != null ? HelpBrowserUtils.removeQueryStringFromUrl(string, string2) : string;
        return string4 != null ? HelpBrowserUtils.addQueryStringToUrl(string4, string2, string3) : string;
    }

    private static String addQueryStringToUrl(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(HelpBrowserUtils.urlHasQueryString(string) ? (char)'&' : '?');
        stringBuilder.append(string2).append("=").append(string3);
        return stringBuilder.toString();
    }

    public static String removeQueryStringFromUrl(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = HelpBrowserUtils.getQueryString(string);
        if (string3 == null || string3.length() == 0) {
            return null;
        }
        Map<String, String> map = HelpBrowserUtils.getQueryMap(string3);
        if (map == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.indexOf(63);
        stringBuilder.append(string.substring(0, n + 1));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string4 = entry.getKey();
            String string5 = entry.getValue();
            if (string4.equalsIgnoreCase(string2)) continue;
            stringBuilder.append(string4).append("=").append(string5).append("&");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public static String removeAllQueryStringsFromUrl(String string) {
        if (string == null) {
            return null;
        }
        String string2 = HelpBrowserUtils.getQueryString(string);
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        string = string.substring(0, string.length() - (string2.length() + 1));
        return string;
    }

    public static boolean urlHasQueryString(String string) {
        String string2 = HelpBrowserUtils.getQueryString(string);
        return string2 != null && string2.length() != 0;
    }

    public static String addToUrlQueryString(String string, String string2, String string3, String string4) {
        if (string == null || string2 == null || string3 == null || string4 == null) {
            return null;
        }
        String string5 = HelpBrowserUtils.getQueryString(string);
        if (string5 == null || string5.length() == 0) {
            return null;
        }
        Map<String, String> map = HelpBrowserUtils.getQueryMap(string5);
        if (map == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.indexOf(63);
        stringBuilder.append(string.substring(0, n + 1));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string6 = entry.getKey();
            String string7 = entry.getValue();
            String string8 = string6.equalsIgnoreCase(string2) ? HelpBrowserUtils.addOptionToQueryField(string7, string3, string4) : string7;
            stringBuilder.append(string6).append("=").append(string8).append("&");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private static String addOptionToQueryField(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("\\+");
        boolean bl = false;
        for (String string4 : stringArray) {
            String[] stringArray2 = string4.split(":");
            if (!stringArray2[0].equalsIgnoreCase(string2)) {
                stringBuilder.append(string4).append("+");
                continue;
            }
            stringBuilder.append(stringArray2[0]).append(":").append(string3).append("+");
            bl = true;
        }
        if (!bl) {
            stringBuilder.append(string2).append(":").append(string3).append("+");
        }
        if (stringBuilder.toString().endsWith("+")) {
            stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    public static String removeFromUrlQueryString(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        String string4 = HelpBrowserUtils.getQueryString(string);
        if (string4 == null || string4.length() == 0) {
            return null;
        }
        Map<String, String> map = HelpBrowserUtils.getQueryMap(string4);
        if (map == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.indexOf(63);
        stringBuilder.append(string.substring(0, n + 1));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string5 = entry.getKey();
            String string6 = entry.getValue();
            String string7 = string5.equalsIgnoreCase(string2) ? HelpBrowserUtils.removeOptionFromQueryFieldValue(string6, string3) : string6;
            if (string7 == null || string7.length() <= 0) continue;
            stringBuilder.append(string5).append("=").append(string7).append("&");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private static String removeOptionFromQueryFieldValue(String string, String string2) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray = string.split("\\+")) {
            String[] stringArray2 = string3.split(":");
            if (stringArray2[0].equalsIgnoreCase(string2)) continue;
            stringBuilder.append(string3).append("+");
        }
        if (stringBuilder.toString().endsWith("+")) {
            stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    public static List<SearchResultPageWrapper> getSearchResultPages(int n, int n2) {
        int n3;
        if (n <= 1 || n2 > n) {
            return new ArrayList<SearchResultPageWrapper>();
        }
        int n4 = n <= 13 ? n + 2 : 15;
        int n5 = n4 - 4;
        boolean bl = n > 13 && n2 > 7;
        boolean bl2 = n > 13 && n - n2 > 6;
        boolean bl3 = n2 > 1;
        boolean bl4 = n2 < n;
        ArrayList<SearchResultPageWrapper> arrayList = new ArrayList<SearchResultPageWrapper>();
        SearchResultPageWrapper searchResultPageWrapper = new SearchResultPageWrapper(HelpBrowserUtils.getString("helpbrowser.seachresults.footer.previous"), false, bl3);
        if (bl3) {
            n3 = n2 - 1;
            searchResultPageWrapper.setUrlPageNumber(n3);
        }
        arrayList.add(searchResultPageWrapper);
        searchResultPageWrapper = new SearchResultPageWrapper("1", n2 == 1, n2 != 1);
        if (n2 != 1) {
            searchResultPageWrapper.setUrlPageNumber(1);
        }
        arrayList.add(searchResultPageWrapper);
        if (bl) {
            searchResultPageWrapper = new SearchResultPageWrapper("...", false, false);
            arrayList.add(searchResultPageWrapper);
        }
        int n6 = HelpBrowserUtils.determineLastPageToAdd(n, n2, n5, bl, bl2);
        for (n3 = HelpBrowserUtils.determineNextPageToAdd(n, n2, n5, bl, bl2); n3 >= 2 && n3 <= n6; ++n3) {
            searchResultPageWrapper = new SearchResultPageWrapper(String.valueOf(n3), n2 == n3, n2 != n3);
            if (n2 != n3) {
                searchResultPageWrapper.setUrlPageNumber(n3);
            }
            arrayList.add(searchResultPageWrapper);
        }
        if (bl2) {
            searchResultPageWrapper = new SearchResultPageWrapper("...", false, false);
            arrayList.add(searchResultPageWrapper);
        }
        searchResultPageWrapper = new SearchResultPageWrapper(String.valueOf(n), n2 == n, n2 != n);
        if (n2 != n) {
            searchResultPageWrapper.setUrlPageNumber(n);
        }
        arrayList.add(searchResultPageWrapper);
        searchResultPageWrapper = new SearchResultPageWrapper(HelpBrowserUtils.getString("helpbrowser.seachresults.footer.next"), false, bl4);
        if (bl4) {
            int n7 = n2 + 1;
            searchResultPageWrapper.setUrlPageNumber(n7);
        }
        arrayList.add(searchResultPageWrapper);
        return arrayList;
    }

    private static int determineLastPageToAdd(int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = n3 > 0 ? (bl2 ? (bl ? n2 + 4 : n3) : n - 1) : 0;
        return n4;
    }

    private static int determineNextPageToAdd(int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = n3 > 0 ? (bl ? (bl2 ? n2 - 4 : n - n3 + 1) : 2) : 0;
        return n4;
    }

    public static String buildDocumentationPath(String string, DocProduct docProduct, String string2) {
        return HelpBrowserUtils.concatenatePaths(string, docProduct.getHelpLocation(), string2);
    }

    public static String concatenatePaths(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string.replace('\\', '/'));
            if (stringBuilder.charAt(stringBuilder.length() - 1) == '/') continue;
            stringBuilder.append('/');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public static DocLanguage getDocLanguageForLocale(Locale locale) {
        if (locale != null) {
            for (DocLanguage docLanguage : DocLanguage.values()) {
                if (!docLanguage.getLocale().getLanguage().equals(locale.getLanguage())) continue;
                return docLanguage;
            }
        }
        return DocLanguage.getDefault();
    }
}

