/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.suggestions;

import com.mathworks.help.helpui.SearchHelper;
import com.mathworks.help.helpui.suggestions.FullSuggestionRequest;
import com.mathworks.help.helpui.suggestions.PageSuggestionRequest;
import com.mathworks.help.helpui.suggestions.SuggestionRequest;
import com.mathworks.help.helpui.suggestions.WordSuggestionRequest;
import com.mathworks.helpsearch.DocSearchEngineFactory;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.ProductResolver;
import com.mathworks.helpsearch.suggestion.DocumentationSuggestionProvider;
import com.mathworks.helpsearch.suggestion.SearchEngineSuggestionProvider;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.ProtocolRequestHandler;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchField;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocSuggestionProtocolHandler
extends ProtocolRequestHandler {
    private static final int INITIAL_SUGGESTIONS = 5;
    private static final Map<String, InformationType> TYPES_BY_QUERY_STRING;
    private static final Pattern URL_PATTERN;
    private final HtmlComponent<? extends HtmlActions> fHtmlComponent;
    private final SearchConfig fSearchConfig;
    private final DocumentationSet fDocumentationSet;
    private final String fDocRoot;
    private boolean fWaitForCompletion = false;

    public DocSuggestionProtocolHandler(HtmlComponent<? extends HtmlActions> htmlComponent, SearchHelper searchHelper, String string) {
        super(new String[]{"docsuggestion"});
        this.fHtmlComponent = htmlComponent;
        this.fSearchConfig = searchHelper.getSearchConfig();
        this.fDocumentationSet = searchHelper.getDocumentationSet();
        this.fDocRoot = string;
    }

    public void setWaitForCompletion(boolean bl) {
        this.fWaitForCompletion = bl;
    }

    protected void handleMatchedUrl(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    SuggestionRequest suggestionRequest = DocSuggestionProtocolHandler.this.getRequest(string);
                    if (suggestionRequest != null) {
                        DocSuggestionProtocolHandler.this.fHtmlComponent.executeScript(suggestionRequest.getJavaScriptCallback());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        if (this.fWaitForCompletion) {
            try {
                thread.join(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SuggestionRequest getRequest(String string) throws IOException {
        Matcher matcher = URL_PATTERN.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = URLDecoder.decode(matcher.group(2), "UTF8");
            return this.getRequest(this.getSuggestionProvider(), string2, string3);
        }
        return null;
    }

    private SuggestionRequest getRequest(DocumentationSuggestionProvider documentationSuggestionProvider, String string, String string2) throws IOException {
        if (string != null) {
            InformationType informationType = TYPES_BY_QUERY_STRING.get(string = string.substring(0, string.length() - 1));
            if (informationType != null) {
                return new PageSuggestionRequest(documentationSuggestionProvider, informationType, string2, 5, this.fDocRoot);
            }
            if (string.equals("word")) {
                return new WordSuggestionRequest(documentationSuggestionProvider, string2, 5);
            }
        }
        return new FullSuggestionRequest(documentationSuggestionProvider, this.getTypesToSuggest(), string2, 5, this.fDocRoot);
    }

    public DocumentationSuggestionProvider getSuggestionProvider() throws IOException {
        SearchEngine searchEngine = DocSearchEngineFactory.createSearchEngine((SearchConfig)this.fSearchConfig, (DocumentationSet)this.fDocumentationSet);
        return new SearchEngineSuggestionProvider(searchEngine, (SearchField)DocumentationSearchField.BODY, (ProductResolver)this.fDocumentationSet);
    }

    public Collection<InformationType> getTypesToSuggest() {
        switch (this.fDocumentationSet.getFormat()) {
            case DOC_CENTER_DOC: {
                return EnumSet.of(InformationType.FUNCTIONS, InformationType.BLOCKS, InformationType.SYSTEM_OBJECTS, InformationType.CATEGORY_PAGE);
            }
        }
        return EnumSet.of(InformationType.FUNCTIONS, InformationType.BLOCKS);
    }

    static {
        URL_PATTERN = Pattern.compile("^docsuggestion:(\\w+:)?(.*)");
        TYPES_BY_QUERY_STRING = new HashMap<String, InformationType>();
        for (InformationType informationType : InformationType.values()) {
            TYPES_BY_QUERY_STRING.put(informationType.getQueryStringValue(), informationType);
        }
    }
}

