/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.constants;

import java.io.ObjectStreamException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnexpectedException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import net.jini.io.UnsupportedConstraintException;

public class ThrowableConstants {
    public static final int INDEFINITE = 0;
    public static final int BAD_INVOCATION = 1;
    public static final int BAD_OBJECT = 2;
    public static final int UNCATEGORIZED = 3;

    public static int retryable(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("Must pass a non-null Throwable");
        }
        if (throwable instanceof RuntimeException) {
            return 1;
        }
        if (throwable instanceof Error) {
            if (throwable instanceof OutOfMemoryError || throwable instanceof LinkageError) {
                return 0;
            }
            if (throwable instanceof StackOverflowError) {
                return 1;
            }
            return 2;
        }
        if (throwable instanceof RemoteException) {
            RemoteException remoteException = (RemoteException)throwable;
            if (remoteException instanceof NoSuchObjectException || remoteException instanceof UnexpectedException || remoteException instanceof UnknownHostException) {
                return 2;
            }
            Throwable throwable2 = remoteException.detail;
            if (throwable2 == null) {
                return 0;
            }
            if (remoteException instanceof MarshalException || remoteException instanceof UnmarshalException) {
                if (throwable2 instanceof ObjectStreamException) {
                    return 1;
                }
                int n = ThrowableConstants.retryable(throwable2);
                if (n == 2 || n == 1) {
                    return 1;
                }
                return 0;
            }
            if (remoteException instanceof ConnectIOException) {
                if (throwable2 instanceof NoRouteToHostException || throwable2 instanceof PortUnreachableException || throwable2 instanceof ProtocolException) {
                    return 2;
                }
                if (throwable2 instanceof UnsupportedConstraintException || throwable2 instanceof ObjectStreamException) {
                    return 1;
                }
                return 0;
            }
            if (remoteException instanceof ServerException) {
                int n = ThrowableConstants.retryable(throwable2);
                if (n == 2) {
                    return 1;
                }
                return n;
            }
            if (remoteException instanceof ServerError) {
                return ThrowableConstants.retryable(throwable2);
            }
            return 0;
        }
        return 3;
    }
}

