/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm.lookup;

import [Ljava.lang.String;;
import [Lnet.jini.core.discovery.LookupLocator;;
import [Lnet.jini.core.entry.Entry;;
import com.sun.jini.config.Config;
import com.sun.jini.logging.Levels;
import com.sun.jini.norm.lookup.SubStore;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.MarshalledObject;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.NoSuchEntryException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.JoinManager;
import net.jini.security.ProxyPreparer;

public class JoinState
extends LogHandler
implements SubStore {
    private static final String NORM = "com.sun.jini.norm";
    private static final Logger logger = Logger.getLogger("com.sun.jini.norm");
    final Object service;
    private final LeaseRenewalManager lrm;
    private final Configuration config;
    private final Entry[] serviceAttributes;
    private final ProxyPreparer recoveredLookupLocatorPreparer;
    private final ServiceID serviceID;
    private ReliableLog log;
    private boolean recoveredData;
    private Entry[] attributes;
    private String[] groups = DiscoveryGroupManagement.NO_GROUPS;
    private LookupLocator[] locators;
    private DiscoveryManagement dm;
    private JoinManager joinMgr;

    public JoinState(Object object, LeaseRenewalManager leaseRenewalManager, Configuration configuration, Entry[] entryArray, ProxyPreparer proxyPreparer, ServiceID serviceID) throws IOException {
        this.service = object;
        this.lrm = leaseRenewalManager;
        this.config = configuration;
        this.serviceAttributes = entryArray;
        this.recoveredLookupLocatorPreparer = proxyPreparer;
        this.serviceID = serviceID;
    }

    public String subDirectory() {
        return "JoinState";
    }

    public void setDirectory(File file) throws IOException, ConfigurationException {
        if (file != null) {
            try {
                this.log = new ReliableLog(file.getCanonicalPath(), this);
                this.log.recover();
            }
            catch (IOException iOException) {
                IOException iOException2 = new IOException("Log is corrupted: " + iOException.getMessage());
                iOException2.initCause(iOException);
                throw iOException2;
            }
        }
        if (!this.recoveredData) {
            this.getInitialEntries();
        } else {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            int n = this.locators.length;
            while (--n >= 0) {
                try {
                    linkedList.add(this.recoveredLookupLocatorPreparer.prepareProxy((Object)this.locators[n]));
                }
                catch (Throwable throwable) {
                    if (!logger.isLoggable(Level.INFO)) continue;
                    JoinState.logThrow(Level.INFO, "setDirectory", "Problem preparing lookup locator {0} -- discarding", new Object[]{this.locators[n]}, throwable);
                }
            }
            this.locators = linkedList.toArray(new LookupLocator[linkedList.size()]);
        }
        this.createDiscoveryManager();
        try {
            this.joinMgr = new JoinManager(this.service, this.attributes, this.serviceID, this.dm, this.lrm, this.config);
        }
        catch (IOException iOException) {
            IOException iOException3 = new IOException("Problem starting JoinManager: " + iOException.getMessage());
            iOException3.initCause(iOException3);
            throw iOException3;
        }
        try {
            this.takeSnapshot();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Ignoring problem creating initial snapshot", iOException);
        }
    }

    private static void logThrow(Level level, String string, String string2, Object[] objectArray, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string2);
        logRecord.setLoggerName(logger.getName());
        logRecord.setSourceClassName(JoinState.class.getName());
        logRecord.setSourceMethodName(string);
        logRecord.setParameters(objectArray);
        logRecord.setThrown(throwable);
        logger.log(logRecord);
    }

    private Object[] getArrayEntry(String string, Class clazz, Object object) throws ConfigurationException {
        Object[] objectArray = (Object[])this.config.getEntry(NORM, string, clazz, object);
        if (objectArray != null) {
            int n = objectArray.length;
            while (--n >= 0) {
                if (objectArray[n] != null) continue;
                throw new ConfigurationException("Entry for component com.sun.jini.norm, name " + string + " must not contain null elements");
            }
        }
        return objectArray;
    }

    private void getInitialEntries() throws ConfigurationException {
        this.attributes = (Entry[])this.getArrayEntry("initialLookupAttributes", Entry;.class, null);
        if (this.attributes == null || this.attributes.length == 0) {
            this.attributes = this.serviceAttributes;
        } else {
            Entry[] entryArray = new Entry[this.serviceAttributes.length + this.attributes.length];
            System.arraycopy(this.serviceAttributes, 0, entryArray, 0, this.serviceAttributes.length);
            System.arraycopy(this.attributes, 0, entryArray, this.serviceAttributes.length, this.attributes.length);
            this.attributes = entryArray;
        }
        this.groups = (String[])this.getArrayEntry("initialLookupGroups", String;.class, new String[]{""});
        this.locators = (LookupLocator[])this.getArrayEntry("initialLookupLocators", LookupLocator;.class, null);
        if (this.locators == null) {
            this.locators = new LookupLocator[0];
        }
    }

    private void createDiscoveryManager() throws ConfigurationException, IOException {
        try {
            this.dm = (DiscoveryManagement)Config.getNonNullEntry(this.config, NORM, "discoveryManager", DiscoveryManagement.class);
            if (!(this.dm instanceof DiscoveryGroupManagement)) {
                throw new ConfigurationException("Entry for component com.sun.jini.norm, name discoveryManager must implement net.jini.discovery.DiscoveryGroupManagement");
            }
            String[] stringArray = ((DiscoveryGroupManagement)((Object)this.dm)).getGroups();
            if (stringArray == null || stringArray.length != 0) {
                throw new ConfigurationException("Entry for component com.sun.jini.norm, name discoveryManager must be configured with no groups");
            }
            if (!(this.dm instanceof DiscoveryLocatorManagement)) {
                throw new ConfigurationException("Entry for component com.sun.jini.norm, name discoveryManager must implement net.jini.discovery.DiscoveryLocatorManagement");
            }
            if (((DiscoveryLocatorManagement)((Object)this.dm)).getLocators().length != 0) {
                throw new ConfigurationException("Entry for component com.sun.jini.norm, name discoveryManager must be configured with no locators");
            }
            ((DiscoveryGroupManagement)((Object)this.dm)).setGroups(stringArray);
            ((DiscoveryLocatorManagement)((Object)this.dm)).setLocators(this.locators);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            this.dm = new LookupDiscoveryManager(this.groups, this.locators, null, this.config);
        }
    }

    public void prepareDestroy() {
        try {
            if (this.log != null) {
                this.log.close();
            }
        }
        catch (IOException iOException) {
            logger.log(Levels.HANDLED, "Ignoring problem closing log during destroy", iOException);
        }
    }

    public void terminateJoin() {
        if (this.joinMgr != null) {
            this.joinMgr.terminate();
        }
        if (this.dm != null) {
            this.dm.terminate();
        }
    }

    public void snapshot(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        JoinState.writeAttributes(this.joinMgr.getAttributes(), objectOutputStream);
        objectOutputStream.writeObject(((DiscoveryGroupManagement)((Object)this.dm)).getGroups());
        objectOutputStream.writeObject(((DiscoveryLocatorManagement)((Object)this.dm)).getLocators());
        objectOutputStream.flush();
    }

    public void recover(InputStream inputStream) throws Exception {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this.attributes = JoinState.readAttributes(objectInputStream);
        this.groups = (String[])objectInputStream.readObject();
        this.locators = (LookupLocator[])objectInputStream.readObject();
        this.recoveredData = true;
    }

    public void applyUpdate(Object object) throws Exception {
        throw new UnsupportedOperationException("Recovering log update -- this should not happen");
    }

    private static void writeAttributes(Entry[] entryArray, ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(entryArray.length);
        for (int i = 0; i < entryArray.length; ++i) {
            objectOutputStream.writeObject(new MarshalledObject<Entry>(entryArray[i]));
        }
    }

    private static Entry[] readAttributes(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        LinkedList linkedList = new LinkedList();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            try {
                MarshalledObject marshalledObject = (MarshalledObject)objectInputStream.readObject();
                linkedList.add(marshalledObject.get());
                continue;
            }
            catch (IOException iOException) {
                logger.log(Level.INFO, "Problem recovering attribute -- discarding", iOException);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(Level.INFO, "Problem recovering attribute -- discarding", classNotFoundException);
            }
        }
        return linkedList.toArray(new Entry[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeSnapshot() throws IOException {
        if (this.log == null) {
            return;
        }
        ReliableLog reliableLog = this.log;
        synchronized (reliableLog) {
            this.log.snapshot();
        }
    }

    public String[] getGroups() {
        return ((DiscoveryGroupManagement)((Object)this.dm)).getGroups();
    }

    public void addGroups(String[] stringArray) {
        try {
            ((DiscoveryGroupManagement)((Object)this.dm)).addGroups(stringArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not change groups: " + iOException.getMessage(), iOException);
        }
        try {
            this.takeSnapshot();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not log change: " + iOException.getMessage(), iOException);
        }
    }

    public void removeGroups(String[] stringArray) {
        ((DiscoveryGroupManagement)((Object)this.dm)).removeGroups(stringArray);
        try {
            this.takeSnapshot();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not log change: " + iOException.getMessage(), iOException);
        }
    }

    public void setGroups(String[] stringArray) {
        try {
            ((DiscoveryGroupManagement)((Object)this.dm)).setGroups(stringArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not change groups: " + iOException.getMessage(), iOException);
        }
        try {
            this.takeSnapshot();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not log change: " + iOException.getMessage(), iOException);
        }
    }

    public LookupLocator[] getLocators() {
        return ((DiscoveryLocatorManagement)((Object)this.dm)).getLocators();
    }

    public void addLocators(LookupLocator[] lookupLocatorArray) {
        ((DiscoveryLocatorManagement)((Object)this.dm)).addLocators(lookupLocatorArray);
        try {
            this.takeSnapshot();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not log change: " + iOException.getMessage(), iOException);
        }
    }

    public void removeLocators(LookupLocator[] lookupLocatorArray) {
        ((DiscoveryLocatorManagement)((Object)this.dm)).removeLocators(lookupLocatorArray);
        try {
            this.takeSnapshot();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not log change: " + iOException.getMessage(), iOException);
        }
    }

    public void setLocators(LookupLocator[] lookupLocatorArray) {
        ((DiscoveryLocatorManagement)((Object)this.dm)).setLocators(lookupLocatorArray);
        try {
            this.takeSnapshot();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not log change: " + iOException.getMessage(), iOException);
        }
    }

    public Entry[] getAttributes() {
        return this.joinMgr.getAttributes();
    }

    public void addAttributes(Entry[] entryArray, boolean bl) {
        this.joinMgr.addAttributes(entryArray, bl);
        try {
            this.takeSnapshot();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not log change: " + iOException.getMessage(), iOException);
        }
    }

    public void modifyAttributes(Entry[] entryArray, Entry[] entryArray2, boolean bl) {
        this.joinMgr.modifyAttributes(entryArray, entryArray2, bl);
        try {
            this.takeSnapshot();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not log change: " + iOException.getMessage(), iOException);
        }
    }
}

