/*
 * Decompiled with CFR 0.152.
 */
package net.jini.lease;

import java.rmi.MarshalledObject;
import net.jini.core.lease.Lease;

public class LeaseUnmarshalException
extends Exception {
    private static final long serialVersionUID = -6736107321698417489L;
    private final Lease[] unmarshalledLeases;
    private final MarshalledObject[] stillMarshalledLeases;
    private final Throwable[] exceptions;

    public LeaseUnmarshalException(String string, Lease[] leaseArray, MarshalledObject[] marshalledObjectArray, Throwable[] throwableArray) {
        super(string);
        this.validate(marshalledObjectArray, throwableArray);
        this.unmarshalledLeases = leaseArray;
        this.stillMarshalledLeases = marshalledObjectArray;
        this.exceptions = throwableArray;
    }

    public LeaseUnmarshalException(Lease[] leaseArray, MarshalledObject[] marshalledObjectArray, Throwable[] throwableArray) {
        this.validate(marshalledObjectArray, throwableArray);
        this.unmarshalledLeases = leaseArray;
        this.stillMarshalledLeases = marshalledObjectArray;
        this.exceptions = throwableArray;
    }

    private void validate(MarshalledObject[] marshalledObjectArray, Throwable[] throwableArray) {
        if (throwableArray.length != marshalledObjectArray.length) {
            throw new IllegalArgumentException("exceptions.length (" + throwableArray.length + ") is not equal to marshalledLeases.length (" + marshalledObjectArray.length + ")");
        }
    }

    public Lease[] getLeases() {
        return this.unmarshalledLeases;
    }

    public MarshalledObject[] getMarshalledLeases() {
        return this.stillMarshalledLeases;
    }

    public Throwable[] getExceptions() {
        return this.exceptions;
    }
}

