/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.databrowser;

import com.mathworks.fl.i18n.XMLMessageSystem;
import com.mathworks.jmi.Callback;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.widgets.PopupMenuCustomizer;
import com.mathworks.widgets.SearchTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class WorkspaceTextSearch {
    private SearchTextField fSearchTextField;
    private PopupMenuCustomizer fOptionsMenuCustomizer;
    private MJPanel fPanel;
    private final Callback fTypingEventsToMATLAB = new Callback();
    private final Callback fRegExpSelectionEventsToMATLAB = new Callback();
    private TypingListener fTypingListener;
    private String fPromptText;
    private String fVarnameStartsWith;
    private String fVarnameEndsWith;
    private String fVarnameContains;
    private String fAllowRegExp;

    public WorkspaceTextSearch() {
        this.createWidgets();
        this.fPanel = this.buildPanel();
    }

    public MJPanel getPanel() {
        return this.fPanel;
    }

    public void removePanelFromParent() {
        Container container = this.fPanel.getParent();
        if (container != null) {
            container.remove((Component)this.fPanel);
            container.repaint();
        }
    }

    public void setSearchText(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fSearchTextField.setSearchText(string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WorkspaceTextSearch.this.fSearchTextField.setSearchText(string);
                }
            });
        }
    }

    public String getSearchText() {
        return this.fSearchTextField.getSearchText();
    }

    public void setPromptText(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fSearchTextField.setPromptText(string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WorkspaceTextSearch.this.fSearchTextField.setPromptText(string);
                }
            });
        }
    }

    public void setFilterMode(String string) {
        if (string.equalsIgnoreCase("regexp")) {
            ((OptionsMenu)this.fOptionsMenuCustomizer).enableRegExpCheckBox();
        } else {
            ((OptionsMenu)this.fOptionsMenuCustomizer).disableRegExpCheckBox();
        }
    }

    public Callback getTypingEventsToMATLAB() {
        return this.fTypingEventsToMATLAB;
    }

    public void notifyMATLABAboutTyping(String string) {
        this.fTypingEventsToMATLAB.postCallback(new Object[]{string});
    }

    public Callback getRegExpSelectionEventsToMATLAB() {
        return this.fRegExpSelectionEventsToMATLAB;
    }

    public void notifyMATLABAboutRegExpSelection(boolean bl) {
        this.fRegExpSelectionEventsToMATLAB.postCallback(new Object[]{bl});
    }

    public void createWidgets() {
        this.fPromptText = XMLMessageSystem.getBundle((String)"Controllib:databrowser").getString("PromptText");
        this.fVarnameStartsWith = XMLMessageSystem.getBundle((String)"Controllib:databrowser").getString("VarnameStartsWith");
        this.fVarnameEndsWith = XMLMessageSystem.getBundle((String)"Controllib:databrowser").getString("VarnameEndsWith");
        this.fVarnameContains = XMLMessageSystem.getBundle((String)"Controllib:databrowser").getString("VarnameContains");
        this.fAllowRegExp = XMLMessageSystem.getBundle((String)"Controllib:databrowser").getString("AllowRegExp");
        this.fOptionsMenuCustomizer = new OptionsMenu();
        this.fSearchTextField = new SearchTextField(this.fPromptText, this.fOptionsMenuCustomizer);
        this.fTypingListener = new TypingListener();
        this.fSearchTextField.addSearchTextFieldListener((SearchTextField.Listener)this.fTypingListener);
        this.fSearchTextField.getComponent().setName("filterwidget");
    }

    public MJPanel buildPanel() {
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new BorderLayout());
        mJPanel.setBackground(Color.WHITE);
        mJPanel.add((Component)this.fSearchTextField.getComponent(), (Object)"Center");
        mJPanel.setVisible(true);
        return mJPanel;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WorkspaceTextSearch workspaceTextSearch = new WorkspaceTextSearch();
                MJFrame mJFrame = new MJFrame("Unit Testing Frame - Variable Preview");
                mJFrame.getContentPane().setLayout(new FlowLayout());
                mJFrame.setContentPane((Container)workspaceTextSearch.getPanel());
                mJFrame.setSize(500, 500);
                mJFrame.setLocationRelativeTo(null);
                mJFrame.setDefaultCloseOperation(2);
                mJFrame.setVisible(true);
                workspaceTextSearch.setSearchText("If you see this text, then the display works!");
            }
        });
    }

    private class TypingListener
    implements SearchTextField.Listener {
        private TypingListener() {
        }

        public void search(String string) {
            WorkspaceTextSearch.this.notifyMATLABAboutTyping(string);
        }

        public void searchTextChanged(String string) {
            WorkspaceTextSearch.this.notifyMATLABAboutTyping(string);
        }

        public void searchCleared() {
            WorkspaceTextSearch.this.notifyMATLABAboutTyping("");
        }
    }

    private class OptionsMenu
    implements PopupMenuCustomizer {
        private MJCheckBoxMenuItem fStartsWithCheckBox;
        private MJCheckBoxMenuItem fEndsWithCheckBox;
        private MJCheckBoxMenuItem fContainsCheckBox;
        private MJCheckBoxMenuItem fRegExpCheckBox;

        private OptionsMenu() {
            this.fStartsWithCheckBox = new MJCheckBoxMenuItem(WorkspaceTextSearch.this.fVarnameStartsWith, true);
            this.fEndsWithCheckBox = new MJCheckBoxMenuItem(WorkspaceTextSearch.this.fVarnameEndsWith, true);
            this.fContainsCheckBox = new MJCheckBoxMenuItem(WorkspaceTextSearch.this.fVarnameContains, true);
            this.fRegExpCheckBox = new MJCheckBoxMenuItem(WorkspaceTextSearch.this.fAllowRegExp, true);
            this.fRegExpCheckBox.setName("regexpQE");
            this.fStartsWithCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    OptionsMenu.this.fStartsWithCheckBox.isSelected();
                }
            });
            this.fEndsWithCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    OptionsMenu.this.fEndsWithCheckBox.isSelected();
                }
            });
            this.fContainsCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    OptionsMenu.this.fContainsCheckBox.isSelected();
                }
            });
            this.fRegExpCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    WorkspaceTextSearch.this.notifyMATLABAboutRegExpSelection(OptionsMenu.this.fRegExpCheckBox.isSelected());
                }
            });
        }

        public void customize(JPopupMenu jPopupMenu) {
            jPopupMenu.add((JMenuItem)this.fRegExpCheckBox);
        }

        public void enableRegExpCheckBox() {
            if (!this.fRegExpCheckBox.isSelected()) {
                this.fRegExpCheckBox.setSelected(true);
            }
        }

        public void disableRegExpCheckBox() {
            if (this.fRegExpCheckBox.isSelected()) {
                this.fRegExpCheckBox.setSelected(false);
            }
        }
    }
}

