/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.guide;

import com.mathworks.toolbox.shared.controllib.guide.AbstractHMITableModel;
import java.awt.Color;
import java.util.Arrays;
import java.util.Vector;

public class ColorRangeTableModel
extends AbstractHMITableModel {
    private final Vector<Color> fColors = new Vector();
    private final Vector<String> fStarts = new Vector();
    private final Vector<String> fEnds = new Vector();
    private static final long serialVersionUID = 1L;

    public ColorRangeTableModel(String[] stringArray, int n) {
        super(stringArray);
        this.setRowCount(n);
    }

    @Override
    public int getRowCount() {
        return this.fColors.size();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Class<Object> clazz = Object.class;
        if (n == 0) {
            clazz = Color.class;
        } else if (n == 1) {
            clazz = String.class;
        } else if (n == 2) {
            clazz = String.class;
        }
        return clazz;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        if (n2 == 0) {
            object = this.fColors.get(n);
        } else if (n2 == 1) {
            object = this.fStarts.get(n);
        } else if (n2 == 2) {
            object = this.fEnds.get(n);
        }
        return object;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            this.fColors.set(n, (Color)object);
        } else if (n2 == 1) {
            this.fStarts.set(n, (String)object);
        } else if (n2 == 2) {
            this.fEnds.set(n, (String)object);
        }
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public void setRowCount(int n) {
        int n2 = this.getRowCount();
        if (n2 == n) {
            return;
        }
        this.fColors.setSize(n);
        this.fStarts.setSize(n);
        this.fEnds.setSize(n);
        if (n <= n2) {
            this.fireTableRowsDeleted(n, n2 - 1);
        } else {
            this.fireTableRowsInserted(n2, n - 1);
        }
    }

    public Color[] getColors() {
        Color[] colorArray = new Color[this.fColors.size()];
        return this.fColors.toArray(colorArray);
    }

    public void setColors(Color[] colorArray) {
        this.fColors.clear();
        this.fColors.addAll(Arrays.asList(colorArray));
        this.fireTableRowsUpdated(0, this.fColors.size() - 1);
    }

    public String[] getStarts() {
        String[] stringArray = new String[this.fStarts.size()];
        return this.fStarts.toArray(stringArray);
    }

    public void setStarts(String[] stringArray) {
        this.fStarts.clear();
        this.fStarts.addAll(Arrays.asList(stringArray));
        this.fireTableRowsUpdated(0, this.fStarts.size() - 1);
    }

    public String[] getEnds() {
        String[] stringArray = new String[this.fEnds.size()];
        return this.fEnds.toArray(stringArray);
    }

    public void setEnds(String[] stringArray) {
        this.fEnds.clear();
        this.fEnds.addAll(Arrays.asList(stringArray));
        this.fireTableRowsUpdated(0, this.fEnds.size() - 1);
    }
}

