% Character strings.
%
% General.
%   char        - Create character array (string).
%   strings     - Help for strings.
%   cellstr     - Create cell array of strings from character array.
%   blanks      - String of blanks.
%   deblank     - Remove trailing blanks.
%
% String tests.
%   iscellstr   - True for cell array of strings.
%   ischar      - True for character array (string).
%   isspace     - True for white space characters.
%   isstrprop   - Check if string elements are of a specified category.
%
% String operations.
%   regexp      - Match regular expression.
%   regexpi     - Match regular expression, ignoring case.
%   regexprep   - Replace string using regular expression.
%   strcat      - Concatenate strings.
%   strcmp      - Compare strings.
%   strncmp     - Compare first N characters of strings.
%   strcmpi     - Compare strings ignoring case.
%   strncmpi    - Compare first N characters of strings ignoring case.
%   strfind     - Find one string within another.
%   strjust     - Justify character array.
%   strrep      - Replace string with another.
%   strtok      - Find token in string.
%   strtrim     - Remove insignificant whitespace.
%   upper       - Convert string to uppercase.
%   lower       - Convert string to lowercase.
%
% Character set conversion.
%   native2unicode - Convert bytes to Unicode characters.
%   unicode2native - Convert Unicode characters to bytes.
%
% String to number conversion.
%   num2str     - Convert numbers to a string.
%   int2str     - Convert integer to string.
%   mat2str     - Convert a 2-D matrix to a string in MATLAB syntax.
%   str2double  - Convert string to double precision value.
%   str2num     - Convert string matrix to numeric array.
%   sprintf     - Write formatted data to string.
%   sscanf      - Read string under format control.
%
% Base number conversion.
%   hex2num     - Convert hexadecimal string to double precision number.
%   hex2dec     - Convert hexadecimal string to decimal integer.
%   dec2hex     - Convert decimal integer to hexadecimal string.
%   bin2dec     - Convert binary string to decimal integer.
%   dec2bin     - Convert decimal integer to a binary string.
%   base2dec    - Convert base B string to decimal integer.
%   dec2base    - Convert decimal integer to base B string.
%   num2hex     - Convert singles and doubles to IEEE hexadecimal strings.
%
%   See also GENERAL, LANG, IOFUN, OPS, DATATYPES.

% Utility functions.
%   isletter   - True for letters of the alphabet.
% Obsolete functions.
%   strread     - Read formatted data from string.
%   str2mat     - Form blank padded character matrix from strings.
%   isstr       - True for character array (string).
%   setstr      - Convert numeric values into character string.
%   strvcat     - Vertically concatenate strings.
%   findstr     - Find one string within another.
%   strmatch    - Find possible matches for string.

%   Copyright 1984-2012 The MathWorks, Inc.
%   Generated from Contents.m_template revision 1.1.6.7  $Date: 2009/11/16 22:27:21 $




