/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CharacterAttributes;
import ice.pilots.html4.DNode;
import ice.pilots.html4.ThePilot;
import java.awt.Point;

public class Html4DocumentAccess {
    public static final int CHARACTER_TYPE = 1;
    public static final int WORD_TYPE = 2;
    public static final int SENTENCE_TYPE = 3;
    public static final int MAX_TYPE = 3;
    public static final int ALL = 0;
    CSSLayout _layout;
    ThePilot _pilot;

    public Html4DocumentAccess(ThePilot thePilot) {
        this._pilot = thePilot;
        this._layout = thePilot.getCSSLayout();
    }

    public Html4DocumentAccess() {
    }

    public String getCurrentText(int n) {
        return this._layout.getCurrentText(n);
    }

    public String getTextAt(int n, int n2, int n3, int n4, int n5) {
        return this._layout.getTextAt(n, n2, n3, n4, n5);
    }

    public String getText(int n, int n2) {
        return this._layout.getText(n, n2, true);
    }

    public void positionToIndex(int n, int n2) {
        this._layout.positionToIndex(n, n2);
    }

    public int getCaretPosition(int n) {
        return this._layout.getCaretPosition(n);
    }

    public CharacterAttributes getCharAttributes(int n) {
        CSSAttribs cSSAttribs = this._layout.getCharAttribs(n);
        return this.getCharAttributes(cSSAttribs);
    }

    private CharacterAttributes getCharAttributes(CSSAttribs cSSAttribs) {
        CharacterAttributes characterAttributes = new CharacterAttributes();
        CharacterAttributes.background_color = cSSAttribs.background_color;
        CharacterAttributes.background_image = cSSAttribs.background_image;
        CharacterAttributes.border_bottom_color = cSSAttribs.border_bottom_color;
        CharacterAttributes.border_bottom_style = cSSAttribs.border_bottom_style;
        CharacterAttributes.border_bottom_width = cSSAttribs.border_bottom_width;
        CharacterAttributes.border_left_color = cSSAttribs.border_left_color;
        CharacterAttributes.border_left_style = cSSAttribs.border_left_style;
        CharacterAttributes.border_left_width = cSSAttribs.border_left_width;
        CharacterAttributes.border_right_color = cSSAttribs.border_right_color;
        CharacterAttributes.border_right_style = cSSAttribs.border_right_style;
        CharacterAttributes.border_right_width = cSSAttribs.border_right_width;
        CharacterAttributes.border_top_color = cSSAttribs.border_top_color;
        CharacterAttributes.border_top_style = cSSAttribs.border_top_style;
        CharacterAttributes.border_top_width = cSSAttribs.border_top_width;
        CharacterAttributes.font_family = cSSAttribs.font_family;
        CharacterAttributes.font_size = cSSAttribs.font_size;
        CharacterAttributes.font_style = cSSAttribs.font_style;
        CharacterAttributes.margin_bottom = cSSAttribs.margin_bottom;
        CharacterAttributes.margin_left = cSSAttribs.margin_left;
        CharacterAttributes.margin_right = cSSAttribs.margin_right;
        CharacterAttributes.margin_top = cSSAttribs.margin_top;
        CharacterAttributes.padding_bottom = cSSAttribs.padding_bottom;
        CharacterAttributes.padding_left = cSSAttribs.padding_left;
        CharacterAttributes.padding_right = cSSAttribs.padding_right;
        CharacterAttributes.padding_top = cSSAttribs.padding_top;
        CharacterAttributes.text_align = cSSAttribs.text_align;
        CharacterAttributes.text_decoration = cSSAttribs.text_decoration;
        CharacterAttributes.text_indent = cSSAttribs.text_indent;
        CharacterAttributes.vertical_align_type = cSSAttribs.vertical_align_type;
        CharacterAttributes.color = cSSAttribs.color;
        CharacterAttributes.display = cSSAttribs.display;
        CharacterAttributes.outline_color = cSSAttribs.outline_color;
        CharacterAttributes.height = cSSAttribs.height;
        CharacterAttributes.line_height = cSSAttribs.line_height;
        CharacterAttributes.listStyleType = cSSAttribs.listStyleType;
        return characterAttributes;
    }

    public int getIndexOfNode(DNode dNode) {
        Point point = new Point();
        this._pilot.getView().findPosition(dNode, point);
        return this.getIndexAtPoint(point.x, point.y, 0, 0);
    }

    public int getIndexAtPoint(int n, int n2, int n3, int n4) {
        return this._layout.getIndexAtPoint(n, n2, n3, n4);
    }

    public DNode getNodeByIndex(int n, int n2) {
        return this._layout.getNodeByIndex(n, n2);
    }

    public String getNext(int n) {
        return this._layout.getNext(n);
    }

    public String getPrevious(int n) {
        return this._layout.getPrevious(n);
    }

    public int getSelectionStart() {
        return this._layout.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this._layout.getSelectionEnd();
    }

    public String getSelectedText() {
        return this._layout.getSelectedText();
    }

    public int getCount(int n) {
        return this._layout.getCount(n);
    }

    public void setSelection(int n, int n2, int n3, int n4) {
        if (!this._layout.docPane.enableTextSelection) {
            return;
        }
        this._layout.setSelection(n, n2, n3, n4, this._pilot.getDocPane().getScrollX(), this._pilot.getDocPane().getScrollY());
    }

    public void setSelection(int n, int n2, int n3) {
        if (!this._layout.docPane.enableTextSelection) {
            return;
        }
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                this._layout.selectWord(n2, n3, this._pilot.getDocPane().getScrollX(), this._pilot.getDocPane().getScrollY());
                break;
            }
            case 3: {
                break;
            }
            case 0: {
                this._layout.selectAll();
            }
        }
    }

    public void selectWordByIndex(int n) {
        this._layout.selectWordByIndex(n);
    }
}

