/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ImageConnection;
import ice.storm.UrlMaster;
import ice.util.Defs;
import ice.util.alg.HashArray;
import ice.util.alg.ResourceOwner;
import ice.util.alg.Session;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import java.awt.Image;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class ImageCache
implements ResourceOwner {
    private static final Object ENTRY_KEY = new Object();
    private static final HashArray proxyUrlToEntry = new HashArray(Defs.NO_SYNCHRONIZATION);
    private static long proxyCounter = 0L;
    private static boolean useImageConnection = true;
    private static Method imageIOMethod = null;
    private Session session;
    private int toUnload = 0;
    protected HashArray uriToEntry;
    protected HashArray imageToEntry;
    protected int timeout = 30;
    static final int NUMBER_OF_LOADER_THREADS = 4;
    private int animImageCounter = 0;
    private Toolkit awtToolkit;
    private boolean forceReload;

    protected ImageCache(Session session) {
        this.session = session;
        this.uriToEntry = new HashArray(Defs.NO_SYNCHRONIZATION);
        this.imageToEntry = new HashArray(Defs.NO_SYNCHRONIZATION);
        this.awtToolkit = Toolkit.getDefaultToolkit();
    }

    public static ImageCache get(Session session) {
        ImageCache imageCache = (ImageCache)session.getEntry(ENTRY_KEY);
        if (imageCache == null) {
            imageCache = ImageCache.set(session, new ImageCache(session));
        }
        return imageCache;
    }

    public static ImageCache set(Session session, ImageCache imageCache) {
        return (ImageCache)session.initEntry(ENTRY_KEY, (Object)imageCache);
    }

    public void setReload(boolean bl) {
        this.forceReload = bl;
    }

    public Toolkit getAwtToolkit() {
        return this.awtToolkit;
    }

    public void setExpire(int n) {
        this.timeout = n;
    }

    public int getExpire() {
        return this.timeout;
    }

    public void dispose() {
        this.disposeResources();
    }

    public void disposeResources() {
        this.flushImages(true);
    }

    public Image getImage(URL uRL) {
        return this.getImage(uRL.toExternalForm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(String string) {
        Entry entry;
        URL uRL = null;
        boolean bl = false;
        Image image = null;
        Object object = this;
        synchronized (object) {
            entry = (Entry)this.uriToEntry.get((Object)string);
            if (this.forceReload && entry != null && entry.image != null) {
                image = this.disconnectEntry(entry);
                entry = null;
            }
            if (entry == null) {
                entry = new Entry();
                entry.url = string;
                entry.realUrlObj = UrlMaster.get(this.session).newURL(string);
                if (entry.realUrlObj == null) {
                    return null;
                }
                this.uriToEntry.put((Object)string, (Object)entry);
                ++entry.ref;
                uRL = this.initProxyURL(entry) ? entry.proxyUrlObj : entry.realUrlObj;
            } else if (entry.image != null) {
                this.increaseRef(entry);
                return entry.image;
            }
        }
        if (image != null) {
            image.flush();
        }
        if (uRL != null) {
            if (entry.initializedImage) {
                Debug.bug();
            }
            object = this.getImageFromToolkit(uRL);
            Object object2 = this;
            synchronized (object2) {
                if (object != null) {
                    entry.image = object;
                    this.imageToEntry.put((Object)entry.image, (Object)entry);
                } else {
                    --entry.ref;
                    this.uriToEntry.remove((Object)entry.url);
                    this.clearProxyURL(entry);
                }
            }
            object2 = entry;
            synchronized (object2) {
                entry.initializedImage = true;
                entry.notifyAll();
            }
        }
        object = entry;
        synchronized (object) {
            if (!entry.initializedImage) {
                try {
                    entry.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        object = this;
        synchronized (object) {
            if (entry.image != null) {
                this.increaseRef(entry);
            }
        }
        return entry.image;
    }

    private void increaseRef(Entry entry) {
        entry.stopped = false;
        if (entry.flushBeforeReload) {
            entry.flushBeforeReload = false;
            entry.image.flush();
        }
        if (entry.ref == 0) {
            --this.toUnload;
        }
        ++entry.ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLoading(Image image) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            Entry entry = (Entry)this.imageToEntry.get((Object)image);
            if (entry == null) {
                return;
            }
            ImageConnection imageConnection = entry.ic;
            entry.ic = null;
            if (imageConnection != null) {
                entry.flushBeforeReload = imageConnection.reqToStop();
            } else {
                entry.stopped = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Image image) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            Entry entry = (Entry)this.imageToEntry.get((Object)image);
            if (entry != null) {
                --entry.ref;
                if (entry.ref == 0) {
                    ++this.toUnload;
                    entry.dieTime = System.currentTimeMillis() + (long)(this.timeout * 1000);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushImages(boolean bl) {
        if (!bl && this.toUnload == 0) {
            return;
        }
        Vector<Entry> vector = null;
        ImageCache imageCache = this;
        synchronized (imageCache) {
            long l = System.currentTimeMillis();
            HashArray.Iterator iterator = this.uriToEntry.newIterator();
            iterator.start();
            while (!iterator.done()) {
                Entry entry = (Entry)iterator.value();
                if (bl || entry.ref == 0 && entry.dieTime <= l) {
                    if (vector == null) {
                        vector = new Vector<Entry>();
                    }
                    vector.addElement(entry);
                }
                iterator.next();
            }
            if (vector != null) {
                int n = vector.size();
                for (int i = 0; i != n; ++i) {
                    Entry entry = (Entry)vector.elementAt(i);
                    Image image = this.disconnectEntry(entry);
                    vector.setElementAt((Entry)((Object)image), i);
                }
            }
        }
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i != n; ++i) {
                Image image = (Image)vector.elementAt(i);
                if (image == null) continue;
                try {
                    image.flush();
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    if (!Debug.ex) continue;
                    Debug.ex((Throwable)nullPointerException);
                }
            }
        }
    }

    private Image disconnectEntry(Entry entry) {
        Image image;
        this.uriToEntry.remove((Object)entry.url);
        this.clearProxyURL(entry);
        if (entry.ref == 0) {
            --this.toUnload;
        }
        if ((image = entry.image) != null) {
            this.imageToEntry.remove((Object)image);
            entry.image = null;
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForAnimatedImagesBug() {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            ++this.animImageCounter;
            if (Debug.trace) {
                Debug.trace((String)("animImageCounter==" + this.animImageCounter));
            }
            if (this.animImageCounter >= 4) {
                block9: {
                    try {
                        if (Debug.trace) {
                            Debug.trace((String)"--> Initiating recovery");
                        }
                        URL uRL = this.getClass().getResource("resources/dummyimage.gif");
                        Image image = this.getImageFromToolkit(uRL);
                        this.awtToolkit.prepareImage(image, -1, -1, null);
                        image.flush();
                    }
                    catch (Exception exception) {
                        if (!Debug.ex) break block9;
                        Debug.ex((Throwable)exception);
                    }
                }
                if (Debug.trace) {
                    Debug.trace((String)"--> --> Recovery done");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getImageFromToolkit(final URL uRL) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            --this.animImageCounter;
            if (this.animImageCounter < 0) {
                this.animImageCounter = 0;
            }
        }
        return (Image)SecurityKit.doPrivileged((BoxedCode)new BoxedCode(){

            public Object run() {
                return ImageCache.this.factoryGetImage(uRL);
            }
        });
    }

    protected Image factoryGetImage(URL uRL) {
        if (imageIOMethod != null) {
            Object[] objectArray = new Object[]{uRL};
            try {
                Image image = (Image)imageIOMethod.invoke(null, objectArray);
                return image;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.awtToolkit.getImage(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initProxyURL(Entry entry) {
        if (useImageConnection) {
            HashArray hashArray = proxyUrlToEntry;
            synchronized (hashArray) {
                URL uRL;
                String string = "image:" + ++proxyCounter;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    useImageConnection = true;
                    uRL = null;
                }
                if (uRL != null) {
                    entry.proxyUrlObj = uRL;
                    proxyUrlToEntry.put((Object)uRL, (Object)entry);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearProxyURL(Entry entry) {
        URL uRL = entry.proxyUrlObj;
        if (uRL != null) {
            HashArray hashArray = proxyUrlToEntry;
            synchronized (hashArray) {
                proxyUrlToEntry.remove((Object)uRL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL setImageConnection(URL uRL, ImageConnection imageConnection) {
        Entry entry;
        HashArray hashArray = proxyUrlToEntry;
        synchronized (hashArray) {
            entry = (Entry)proxyUrlToEntry.get((Object)uRL);
        }
        if (entry != null) {
            entry.ic = imageConnection;
            if (entry.stopped) {
                entry.flushBeforeReload = true;
                return null;
            }
            return entry.realUrlObj;
        }
        return null;
    }

    static {
        if (Defs.sysPropertyBoolean((String)"ice.storm.use14")) {
            try {
                Class<?> clazz = Class.forName("javax.imageio.ImageIO");
                Class[] classArray = new Class[1];
                URL uRL = new URL("http://dummy.org");
                classArray[0] = uRL.getClass();
                imageIOMethod = clazz.getMethod("read", classArray);
            }
            catch (Throwable throwable) {
                if (Debug.trace) {
                    Debug.trace((String)"ImageCache: Java 1.4 Imaging subsystem not found.");
                }
                imageIOMethod = null;
            }
        }
    }

    private class Entry {
        boolean initializedImage;
        Image image;
        String url;
        int ref;
        long dieTime;
        URL proxyUrlObj;
        URL realUrlObj;
        ImageConnection ic;
        volatile boolean flushBeforeReload = false;
        volatile boolean stopped = false;

        private Entry() {
        }
    }
}

