/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.mls;

import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.MathWorksWebServiceClient;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.client.core.http.MathWorksHttpClient;
import com.mathworks.webservices.client.core.http.ResponseHandler;
import com.mathworks.webservices.client.core.xml.JaxbResponseHandler;
import com.mathworks.webservices.mls.MathWorksLicenseServerClient;
import com.mathworks.webservices.mls.model.DescribeEntitlementsRequest;
import com.mathworks.webservices.mls.model.DescribeEntitlementsResponse;
import com.mathworks.webservices.mls.model.FeatureCheckoutRequest;
import com.mathworks.webservices.mls.model.FeatureCheckoutResponse;
import com.mathworks.webservices.mls.model.MachineAttributes;
import com.mathworks.webservices.mls.model.SessionHeartbeatRequest;
import com.mathworks.webservices.mls.model.SessionHeartbeatResponse;
import com.mathworks.webservices.mls.model.StartSessionRequest;
import com.mathworks.webservices.mls.model.StartSessionResponse;
import com.mathworks.webservices.mls.model.StopSessionRequest;
import com.mathworks.webservices.mls.model.StopSessionResponse;

public class MathWorksLicenseServerClientImpl
extends MathWorksWebServiceClient
implements MathWorksLicenseServerClient {
    public MathWorksLicenseServerClientImpl() {
        this(new ClientConfiguration());
    }

    public MathWorksLicenseServerClientImpl(ClientConfiguration clientConfiguration) {
        super(clientConfiguration, (ResponseHandler)new JaxbResponseHandler("com.mathworks.webservices.mls.model"));
    }

    protected MathWorksLicenseServerClientImpl(MathWorksHttpClient httpClient) {
        super(httpClient, (ResponseHandler)new JaxbResponseHandler("com.mathworks.webservices.mls.model"));
    }

    @Override
    public DescribeEntitlementsResponse describeEntitlements(DescribeEntitlementsRequest request) throws MathWorksServiceException, MathWorksClientException {
        HttpRequest req = new HttpRequest(HttpMethodName.POST, this.endpoint, this.getVersionUrl("/entitlement/list"));
        req.withParameter("token", request.getToken()).withParameter("release", request.getRelease());
        for (String coreProduct : request.getCoreProducts()) {
            req.withParameter("coreProduct", coreProduct);
        }
        if (request.getContext() != null) {
            req.withParameter("context", request.getContext());
        }
        req.setLocale(request.getLocale());
        req.setClientString(request.getClientString());
        return (DescribeEntitlementsResponse)this.executeRequest(req);
    }

    @Override
    public StartSessionResponse startSession(StartSessionRequest request) throws MathWorksServiceException, MathWorksClientException {
        HttpRequest req = new HttpRequest(HttpMethodName.POST, this.endpoint, this.getVersionUrl("/session/start"));
        req.withParameter("token", request.getToken()).withParameter("entitlementId", request.getEntitlementId()).withParameter("release", request.getRelease());
        for (String featureName : request.getFeatureNames()) {
            req.withParameter("featureName", featureName);
        }
        MachineAttributes ma = request.getMachineAttributes();
        if (null != ma) {
            req.withParameter("machineHostId", ma.getHostId()).withParameter("machineOwnerId", ma.getOwnerId()).withParameter("machineGroupId", ma.getGroupId());
        }
        if (request.getContext() != null) {
            req.withParameter("context", request.getContext());
        }
        req.setLocale(request.getLocale());
        req.setClientString(request.getClientString());
        req.setSignature(request.getSignature());
        req.setSalt(request.getSalt());
        return (StartSessionResponse)this.executeRequest(req);
    }

    @Override
    public SessionHeartbeatResponse sessionHeartbeat(SessionHeartbeatRequest request) throws MathWorksServiceException, MathWorksClientException {
        HttpRequest req = new HttpRequest(HttpMethodName.POST, this.endpoint, this.getVersionUrl("/session/heartbeat"));
        req.withParameter("sessionId", request.getSessionId());
        req.setLocale(request.getLocale());
        req.setClientString(request.getClientString());
        req.setSignature(request.getSignature());
        req.setSalt(request.getSalt());
        return (SessionHeartbeatResponse)this.executeRequest(req);
    }

    @Override
    public StopSessionResponse stopSession(StopSessionRequest request) throws MathWorksServiceException, MathWorksClientException {
        HttpRequest req = new HttpRequest(HttpMethodName.POST, this.endpoint, this.getVersionUrl("/session/stop"));
        req.withParameter("token", request.getToken()).withParameter("sessionId", request.getSessionId());
        req.setLocale(request.getLocale());
        req.setClientString(request.getClientString());
        req.setSignature(request.getSignature());
        req.setSalt(request.getSalt());
        return (StopSessionResponse)this.executeRequest(req);
    }

    @Override
    public FeatureCheckoutResponse featureCheckout(FeatureCheckoutRequest request) throws MathWorksServiceException, MathWorksClientException {
        HttpRequest req = new HttpRequest(HttpMethodName.POST, this.endpoint, this.getVersionUrl("/feature/checkout"));
        req.withParameter("token", request.getToken()).withParameter("entitlementId", request.getEntitlementId()).withParameter("release", request.getRelease());
        for (String featureName : request.getFeatures()) {
            req.withParameter("featureName", featureName);
        }
        req.setLocale(request.getLocale());
        req.setClientString(request.getClientString());
        req.setSignature(request.getSignature());
        req.setSalt(request.getSalt());
        return (FeatureCheckoutResponse)this.executeRequest(req);
    }

    String getVersionUrl(String url) {
        return url;
    }
}

