/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hadoop.unittest;

import com.mathworks.hadoop.MWMapReduceDriver;
import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.mapreduce.lib.input.InvalidInputException;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;

public class MWMapReduceDriverTest
extends TestCase {
    private static String workingDir = "";
    private static String workingArchDir = "";
    private static String hadoopVer = "";
    private static String arch = "";

    public static void main(String[] args) {
        TestRunner.run((Test)MWMapReduceDriverTest.suite());
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new MWMapReduceDriverTest("testMWMRDriverRunNegativeTests"));
        suite.addTest((Test)new MWMapReduceDriverTest("testMWMRDriverBadInput"));
        suite.addTest((Test)new MWMapReduceDriverTest("testMWMRDriverMain"));
        return suite;
    }

    public MWMapReduceDriverTest(String s) {
        super(s);
    }

    protected void setUp() throws Exception {
        super.setUp();
        workingDir = System.getProperty("path_to_unittest") + File.separator;
        workingArchDir = System.getProperty("unittest_built_dir") + File.separator;
        hadoopVer = System.getProperty("hadoop_ver");
        arch = System.getProperty("arch");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public int testMWMRDriverRunNegativeTests() {
        int ret = 1;
        int retVal = 0;
        try {
            String[] args = null;
            retVal = ToolRunner.run((Tool)new MWMapReduceDriver(), args);
            Assert.assertNotEquals((String)"ToolRunner.run(null) unexpectedly succeeded; return value:", (long)0L, (long)retVal);
            args = new String[]{};
            retVal = ToolRunner.run((Tool)new MWMapReduceDriver(), (String[])args);
            Assert.assertNotEquals((String)"ToolRunner.run() unexpectedly succeeded with empty args; return value:", (long)0L, (long)retVal);
            args = new String[]{"invalidCTF", "invalidInput", "invalidOutput"};
            retVal = ToolRunner.run((Tool)new MWMapReduceDriver(), (String[])args);
            Assert.assertNotEquals((String)"ToolRunner.run() unexpectedly succeeded with invalid args; return value:", (long)0L, (long)retVal);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("PRINTING EXCEPTION: " + e.getMessage());
        }
        return ret;
    }

    public int testMWMRDriverBadInput() {
        int ret = 1;
        try {
            String[] args = new String[]{workingArchDir + "airline.ctf", "invalidInput", "invalidOutput"};
            ToolRunner.run((Tool)new MWMapReduceDriver(), (String[])args);
        }
        catch (InvalidInputException e) {
            return 1;
        }
        catch (IOException e) {
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            MWMapReduceDriverTest.fail((String)("ToolRunner.run() threw unexpected exception with invalid input specified. Exception: " + e.toString()));
        }
        return ret;
    }

    public int testMWMRDriverMain() {
        int ret = 1;
        try {
            if (hadoopVer.equals("2.2.0")) {
                System.out.println("Skipping test for " + hadoopVer + ": testMWMRDriverMain");
                return 1;
            }
            if (!arch.equals("glnxa64")) {
                return 1;
            }
            String[] args = null;
            String newDir = System.getProperty("java.io.tmpdir") + File.separator + RandomStringUtils.random((int)4, (boolean)true, (boolean)false);
            System.out.println("newDir: " + newDir);
            args = new String[]{workingArchDir + "airline.ctf", workingDir + "small_airline_test.csv", newDir};
            MWMapReduceDriver.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            MWMapReduceDriverTest.fail((String)("testMWMRDriverMain failed. Exception: " + e.toString()));
        }
        return ret;
    }
}

