/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.peermodel.impl;

import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.ObservableSyncable;
import com.mathworks.peermodel.events.Observer;
import com.mathworks.peermodel.events.PeerModelEvent;
import com.mathworks.peermodel.events.PeerModelListenable;
import com.mathworks.peermodel.events.PeerModelListener;
import com.mathworks.peermodel.events.PeerNodeEvent;
import com.mathworks.peermodel.events.PeerNodeListenable;
import com.mathworks.peermodel.events.PeerNodeListener;
import com.mathworks.peermodel.impl.EventImpl;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ObservableImpl
implements PeerNodeListenable,
PeerModelListenable,
ObservableSyncable {
    private final Map<String, Set<Observer>> syncListeners = new HashMap<String, Set<Observer>>();
    private final Map<String, Set<Observer>> listeners = new HashMap<String, Set<Observer>>();
    private final ReadWriteLock locks = new ReentrantReadWriteLock();
    private Map<EventListener, PeerNodeListenerAdapter> adapters = new WeakHashMap<EventListener, PeerNodeListenerAdapter>();

    public void addEventListener(String type, Observer observer) {
        this.addEventListenerHelper(this.listeners, type, observer);
    }

    public void addSyncEventListener(String type, Observer observer) {
        this.addEventListenerHelper(this.syncListeners, type, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEventListenerHelper(Map<String, Set<Observer>> listeners, String type, Observer observer) {
        this.locks.writeLock().lock();
        try {
            if (!listeners.containsKey(type)) {
                listeners.put(type, new HashSet());
            }
            Set<Observer> observers = listeners.get(type);
            observers.add(observer);
        }
        finally {
            this.locks.writeLock().unlock();
        }
    }

    public void removeEventListener(String type, Observer observer) {
        this.removeEventListenerHelper(this.listeners, type, observer);
    }

    public void removeSyncEventListener(String type, Observer observer) {
        this.removeEventListenerHelper(this.syncListeners, type, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListenerHelper(Map<String, Set<Observer>> listeners, String type, Observer observer) {
        block5: {
            this.locks.writeLock().lock();
            try {
                if (this.hasEventListenerHelper(listeners, type, observer)) {
                    Set<Observer> observers = listeners.get(type);
                    observers.remove(observer);
                    if (observers.isEmpty()) {
                        listeners.remove(type);
                    }
                    break block5;
                }
                throw new IllegalArgumentException("Observer does not exist for the specified event type.");
            }
            finally {
                this.locks.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEventListener(String type, Observer observer) {
        this.locks.readLock().lock();
        try {
            boolean bl = this.hasEventListenerHelper(this.listeners, type, observer);
            return bl;
        }
        finally {
            this.locks.readLock().unlock();
        }
    }

    private boolean hasEventListenerHelper(Map<String, Set<Observer>> listeners, String type, Observer observer) {
        boolean exists = false;
        if (listeners.containsKey(type) && listeners.get(type).contains(observer)) {
            exists = true;
        }
        return exists;
    }

    public void dispatchEvent(String type, PeerNode target, Map<String, Object> data) {
        this.dispatchEvent(type, null, target, data);
    }

    public void dispatchEvent(String type, Object originator, PeerNode target, Map<String, Object> data) {
        this.dispatchEvent(new EventImpl(type, originator, target, data));
    }

    public void dispatchEvent(Event event) {
        this.dispatchEventToListener(this.syncListeners, event);
        this.dispatchEventToListener(this.listeners, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEventToListener(Map<String, Set<Observer>> listeners, Event event) {
        HashSet observersCopy;
        this.locks.readLock().lock();
        try {
            if (!listeners.containsKey(event.getType())) {
                return;
            }
            observersCopy = new HashSet(listeners.get(event.getType()));
        }
        finally {
            this.locks.readLock().unlock();
        }
        for (Observer observer : observersCopy) {
            observer.handle(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerNodeListener(PeerNodeListener listener) {
        this.locks.writeLock().lock();
        try {
            PeerNodeListenerAdapter adapter = new PeerNodeListenerAdapter((EventListener)listener);
            this.adapters.put((EventListener)listener, adapter);
            this.addEventListener("propertySet", adapter);
            this.addEventListener("propertiesSet", adapter);
            this.addEventListener("propertyUnset", adapter);
            this.addEventListener("childAdded", adapter);
            this.addEventListener("childRemoved", adapter);
            this.addEventListener("childReattached", adapter);
            this.addEventListener("destroyed", adapter);
            this.addEventListener("peerEvent", adapter);
        }
        finally {
            this.locks.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeerNodeListener(PeerNodeListener listener) {
        this.locks.writeLock().lock();
        try {
            if (this.adapters.containsKey(listener)) {
                PeerNodeListenerAdapter adapter = this.adapters.get(listener);
                this.adapters.remove(listener);
                this.removeEventListener("propertySet", adapter);
                this.removeEventListener("propertiesSet", adapter);
                this.removeEventListener("propertyUnset", adapter);
                this.removeEventListener("childAdded", adapter);
                this.removeEventListener("childRemoved", adapter);
                this.removeEventListener("childReattached", adapter);
                this.removeEventListener("destroyed", adapter);
                this.removeEventListener("peerEvent", adapter);
            }
        }
        finally {
            this.locks.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerModelListener(PeerModelListener listener) {
        this.locks.writeLock().lock();
        try {
            PeerNodeListenerAdapter adapter = new PeerNodeListenerAdapter((EventListener)listener);
            this.adapters.put((EventListener)listener, adapter);
            this.addEventListener("rootSet", adapter);
            this.addEventListener("rootUnset", adapter);
            this.addEventListener("childMoved", adapter);
            this.addEventListener("syncChanged", adapter);
        }
        finally {
            this.locks.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeerModelListener(PeerModelListener listener) {
        this.locks.writeLock().lock();
        try {
            if (this.adapters.containsKey(listener)) {
                PeerNodeListenerAdapter adapter = this.adapters.get(listener);
                this.adapters.remove(listener);
                this.removeEventListener("rootSet", adapter);
                this.removeEventListener("rootUnset", adapter);
                this.removeEventListener("childMoved", adapter);
                this.removeEventListener("syncChanged", adapter);
            }
        }
        finally {
            this.locks.writeLock().unlock();
        }
    }

    public void addPeerEventListener(String type, Observer observer) {
        this.addEventListener("peerEvent", new PeerEventObserver(type, observer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeerEventListener(String type, Observer observer) {
        block4: {
            this.locks.writeLock().lock();
            try {
                PeerEventObserver peerEventObserver = this.getPeerEventObserver(type, observer);
                if (peerEventObserver != null) {
                    this.removeEventListener("peerEvent", peerEventObserver);
                    break block4;
                }
                throw new IllegalArgumentException("Observer does not exist for the specified event type.");
            }
            finally {
                this.locks.writeLock().unlock();
            }
        }
    }

    public boolean hasPeerEventListener(String type, Observer observer) {
        PeerEventObserver peerEventObserver = this.getPeerEventObserver(type, observer);
        return peerEventObserver != null;
    }

    private PeerEventObserver getPeerEventObserver(String type, Observer observer) {
        if (this.listeners.containsKey("peerEvent")) {
            for (Observer listener : this.listeners.get("peerEvent")) {
                if (!(listener instanceof PeerEventObserver) || !((PeerEventObserver)listener).type.equals(type) || ((PeerEventObserver)listener).observer != observer) continue;
                return (PeerEventObserver)listener;
            }
        }
        return null;
    }

    public void dispatchPeerEvent(String type, PeerNode target, Map<String, Object> data) {
        this.dispatchPeerEvent(type, null, target, data);
    }

    public void dispatchPeerEvent(String type, Object originator, PeerNode target, Map<String, Object> data) {
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        data.put("type", type);
        this.dispatchEvent("peerEvent", originator, target, data);
    }

    private class PeerNodeListenerAdapter
    implements Observer {
        private final EventListener listener;

        public PeerNodeListenerAdapter(EventListener listener) {
            this.listener = listener;
        }

        public void handle(Event event) {
            if (!(event instanceof PeerNodeEvent)) {
                return;
            }
            if (event.getType().equals("propertySet")) {
                ((PeerNodeListener)this.listener).propertySet((PeerNodeEvent)event);
            } else if (event.getType().equals("propertiesSet")) {
                ((PeerNodeListener)this.listener).propertiesSet((PeerNodeEvent)event);
            } else if (event.getType().equals("propertyUnset")) {
                ((PeerNodeListener)this.listener).propertyUnset((PeerNodeEvent)event);
            } else if (event.getType().equals("childAdded")) {
                ((PeerNodeListener)this.listener).childAdded((PeerNodeEvent)event);
            } else if (event.getType().equals("childRemoved")) {
                ((PeerNodeListener)this.listener).childRemoved((PeerNodeEvent)event);
            } else if (event.getType().equals("childReattached")) {
                ((PeerNodeListener)this.listener).childReattached((PeerNodeEvent)event);
            } else if (event.getType().equals("destroyed")) {
                ((PeerNodeListener)this.listener).destroyed((PeerNodeEvent)event);
            } else if (event.getType().equals("peerEvent")) {
                ((PeerNodeListener)this.listener).peerEvent((PeerNodeEvent)event);
            } else if (event.getType().equals("rootSet")) {
                ((PeerModelListener)this.listener).rootSet((PeerModelEvent)event);
            } else if (event.getType().equals("rootUnset")) {
                ((PeerModelListener)this.listener).rootUnset((PeerModelEvent)event);
            } else if (event.getType().equals("childMoved")) {
                ((PeerModelListener)this.listener).childMoved((PeerModelEvent)event);
            } else if (event.getType().equals("syncChanged")) {
                ((PeerModelListener)this.listener).syncChanged((PeerModelEvent)event);
            }
        }
    }

    private class PeerEventObserver
    implements Observer {
        public final String type;
        public final Observer observer;

        public PeerEventObserver(String type, Observer observer) {
            this.type = type;
            this.observer = observer;
        }

        public void handle(Event event) {
            if (event.getData().containsKey("type") && event.getData().get("type").equals(this.type)) {
                this.observer.handle(event);
            }
        }
    }
}

