/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxTreeCellRenderer;
import com.jidesoft.swing.CheckBoxTreeSelectionModel;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TristateCheckBox;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxTree
extends JTree {
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_CLICK_IN_CHECKBOX_ONLY = "clickInCheckBoxOnly";
    public static final String PROPERTY_DIG_IN = "digIn";
    protected CheckBoxTreeCellRenderer _treeCellRenderer;
    private CheckBoxTreeSelectionModel _checkBoxTreeSelectionModel;
    private boolean _checkBoxEnabled = true;
    private boolean _clickInCheckBoxOnly = true;
    private PropertyChangeListener _modelChangeListener;
    private TristateCheckBox _checkBox;
    private boolean _selectPartialOnToggling = true;
    private TreeCellRenderer _defaultRenderer;

    public CheckBoxTree() {
        this.init();
    }

    public CheckBoxTree(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    public CheckBoxTree(Vector<?> vector) {
        super(vector);
        this.init();
    }

    public CheckBoxTree(Hashtable<?, ?> hashtable) {
        super(hashtable);
        this.init();
    }

    public CheckBoxTree(TreeNode treeNode) {
        super(treeNode);
        this.init();
    }

    public CheckBoxTree(TreeNode treeNode, boolean bl) {
        super(treeNode, bl);
        this.init();
    }

    public CheckBoxTree(TreeModel treeModel) {
        super(treeModel);
        this.init();
    }

    protected void init() {
        this._checkBoxTreeSelectionModel = this.createCheckBoxTreeSelectionModel(this.getModel());
        this._checkBoxTreeSelectionModel.setTree(this);
        Handler handler = this.createHandler();
        JideSwingUtilities.insertMouseListener(this, handler, 0);
        this.addKeyListener(handler);
        this._checkBoxTreeSelectionModel.addTreeSelectionListener(handler);
        if (this._modelChangeListener == null) {
            this._modelChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
                        CheckBoxTree.this.updateRowMapper();
                    }
                    if ("model".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof TreeModel) {
                        CheckBoxTree.this._checkBoxTreeSelectionModel.setModel((TreeModel)propertyChangeEvent.getNewValue());
                    }
                }
            };
        }
        this.addPropertyChangeListener("selectionModel", this._modelChangeListener);
        this.addPropertyChangeListener("model", this._modelChangeListener);
        this.updateRowMapper();
    }

    protected CheckBoxTreeSelectionModel createCheckBoxTreeSelectionModel(TreeModel treeModel) {
        return new CheckBoxTreeSelectionModel(treeModel);
    }

    private void updateRowMapper() {
        this._checkBoxTreeSelectionModel.setRowMapper(this.getSelectionModel().getRowMapper());
    }

    @Override
    public TreeCellRenderer getCellRenderer() {
        TreeCellRenderer treeCellRenderer = this.getActualCellRenderer();
        if (treeCellRenderer == null) {
            treeCellRenderer = this.getDefaultRenderer();
        }
        if (this._treeCellRenderer == null) {
            this._treeCellRenderer = this.createCellRenderer(treeCellRenderer);
        } else {
            this._treeCellRenderer.setActualTreeRenderer(treeCellRenderer);
        }
        return this._treeCellRenderer;
    }

    private TreeCellRenderer getDefaultRenderer() {
        if (this._defaultRenderer == null) {
            this._defaultRenderer = new DefaultTreeCellRenderer();
        }
        return this._defaultRenderer;
    }

    public TreeCellRenderer getActualCellRenderer() {
        if (this._treeCellRenderer != null) {
            return this._treeCellRenderer.getActualTreeRenderer();
        }
        return super.getCellRenderer();
    }

    @Override
    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        if (treeCellRenderer == null) {
            treeCellRenderer = this.getDefaultRenderer();
        }
        super.setCellRenderer(treeCellRenderer);
        if (this._treeCellRenderer != null) {
            this._treeCellRenderer.setActualTreeRenderer(treeCellRenderer);
        }
    }

    protected CheckBoxTreeCellRenderer createCellRenderer(TreeCellRenderer treeCellRenderer) {
        final CheckBoxTreeCellRenderer checkBoxTreeCellRenderer = new CheckBoxTreeCellRenderer(treeCellRenderer, this.getCheckBox());
        this.addPropertyChangeListener("cellRenderer", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TreeCellRenderer treeCellRenderer = (TreeCellRenderer)propertyChangeEvent.getNewValue();
                if (treeCellRenderer != checkBoxTreeCellRenderer) {
                    checkBoxTreeCellRenderer.setActualTreeRenderer(treeCellRenderer);
                } else {
                    checkBoxTreeCellRenderer.setActualTreeRenderer(null);
                }
            }
        });
        return checkBoxTreeCellRenderer;
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    public TristateCheckBox getCheckBox() {
        return this._checkBox;
    }

    public void setCheckBox(TristateCheckBox tristateCheckBox) {
        if (this._checkBox != tristateCheckBox) {
            this._checkBox = tristateCheckBox;
            this._treeCellRenderer = null;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isSelectPartialOnToggling() {
        return this._selectPartialOnToggling;
    }

    public void setSelectPartialOnToggling(boolean bl) {
        this._selectPartialOnToggling = bl;
    }

    @Override
    public TreePath getNextMatch(String string, int n, Position.Bias bias) {
        return null;
    }

    public CheckBoxTreeSelectionModel getCheckBoxTreeSelectionModel() {
        return this._checkBoxTreeSelectionModel;
    }

    public boolean isCheckBoxEnabled() {
        return this._checkBoxEnabled;
    }

    public void setCheckBoxEnabled(boolean bl) {
        if (bl != this._checkBoxEnabled) {
            Boolean bl2 = this._checkBoxEnabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
            this._checkBoxEnabled = bl;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, bl2, bl3);
            this.repaint();
        }
    }

    public boolean isCheckBoxEnabled(TreePath treePath) {
        return true;
    }

    public boolean isCheckBoxVisible(TreePath treePath) {
        return true;
    }

    public boolean isDigIn() {
        return this.getCheckBoxTreeSelectionModel().isDigIn();
    }

    public void setDigIn(boolean bl) {
        boolean bl2 = this.isDigIn();
        if (bl2 != bl) {
            this.getCheckBoxTreeSelectionModel().setDigIn(bl);
            this.firePropertyChange(PROPERTY_DIG_IN, bl2, bl);
        }
    }

    public boolean isClickInCheckBoxOnly() {
        return this._clickInCheckBoxOnly;
    }

    public void setClickInCheckBoxOnly(boolean bl) {
        if (bl != this._clickInCheckBoxOnly) {
            boolean bl2 = this._clickInCheckBoxOnly;
            this._clickInCheckBoxOnly = bl;
            this.firePropertyChange(PROPERTY_CLICK_IN_CHECKBOX_ONLY, bl2, this._clickInCheckBoxOnly);
        }
    }

    protected static class Handler
    implements MouseListener,
    KeyListener,
    TreeSelectionListener {
        protected CheckBoxTree _tree;
        int _hotspot;
        private int _toggleCount;

        public Handler(CheckBoxTree checkBoxTree) {
            this._hotspot = new JCheckBox().getPreferredSize().width;
            this._toggleCount = -1;
            this._tree = checkBoxTree;
        }

        protected TreePath getTreePathForMouseEvent(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return null;
            }
            if (!this._tree.isCheckBoxEnabled()) {
                return null;
            }
            TreePath treePath = this._tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return null;
            }
            if (this.clicksInCheckBox(mouseEvent, treePath) || !this._tree.isClickInCheckBoxOnly()) {
                return treePath;
            }
            return null;
        }

        protected boolean clicksInCheckBox(MouseEvent mouseEvent, TreePath treePath) {
            if (!this._tree.isCheckBoxVisible(treePath)) {
                return false;
            }
            Rectangle rectangle = this._tree.getPathBounds(treePath);
            if (this._tree.getComponentOrientation().isLeftToRight()) {
                return mouseEvent.getX() < rectangle.x + this._hotspot;
            }
            return mouseEvent.getX() > rectangle.x + rectangle.width - this._hotspot;
        }

        private TreePath preventToggleEvent(MouseEvent mouseEvent) {
            int n;
            TreePath treePath = this.getTreePathForMouseEvent(mouseEvent);
            if (treePath != null && (n = this._tree.getToggleClickCount()) != -1) {
                this._toggleCount = n;
                this._tree.setToggleClickCount(-1);
            }
            return treePath;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.preventToggleEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            TreePath treePath = this.preventToggleEvent(mouseEvent);
            if (treePath != null) {
                this.toggleSelections(new TreePath[]{treePath});
                mouseEvent.consume();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            TreePath treePath = this.preventToggleEvent(mouseEvent);
            if (treePath != null) {
                mouseEvent.consume();
            }
            if (this._toggleCount != -1) {
                this._tree.setToggleClickCount(this._toggleCount);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (!this._tree.isCheckBoxEnabled()) {
                return;
            }
            if (keyEvent.getModifiers() == 0 && keyEvent.getKeyChar() == ' ') {
                this.toggleSelections();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this._tree.treeDidChange();
        }

        protected void toggleSelections() {
            TreePath[] treePathArray = this._tree.getSelectionPaths();
            this.toggleSelections(treePathArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void toggleSelections(TreePath[] treePathArray) {
            if (treePathArray == null || treePathArray.length == 0 || !this._tree.isEnabled()) {
                return;
            }
            if (treePathArray.length == 1 && !this._tree.isCheckBoxEnabled(treePathArray[0])) {
                return;
            }
            CheckBoxTreeSelectionModel checkBoxTreeSelectionModel = this._tree.getCheckBoxTreeSelectionModel();
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            ArrayList<TreePath> arrayList2 = new ArrayList<TreePath>();
            for (TreePath treePath : treePathArray) {
                boolean bl = checkBoxTreeSelectionModel.isPathSelected(treePath, checkBoxTreeSelectionModel.isDigIn());
                if (bl) {
                    arrayList2.add(treePath);
                    continue;
                }
                if (!this._tree.isSelectPartialOnToggling() && checkBoxTreeSelectionModel.isPartiallySelected(treePath)) {
                    TreePath[] treePathArray2 = checkBoxTreeSelectionModel.getSelectionPaths();
                    if (treePathArray2 == null) continue;
                    for (TreePath treePath2 : treePathArray2) {
                        if (!checkBoxTreeSelectionModel.isDescendant(treePath2, treePath)) continue;
                        arrayList2.add(treePath2);
                    }
                    continue;
                }
                arrayList.add(treePath);
            }
            checkBoxTreeSelectionModel.removeTreeSelectionListener(this);
            try {
                if (arrayList.size() > 0) {
                    checkBoxTreeSelectionModel.addSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
                }
                if (arrayList2.size() > 0) {
                    checkBoxTreeSelectionModel.removeSelectionPaths(arrayList2.toArray(new TreePath[arrayList2.size()]));
                }
            }
            finally {
                checkBoxTreeSelectionModel.addTreeSelectionListener(this);
                this._tree.treeDidChange();
            }
        }
    }
}

