/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.awt.geom.AffineTransform;
import org.apache.fop.afp.AFPLineDataInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPUnitConverter;
import org.apache.fop.afp.AbstractAFPPainter;
import org.apache.fop.afp.BorderPaintingInfo;
import org.apache.fop.afp.DataStream;
import org.apache.fop.afp.PaintingInfo;
import org.apache.fop.util.ColorUtil;

public class AFPBorderPainter
extends AbstractAFPPainter {
    public AFPBorderPainter(AFPPaintingState aFPPaintingState, DataStream dataStream) {
        super(aFPPaintingState, dataStream);
    }

    public void paint(PaintingInfo paintingInfo) {
        BorderPaintingInfo borderPaintingInfo = (BorderPaintingInfo)paintingInfo;
        float f = borderPaintingInfo.getX2() - borderPaintingInfo.getX1();
        float f2 = borderPaintingInfo.getY2() - borderPaintingInfo.getY1();
        if (f < 0.0f || f2 < 0.0f) {
            log.error((Object)"Negative extent received. Border won't be painted.");
            return;
        }
        int n = this.dataStream.getCurrentPage().getWidth();
        int n2 = this.dataStream.getCurrentPage().getHeight();
        AFPUnitConverter aFPUnitConverter = this.paintingState.getUnitConverter();
        AffineTransform affineTransform = this.paintingState.getData().getTransform();
        float f3 = aFPUnitConverter.pt2units(borderPaintingInfo.getX1());
        float f4 = aFPUnitConverter.pt2units(borderPaintingInfo.getY1());
        float f5 = aFPUnitConverter.pt2units(borderPaintingInfo.getX2());
        float f6 = aFPUnitConverter.pt2units(borderPaintingInfo.getY2());
        switch (this.paintingState.getRotation()) {
            case 90: {
                f3 = (float)((double)f3 + affineTransform.getTranslateY());
                f4 += (float)((double)n - affineTransform.getTranslateX());
                f5 = (float)((double)f5 + affineTransform.getTranslateY());
                f6 += (float)((double)n - affineTransform.getTranslateX());
                break;
            }
            case 180: {
                f3 += (float)((double)n - affineTransform.getTranslateX());
                f4 += (float)((double)n2 - affineTransform.getTranslateY());
                f5 += (float)((double)n - affineTransform.getTranslateX());
                f6 += (float)((double)n2 - affineTransform.getTranslateY());
                break;
            }
            case 270: {
                f3 = (float)((double)n2 - affineTransform.getTranslateY());
                f4 += (float)affineTransform.getTranslateX();
                f5 += f3;
                f6 += (float)affineTransform.getTranslateX();
                break;
            }
            default: {
                f3 = (float)((double)f3 + affineTransform.getTranslateX());
                f4 = (float)((double)f4 + affineTransform.getTranslateY());
                f5 = (float)((double)f5 + affineTransform.getTranslateX());
                f6 = (float)((double)f6 + affineTransform.getTranslateY());
            }
        }
        AFPLineDataInfo aFPLineDataInfo = new AFPLineDataInfo();
        aFPLineDataInfo.setColor(borderPaintingInfo.getColor());
        aFPLineDataInfo.setRotation(this.paintingState.getRotation());
        aFPLineDataInfo.setX1(Math.round(f3));
        aFPLineDataInfo.setY1(Math.round(f4));
        float f7 = borderPaintingInfo.isHorizontal() ? f6 - f4 : f5 - f3;
        aFPLineDataInfo.setThickness(Math.round(f7));
        switch (borderPaintingInfo.getStyle()) {
            case 37: {
                int n3 = (int)Math.floor(f7 / 3.0f);
                aFPLineDataInfo.setThickness(n3);
                if (borderPaintingInfo.isHorizontal()) {
                    aFPLineDataInfo.setX2(Math.round(f5));
                    aFPLineDataInfo.setY2(aFPLineDataInfo.getY1());
                    this.dataStream.createLine(aFPLineDataInfo);
                    int n4 = n3 * 2;
                    aFPLineDataInfo = new AFPLineDataInfo(aFPLineDataInfo);
                    aFPLineDataInfo.setY1(aFPLineDataInfo.getY1() + n4);
                    aFPLineDataInfo.setY2(aFPLineDataInfo.getY2() + n4);
                    this.dataStream.createLine(aFPLineDataInfo);
                    break;
                }
                aFPLineDataInfo.setX2(aFPLineDataInfo.getX1());
                aFPLineDataInfo.setY2(Math.round(f6));
                this.dataStream.createLine(aFPLineDataInfo);
                int n5 = n3 * 2;
                aFPLineDataInfo = new AFPLineDataInfo(aFPLineDataInfo);
                aFPLineDataInfo.setX1(aFPLineDataInfo.getX1() + n5);
                aFPLineDataInfo.setX2(aFPLineDataInfo.getX2() + n5);
                this.dataStream.createLine(aFPLineDataInfo);
                break;
            }
            case 31: {
                int n6 = aFPLineDataInfo.getThickness() * 3;
                if (borderPaintingInfo.isHorizontal()) {
                    aFPLineDataInfo.setX2(aFPLineDataInfo.getX1() + n6);
                    aFPLineDataInfo.setY2(aFPLineDataInfo.getY1());
                    int n7 = Math.round(f5);
                    while (aFPLineDataInfo.getX1() + n6 < n7) {
                        this.dataStream.createLine(aFPLineDataInfo);
                        aFPLineDataInfo.setX1(aFPLineDataInfo.getX1() + 2 * n6);
                        aFPLineDataInfo.setX2(aFPLineDataInfo.getX1() + n6);
                    }
                } else {
                    aFPLineDataInfo.setX2(aFPLineDataInfo.getX1());
                    aFPLineDataInfo.setY2(aFPLineDataInfo.getY1() + n6);
                    int n8 = Math.round(f6);
                    while (aFPLineDataInfo.getY1() + n6 < n8) {
                        this.dataStream.createLine(aFPLineDataInfo);
                        aFPLineDataInfo.setY1(aFPLineDataInfo.getY1() + 2 * n6);
                        aFPLineDataInfo.setY2(aFPLineDataInfo.getY1() + n6);
                    }
                }
                break;
            }
            case 36: {
                if (borderPaintingInfo.isHorizontal()) {
                    aFPLineDataInfo.setX2(aFPLineDataInfo.getX1() + aFPLineDataInfo.getThickness());
                    aFPLineDataInfo.setY2(aFPLineDataInfo.getY1());
                    int n9 = Math.round(f5);
                    while (aFPLineDataInfo.getX1() + aFPLineDataInfo.getThickness() < n9) {
                        this.dataStream.createLine(aFPLineDataInfo);
                        aFPLineDataInfo.setX1(aFPLineDataInfo.getX1() + 3 * aFPLineDataInfo.getThickness());
                        aFPLineDataInfo.setX2(aFPLineDataInfo.getX1() + aFPLineDataInfo.getThickness());
                    }
                } else {
                    aFPLineDataInfo.setX2(aFPLineDataInfo.getX1());
                    aFPLineDataInfo.setY2(aFPLineDataInfo.getY1() + aFPLineDataInfo.getThickness());
                    int n10 = Math.round(f6);
                    while (aFPLineDataInfo.getY1() + aFPLineDataInfo.getThickness() < n10) {
                        this.dataStream.createLine(aFPLineDataInfo);
                        aFPLineDataInfo.setY1(aFPLineDataInfo.getY1() + 3 * aFPLineDataInfo.getThickness());
                        aFPLineDataInfo.setY2(aFPLineDataInfo.getY1() + aFPLineDataInfo.getThickness());
                    }
                }
                break;
            }
            case 55: 
            case 119: {
                aFPLineDataInfo.setX2(Math.round(f5));
                float f8 = borderPaintingInfo.getStyle() == 55 ? 0.4f : -0.4f;
                float f9 = (f6 - f4) / 3.0f;
                aFPLineDataInfo.setColor(ColorUtil.lightenColor(borderPaintingInfo.getColor(), -f8));
                aFPLineDataInfo.setThickness(Math.round(f9));
                int n11 = Math.round(f4);
                aFPLineDataInfo.setY1(n11);
                aFPLineDataInfo.setY2(n11);
                this.dataStream.createLine(aFPLineDataInfo);
                aFPLineDataInfo.setColor(borderPaintingInfo.getColor());
                n11 = Math.round(f4 + f9);
                aFPLineDataInfo.setY1(n11);
                aFPLineDataInfo.setY2(n11);
                this.dataStream.createLine(aFPLineDataInfo);
                aFPLineDataInfo.setColor(ColorUtil.lightenColor(borderPaintingInfo.getColor(), f8));
                n11 = Math.round(f4 + f9 + f9);
                aFPLineDataInfo.setY1(n11);
                aFPLineDataInfo.setY2(n11);
                this.dataStream.createLine(aFPLineDataInfo);
                break;
            }
            case 57: {
                break;
            }
            default: {
                if (borderPaintingInfo.isHorizontal()) {
                    aFPLineDataInfo.setX2(Math.round(f5));
                    aFPLineDataInfo.setY2(aFPLineDataInfo.getY1());
                } else {
                    aFPLineDataInfo.setX2(aFPLineDataInfo.getX1());
                    aFPLineDataInfo.setY2(Math.round(f6));
                }
                this.dataStream.createLine(aFPLineDataInfo);
            }
        }
    }
}

