/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.apps;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.io.HexDump;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.afp.parser.MODCAParser;
import org.apache.fop.afp.parser.UnparsedStructuredField;

public class FontPatternExtractor {
    private PrintStream printStream = System.out;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Object object;
            UnparsedStructuredField unparsedStructuredField;
            MODCAParser mODCAParser = new MODCAParser(fileInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((unparsedStructuredField = mODCAParser.readNextStructuredField()) != null) {
                if (unparsedStructuredField.getSfTypeID() != 13889161) continue;
                object = unparsedStructuredField.getData();
                this.println(unparsedStructuredField.toString());
                HexDump.dump((byte[])object, (long)0L, (OutputStream)this.printStream, (int)0);
                byteArrayOutputStream.write((byte[])object);
            }
            object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            DataInputStream dataInputStream = new DataInputStream((InputStream)object);
            long l = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
            this.println("Length: " + l);
            dataInputStream.skip(4L);
            int n = dataInputStream.readUnsignedShort() - 2;
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            String string = new String(byArray, "ISO-8859-1");
            int n2 = this.countUSAsciiCharacters(string);
            String string2 = new String(byArray, "Cp1146");
            int n3 = this.countUSAsciiCharacters(string2);
            this.println("TID: " + string + " " + string2);
            if (n3 > n2) {
                string = string2;
            }
            if (!string.toLowerCase().endsWith(".pfb")) {
                string = string + ".pfb";
            }
            this.println("Output filename: " + string);
            File file3 = new File(file2, string);
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            try {
                IOUtils.copyLarge((InputStream)dataInputStream, (OutputStream)fileOutputStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    private void println(String string) {
        this.printStream.println(string);
    }

    private void println() {
        this.printStream.println();
    }

    private int countUSAsciiCharacters(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) >= '\u0080') continue;
            ++n;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        try {
            FontPatternExtractor fontPatternExtractor = new FontPatternExtractor();
            fontPatternExtractor.println("Font Pattern Extractor");
            fontPatternExtractor.println();
            if (stringArray.length > 0) {
                String string = stringArray[0];
                File file = new File(string);
                File file2 = file.getParentFile();
                if (stringArray.length > 1) {
                    file2 = new File(stringArray[1]);
                    file2.mkdirs();
                }
                fontPatternExtractor.extract(file, file2);
            } else {
                fontPatternExtractor.println("This tool tries to extract the PFB file from an AFP outline font.");
                fontPatternExtractor.println();
                fontPatternExtractor.println("Usage: Java -cp ... " + FontPatternExtractor.class.getName() + " <afp-font-file> [<target-dir>]");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }
}

