/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.apache.fop.afp.fonts.CharacterSetType;

public abstract class CharactersetEncoder {
    private final CharsetEncoder encoder;

    private CharactersetEncoder(String string) {
        this.encoder = Charset.forName(string).newEncoder();
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    final boolean canEncode(char c) {
        return this.encoder.canEncode(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final EncodedChars encode(CharSequence charSequence) throws CharacterCodingException {
        ByteBuffer byteBuffer;
        Object object = this.encoder;
        synchronized (object) {
            byteBuffer = this.encoder.encode(CharBuffer.wrap(charSequence));
        }
        if (byteBuffer.hasArray()) {
            return this.getEncodedChars(byteBuffer.array(), byteBuffer.limit());
        }
        byteBuffer.rewind();
        object = new byte[byteBuffer.remaining()];
        byteBuffer.get((byte[])object);
        return this.getEncodedChars((byte[])object, ((Object)object).length);
    }

    abstract EncodedChars getEncodedChars(byte[] var1, int var2);

    public static EncodedChars encodeSBCS(CharSequence charSequence, String string) throws CharacterCodingException {
        CharactersetEncoder charactersetEncoder = CharactersetEncoder.newInstance(string, CharacterSetType.SINGLE_BYTE);
        return charactersetEncoder.encode(charSequence);
    }

    static CharactersetEncoder newInstance(String string, CharacterSetType characterSetType) {
        switch (characterSetType) {
            case DOUBLE_BYTE_LINE_DATA: {
                return new EbcdicDoubleByteLineDataEncoder(string);
            }
            case DOUBLE_BYTE: {
                return new DefaultEncoder(string, true);
            }
        }
        return new DefaultEncoder(string, false);
    }

    public static class EncodedChars {
        private final byte[] bytes;
        private final int offset;
        private final int length;
        private final boolean isDBCS;

        private EncodedChars(byte[] byArray, int n, int n2, boolean bl) {
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                throw new IllegalArgumentException();
            }
            this.bytes = byArray;
            this.offset = n;
            this.length = n2;
            this.isDBCS = bl;
        }

        private EncodedChars(byte[] byArray, boolean bl) {
            this(byArray, 0, byArray.length, bl);
        }

        public void writeTo(OutputStream outputStream, int n, int n2) throws IOException {
            if (n < 0 || n2 < 0 || n + n2 > this.bytes.length) {
                throw new IllegalArgumentException();
            }
            outputStream.write(this.bytes, this.offset + n, n2);
        }

        public int getLength() {
            return this.length;
        }

        public boolean isDBCS() {
            return this.isDBCS;
        }

        public byte[] getBytes() {
            byte[] byArray = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
            return byArray;
        }
    }

    private static final class DefaultEncoder
    extends CharactersetEncoder {
        private final boolean isDBCS;

        private DefaultEncoder(String string, boolean bl) {
            super(string);
            this.isDBCS = bl;
        }

        EncodedChars getEncodedChars(byte[] byArray, int n) {
            return new EncodedChars(byArray, this.isDBCS);
        }
    }

    private static final class EbcdicDoubleByteLineDataEncoder
    extends CharactersetEncoder {
        private EbcdicDoubleByteLineDataEncoder(String string) {
            super(string);
        }

        EncodedChars getEncodedChars(byte[] byArray, int n) {
            if (byArray[0] == 14 && byArray[n - 1] == 15) {
                return new EncodedChars(byArray, 1, n - 2, true);
            }
            return new EncodedChars(byArray, true);
        }
    }
}

