/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.goca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.goca.AbstractGraphicsDrawingOrderContainer;
import org.apache.fop.afp.util.BinaryUtils;

public final class GraphicsChainedSegment
extends AbstractGraphicsDrawingOrderContainer {
    protected static final int MAX_DATA_LEN = 8192;
    private byte[] predecessorNameBytes;
    private boolean appended;
    private boolean prologPresent;
    private static final byte APPEND_NEW_SEGMENT = 0;
    private static final byte APPEND_TO_EXISING = 6;
    private static final byte PROLOG = 16;
    private static final int NAME_LENGTH = 4;

    public GraphicsChainedSegment(String string) {
        this(string, null, false, false);
    }

    public GraphicsChainedSegment(String string, byte[] byArray, boolean bl, boolean bl2) {
        super(string);
        if (byArray != null) {
            this.predecessorNameBytes = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.predecessorNameBytes, 0, byArray.length);
        }
        this.appended = bl;
        this.prologPresent = bl2;
    }

    public int getDataLength() {
        return 14 + super.getDataLength();
    }

    protected int getNameLength() {
        return 4;
    }

    byte getOrderCode() {
        return 112;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[14];
        byArray[0] = this.getOrderCode();
        byArray[1] = 12;
        byte[] byArray2 = this.getNameBytes();
        System.arraycopy(byArray2, 0, byArray, 2, 4);
        byArray[6] = 0;
        byArray[7] = (byte)(byArray[7] | (this.appended ? 6 : 0));
        if (this.prologPresent) {
            byArray[7] = (byte)(byArray[7] | 0x10);
        }
        int n = super.getDataLength();
        byte[] byArray3 = BinaryUtils.convert(n, 2);
        byArray[8] = byArray3[0];
        byArray[9] = byArray3[1];
        if (this.predecessorNameBytes != null) {
            System.arraycopy(this.predecessorNameBytes, 0, byArray, 10, 4);
        }
        outputStream.write(byArray);
        this.writeObjects(this.objects, outputStream);
    }

    public String toString() {
        return "GraphicsChainedSegment(name=" + super.getName() + ", len: " + this.getDataLength() + ")";
    }
}

