/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.ioca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.ioca.IDEStructureParameter;
import org.apache.fop.afp.ioca.ImageSizeParameter;
import org.apache.fop.afp.modca.AbstractStructuredObject;

public class ImageContent
extends AbstractStructuredObject {
    public static final byte COMPID_G3_MH = -128;
    public static final byte COMPID_G3_MR = -127;
    public static final byte COMPID_G3_MMR = -126;
    public static final byte COMPID_JPEG = -125;
    private ImageSizeParameter imageSizeParameter = null;
    private IDEStructureParameter ideStructureParameter = null;
    private byte encoding = (byte)3;
    private byte ideSize = 1;
    private byte compression = (byte)-64;
    private byte[] data;
    private static final int MAX_DATA_LEN = 65535;

    public void setImageSizeParameter(ImageSizeParameter imageSizeParameter) {
        this.imageSizeParameter = imageSizeParameter;
    }

    public void setIDEStructureParameter(IDEStructureParameter iDEStructureParameter) {
        this.ideStructureParameter = iDEStructureParameter;
    }

    public IDEStructureParameter getIDEStructureParameter() {
        return this.ideStructureParameter;
    }

    public IDEStructureParameter needIDEStructureParameter() {
        if (this.ideStructureParameter == null) {
            this.setIDEStructureParameter(new IDEStructureParameter());
        }
        return this.getIDEStructureParameter();
    }

    public void setImageEncoding(byte by) {
        this.encoding = by;
    }

    public void setImageCompression(byte by) {
        this.compression = by;
    }

    public void setImageIDESize(byte by) {
        this.ideSize = by;
    }

    @Deprecated
    public void setImageIDEColorModel(byte by) {
        this.needIDEStructureParameter().setColorModel(by);
    }

    @Deprecated
    public void setSubtractive(boolean bl) {
        this.needIDEStructureParameter().setSubtractive(bl);
    }

    public void setImageData(byte[] byArray) {
        this.data = byArray;
    }

    protected void writeContent(OutputStream outputStream) throws IOException {
        boolean bl;
        if (this.imageSizeParameter != null) {
            this.imageSizeParameter.writeToStream(outputStream);
        }
        outputStream.write(this.getImageEncodingParameter());
        outputStream.write(this.getImageIDESizeParameter());
        if (this.getIDEStructureParameter() != null) {
            this.getIDEStructureParameter().writeToStream(outputStream);
        }
        boolean bl2 = bl = this.ideSize == 1;
        if (!bl) {
            outputStream.write(this.getExternalAlgorithmParameter());
        }
        byte[] byArray = new byte[]{-2, -110, 0, 0};
        if (this.data != null) {
            ImageContent.writeChunksToStream(this.data, byArray, 2, 65535, outputStream);
        }
    }

    protected void writeStart(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[]{-111, 1, -1};
        outputStream.write(byArray);
    }

    protected void writeEnd(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[]{-109, 0};
        outputStream.write(byArray);
    }

    private byte[] getImageEncodingParameter() {
        byte[] byArray = new byte[]{-107, 2, this.encoding, (byte)(this.encoding == -125 ? 254 : 1)};
        return byArray;
    }

    private byte[] getExternalAlgorithmParameter() {
        if (this.encoding == -125 && this.compression != 0) {
            byte[] byArray = new byte[]{-97, 0, 16, 0, -125, 0, 0, 0, this.compression, 0, 0, 0};
            byArray[1] = (byte)(byArray.length - 2);
            return byArray;
        }
        return new byte[0];
    }

    private byte[] getImageIDESizeParameter() {
        if (this.ideSize != 1) {
            byte[] byArray = new byte[]{-106, 1, this.ideSize};
            return byArray;
        }
        return new byte[0];
    }
}

