/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.fop.afp.modca.AbstractStructuredObject;
import org.apache.fop.afp.modca.Registry;
import org.apache.fop.afp.modca.triplets.AbstractTriplet;
import org.apache.fop.afp.modca.triplets.CommentTriplet;
import org.apache.fop.afp.modca.triplets.FullyQualifiedNameTriplet;
import org.apache.fop.afp.modca.triplets.ObjectClassificationTriplet;
import org.apache.fop.afp.modca.triplets.Triplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTripletStructuredObject
extends AbstractStructuredObject {
    protected List<AbstractTriplet> triplets = new ArrayList<AbstractTriplet>();

    protected int getTripletDataLength() {
        int n = 0;
        for (Triplet triplet : this.triplets) {
            n += triplet.getDataLength();
        }
        return n;
    }

    public boolean hasTriplets() {
        return this.triplets.size() > 0;
    }

    protected void writeTriplets(OutputStream outputStream) throws IOException {
        if (this.hasTriplets()) {
            this.writeObjects(this.triplets, outputStream);
            this.triplets = null;
        }
    }

    private AbstractTriplet getTriplet(byte by) {
        for (AbstractTriplet abstractTriplet : this.triplets) {
            if (abstractTriplet.getId() != by) continue;
            return abstractTriplet;
        }
        return null;
    }

    public boolean hasTriplet(byte by) {
        return this.getTriplet(by) != null;
    }

    protected void addTriplet(AbstractTriplet abstractTriplet) {
        this.triplets.add(abstractTriplet);
    }

    public void addTriplets(Collection<AbstractTriplet> collection) {
        if (collection != null) {
            this.triplets.addAll(collection);
        }
    }

    protected List<AbstractTriplet> getTriplets() {
        return this.triplets;
    }

    public void setFullyQualifiedName(byte by, byte by2, String string) {
        this.addTriplet(new FullyQualifiedNameTriplet(by, by2, string));
    }

    public String getFullyQualifiedName() {
        FullyQualifiedNameTriplet fullyQualifiedNameTriplet = (FullyQualifiedNameTriplet)this.getTriplet((byte)2);
        if (fullyQualifiedNameTriplet != null) {
            return fullyQualifiedNameTriplet.getFullyQualifiedName();
        }
        LOG.warn((Object)(this + " has no fully qualified name"));
        return null;
    }

    public void setObjectClassification(byte by, Registry.ObjectType objectType, boolean bl, boolean bl2, boolean bl3) {
        this.addTriplet(new ObjectClassificationTriplet(by, objectType, bl, bl2, bl3));
    }

    public void setComment(String string) {
        this.addTriplet(new CommentTriplet(101, string));
    }
}

