/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.bidi;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.bidi.BidiClass;
import org.apache.fop.complexscripts.bidi.BidiConstants;
import org.apache.fop.complexscripts.bidi.BidiResolver;
import org.apache.fop.traits.Direction;
import org.apache.fop.util.CharUtilities;

public final class UnicodeBidiAlgorithm
implements BidiConstants {
    private static final Log log = LogFactory.getLog(BidiResolver.class);

    private UnicodeBidiAlgorithm() {
    }

    public static int[] resolveLevels(CharSequence charSequence, Direction direction) {
        int[] nArray = new int[charSequence.length()];
        if (UnicodeBidiAlgorithm.convertToScalar(charSequence, nArray) || direction == Direction.RL) {
            return UnicodeBidiAlgorithm.resolveLevels(nArray, direction == Direction.RL ? 1 : 0, new int[nArray.length]);
        }
        return null;
    }

    public static int[] resolveLevels(int[] nArray, int n, int[] nArray2) {
        return UnicodeBidiAlgorithm.resolveLevels(nArray, UnicodeBidiAlgorithm.getClasses(nArray), n, nArray2, false);
    }

    public static int[] resolveLevels(int[] nArray, int[] nArray2, int n, int[] nArray3, boolean bl) {
        int[] nArray4 = nArray2;
        int[] nArray5 = UnicodeBidiAlgorithm.copySequence(nArray4);
        int[] nArray6 = new int[nArray3.length];
        UnicodeBidiAlgorithm.resolveExplicit(nArray5, n, nArray6);
        UnicodeBidiAlgorithm.resolveRuns(nArray5, n, nArray6, UnicodeBidiAlgorithm.levelsFromEmbeddings(nArray6, nArray3));
        if (bl) {
            UnicodeBidiAlgorithm.resolveSeparators(nArray4, nArray5, n, nArray3);
        }
        UnicodeBidiAlgorithm.dump("RL: CC(" + (nArray != null ? nArray.length : -1) + ")", nArray, nArray2, n, nArray3);
        return nArray3;
    }

    private static int[] copySequence(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        return nArray2;
    }

    private static void resolveExplicit(int[] nArray, int n, int[] nArray2) {
        int[] nArray3 = new int[61];
        int n2 = 0;
        int n3 = n;
        for (int n4 : nArray) {
            int n5;
            switch (n4) {
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    int n6 = n4 == 6 || n4 == 7 ? (n3 & 0xFFFFFF7F) + 1 | 1 : (n3 & 0xFFFFFF7F) + 2 & 0xFFFFFFFE;
                    if (n6 < 62) {
                        nArray3[n2++] = n3;
                        n3 = n4 == 3 || n4 == 7 ? n6 | 0x80 : n6 & 0xFFFFFF7F;
                    }
                    n5 = n3;
                    break;
                }
                case 8: {
                    n5 = n3;
                    if (n2 <= 0) break;
                    n3 = nArray3[--n2];
                    break;
                }
                case 16: {
                    n5 = n3 = n;
                    n2 = 0;
                    break;
                }
                default: {
                    n5 = n3;
                }
            }
            switch (n4) {
                case 15: {
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    nArray[var6_6] = 15;
                    break;
                }
                default: {
                    if ((n5 & 0x80) == 0) break;
                    nArray[var6_6] = UnicodeBidiAlgorithm.directionOfLevel(n5);
                }
            }
            nArray2[var6_6] = n5;
        }
    }

    private static int directionOfLevel(int n) {
        return (n & 1) != 0 ? 4 : 1;
    }

    private static int levelOfEmbedding(int n) {
        return n & 0xFFFFFF7F;
    }

    private static int[] levelsFromEmbeddings(int[] nArray, int[] nArray2) {
        assert (nArray != null);
        assert (nArray2 != null);
        assert (nArray2.length == nArray.length);
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            nArray2[i] = UnicodeBidiAlgorithm.levelOfEmbedding(nArray[i]);
        }
        return nArray2;
    }

    private static void resolveRuns(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        if (nArray3.length != nArray.length) {
            throw new IllegalArgumentException("levels sequence length must match classes sequence length");
        }
        if (nArray3.length != nArray2.length) {
            throw new IllegalArgumentException("levels sequence length must match embeddings sequence length");
        }
        int n2 = 0;
        int n3 = nArray2.length;
        int n4 = n;
        while (n2 < n3) {
            int n5;
            int n6 = n5 = n2;
            int n7 = UnicodeBidiAlgorithm.findNextNonRetainedFormattingLevel(nArray, nArray2, n5, n4);
            while (n6 < n3) {
                if (nArray3[n6] != n7) {
                    if (!UnicodeBidiAlgorithm.startsWithRetainedFormattingRun(nArray, nArray2, n6)) break;
                    n6 += UnicodeBidiAlgorithm.getLevelRunLength(nArray2, n6);
                    continue;
                }
                ++n6;
            }
            n4 = UnicodeBidiAlgorithm.resolveRun(nArray, n, nArray2, nArray3, n5, n6, n7, n4);
            n2 = n6;
        }
    }

    private static int findNextNonRetainedFormattingLevel(int[] nArray, int[] nArray2, int n, int n2) {
        int n3;
        int n4 = nArray.length;
        for (n3 = n; n3 < n4 && UnicodeBidiAlgorithm.startsWithRetainedFormattingRun(nArray, nArray2, n3); n3 += UnicodeBidiAlgorithm.getLevelRunLength(nArray2, n3)) {
        }
        if (n3 < n4) {
            return UnicodeBidiAlgorithm.levelOfEmbedding(nArray2[n3]);
        }
        return n2;
    }

    private static int getLevelRunLength(int[] nArray, int n) {
        assert (n < nArray.length);
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = UnicodeBidiAlgorithm.levelOfEmbedding(nArray[n]);
        for (int i = n; i < n3 && UnicodeBidiAlgorithm.levelOfEmbedding(nArray[i]) == n4; ++i) {
            ++n2;
        }
        return n2;
    }

    private static boolean startsWithRetainedFormattingRun(int[] nArray, int[] nArray2, int n) {
        int n2 = UnicodeBidiAlgorithm.getLevelRunLength(nArray2, n);
        if (n2 > 0) {
            int n3 = UnicodeBidiAlgorithm.getRetainedFormattingRunLength(nArray, n);
            return n3 >= n2;
        }
        return false;
    }

    private static int getRetainedFormattingRunLength(int[] nArray, int n) {
        assert (n < nArray.length);
        int n2 = 0;
        int n3 = nArray.length;
        for (int i = n; i < n3 && nArray[i] == 15; ++i) {
            ++n2;
        }
        return n2;
    }

    private static int resolveRun(int[] nArray, int n, int[] nArray2, int[] nArray3, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = UnicodeBidiAlgorithm.directionOfLevel(UnicodeBidiAlgorithm.max(n5, n4));
        int n8 = -1;
        if (n3 == nArray.length) {
            n8 = UnicodeBidiAlgorithm.max(n4, n);
        } else {
            for (n6 = n3; n6 < nArray.length; ++n6) {
                if (nArray[n6] == 15) continue;
                n8 = UnicodeBidiAlgorithm.max(n4, nArray3[n6]);
                break;
            }
            if (n8 < 0) {
                n8 = UnicodeBidiAlgorithm.max(n4, n);
            }
        }
        n6 = UnicodeBidiAlgorithm.directionOfLevel(n8);
        if (log.isDebugEnabled()) {
            log.debug((Object)("BR[" + UnicodeBidiAlgorithm.padLeft(n2, 3) + "," + UnicodeBidiAlgorithm.padLeft(n3, 3) + "] :" + UnicodeBidiAlgorithm.padLeft(n4, 2) + ": SOR(" + UnicodeBidiAlgorithm.getClassName(n7) + "), EOR(" + UnicodeBidiAlgorithm.getClassName(n6) + ")"));
        }
        UnicodeBidiAlgorithm.resolveWeak(nArray, n, nArray2, nArray3, n2, n3, n4, n7, n6);
        UnicodeBidiAlgorithm.resolveNeutrals(nArray, n, nArray2, nArray3, n2, n3, n4, n7, n6);
        UnicodeBidiAlgorithm.resolveImplicit(nArray, n, nArray2, nArray3, n2, n3, n4, n7, n6);
        return UnicodeBidiAlgorithm.isRetainedFormatting(nArray, n2, n3) ? n5 : n4;
    }

    private static void resolveWeak(int[] nArray, int n, int[] nArray2, int[] nArray3, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = n3;
        int n12 = n5;
        for (n10 = n2; n10 < n11; ++n10) {
            n9 = nArray[n10];
            if (n9 == 14) {
                nArray[n10] = n12;
                continue;
            }
            if (n9 == 15) continue;
            n12 = n9;
        }
        n11 = n3;
        n12 = n5;
        for (n10 = n2; n10 < n11; ++n10) {
            n9 = nArray[n10];
            if (n9 == 9) {
                if (n12 != 5) continue;
                nArray[n10] = 12;
                continue;
            }
            if (!UnicodeBidiAlgorithm.isStrong(n9)) continue;
            n12 = n9;
        }
        n11 = n3;
        for (n10 = n2; n10 < n11; ++n10) {
            n12 = nArray[n10];
            if (n12 != 5) continue;
            nArray[n10] = 4;
        }
        n11 = n3;
        n12 = n5;
        for (n10 = n2; n10 < n11; ++n10) {
            n9 = nArray[n10];
            if (n9 == 10) {
                n8 = n6;
                for (n7 = n10 + 1; n7 < n11; ++n7) {
                    n9 = nArray[n7];
                    if (n9 == 15) continue;
                    n8 = n9;
                    break;
                }
                if (n12 == 9 && n8 == 9) {
                    nArray[n10] = 9;
                }
            } else if (n9 == 13) {
                n8 = n6;
                for (n7 = n10 + 1; n7 < n11; ++n7) {
                    n9 = nArray[n7];
                    if (n9 == 15) continue;
                    n8 = n9;
                    break;
                }
                if (n12 == 9 && n8 == 9) {
                    nArray[n10] = 9;
                } else if (n12 == 12 && n8 == 12) {
                    nArray[n10] = 12;
                }
            }
            if (n9 == 15) continue;
            n12 = n9;
        }
        n11 = n3;
        n12 = n5;
        for (n10 = n2; n10 < n11; ++n10) {
            n9 = nArray[n10];
            if (n9 == 11) {
                n8 = n6;
                for (n7 = n10 + 1; n7 < n11; ++n7) {
                    n9 = nArray[n7];
                    if (n9 == 15 || n9 == 11) continue;
                    n8 = n9;
                    break;
                }
                if (n12 != 9 && n8 != 9) continue;
                nArray[n10] = 9;
                continue;
            }
            if (n9 == 15 || n9 == 11) continue;
            n12 = n9;
        }
        n11 = n3;
        for (n10 = n2; n10 < n11; ++n10) {
            n12 = nArray[n10];
            if (n12 != 11 && n12 != 10 && n12 != 13) continue;
            nArray[n10] = 19;
            UnicodeBidiAlgorithm.resolveAdjacentBoundaryNeutrals(nArray, n2, n3, n10, 19);
        }
        n11 = n3;
        n12 = n5;
        for (n10 = n2; n10 < n11; ++n10) {
            n9 = nArray[n10];
            if (n9 == 9) {
                if (n12 != 1) continue;
                nArray[n10] = 1;
                continue;
            }
            if (n9 != 1 && n9 != 4) continue;
            n12 = n9;
        }
    }

    private static void resolveNeutrals(int[] nArray, int n, int[] nArray2, int[] nArray3, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9 = n3;
        int n10 = n5;
        for (n8 = n2; n8 < n9; ++n8) {
            n7 = nArray[n8];
            if (UnicodeBidiAlgorithm.isNeutral(n7)) {
                int n11 = n6;
                for (int i = n8 + 1; i < n9; ++i) {
                    n7 = nArray[i];
                    if (n7 == 1 || n7 == 4) {
                        n11 = n7;
                        break;
                    }
                    if (n7 == 12 || n7 == 9) {
                        n11 = 4;
                        break;
                    }
                    if (!UnicodeBidiAlgorithm.isNeutral(n7) && !UnicodeBidiAlgorithm.isRetainedFormatting(n7)) break;
                }
                if (n10 != n11) continue;
                nArray[n8] = n10;
                UnicodeBidiAlgorithm.resolveAdjacentBoundaryNeutrals(nArray, n2, n3, n8, n10);
                continue;
            }
            if (n7 == 1 || n7 == 4) {
                n10 = n7;
                continue;
            }
            if (n7 != 12 && n7 != 9) continue;
            n10 = 4;
        }
        n9 = n3;
        for (n8 = n2; n8 < n9; ++n8) {
            n10 = nArray[n8];
            if (!UnicodeBidiAlgorithm.isNeutral(n10)) continue;
            nArray[n8] = n7 = UnicodeBidiAlgorithm.directionOfLevel(UnicodeBidiAlgorithm.levelOfEmbedding(nArray2[n8]));
            UnicodeBidiAlgorithm.resolveAdjacentBoundaryNeutrals(nArray, n2, n3, n8, n7);
        }
    }

    private static void resolveAdjacentBoundaryNeutrals(int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n3 < n || n3 >= n2) {
            throw new IllegalArgumentException();
        }
        for (n6 = n3 - 1; n6 >= n && (n5 = nArray[n6]) == 15; --n6) {
            nArray[n6] = n4;
        }
        for (n6 = n3 + 1; n6 < n2 && (n5 = nArray[n6]) == 15; ++n6) {
            nArray[n6] = n4;
        }
    }

    private static void resolveImplicit(int[] nArray, int n, int[] nArray2, int[] nArray3, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n3;
        for (int i = n2; i < n7; ++i) {
            int n8 = nArray[i];
            int n9 = nArray3[i];
            int n10 = 0;
            if ((n9 & 1) == 0) {
                if (n8 == 4) {
                    n10 = 1;
                } else if (n8 == 12) {
                    n10 = 2;
                } else if (n8 == 9) {
                    n10 = 2;
                }
            } else if (n8 == 1) {
                n10 = 1;
            } else if (n8 == 9) {
                n10 = 1;
            } else if (n8 == 12) {
                n10 = 1;
            }
            nArray3[i] = n9 + n10;
        }
    }

    private static void resolveSeparators(int[] nArray, int[] nArray2, int n, int[] nArray3) {
        int n2;
        int n3;
        int n4 = nArray.length;
        block0: for (n3 = 0; n3 < n4; ++n3) {
            n2 = nArray[n3];
            if (n2 != 17 && n2 != 16) continue;
            nArray3[n3] = n;
            for (int i = n3 - 1; i >= 0; --i) {
                int n5 = nArray[i];
                if (UnicodeBidiAlgorithm.isRetainedFormatting(n5)) continue;
                if (n5 != 18) continue block0;
                nArray3[i] = n;
            }
        }
        for (n3 = nArray.length; n3 > 0; --n3) {
            n4 = n3 - 1;
            n2 = nArray[n4];
            if (UnicodeBidiAlgorithm.isRetainedFormatting(n2)) continue;
            if (n2 != 18) break;
            nArray3[n4] = n;
        }
        n4 = nArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = nArray[n3];
            if (!UnicodeBidiAlgorithm.isRetainedFormatting(n2)) continue;
            nArray3[n3] = n3 == 0 ? n : nArray3[n3 - 1];
        }
    }

    private static boolean isStrong(int n) {
        switch (n) {
            case 1: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private static boolean isNeutral(int n) {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    private static boolean isRetainedFormatting(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    private static boolean isRetainedFormatting(int[] nArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (UnicodeBidiAlgorithm.isRetainedFormatting(nArray[i])) continue;
            return false;
        }
        return true;
    }

    private static int max(int n, int n2) {
        if (n > n2) {
            return n;
        }
        return n2;
    }

    private static int[] getClasses(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            int n3 = n2 >= 0 ? BidiClass.getBidiClass(nArray[i]) : 20;
            nArray2[i] = n3;
        }
        return nArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean convertToScalar(CharSequence charSequence, int[] nArray) throws IllegalArgumentException {
        boolean bl = false;
        if (nArray.length != charSequence.length()) {
            throw new IllegalArgumentException("characters array length must match input sequence length");
        }
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int n3;
            int n4 = charSequence.charAt(n);
            if (n4 < 55296) {
                n3 = n4;
            } else if (n4 < 56320) {
                int n5 = n4;
                if (n + 1 >= n2) throw new IllegalArgumentException("truncated surrogate pair");
                char c = charSequence.charAt(n + 1);
                if (c < '\udc00' || c > '\udfff') throw new IllegalArgumentException("isolated high surrogate");
                n3 = UnicodeBidiAlgorithm.convertToScalar(n5, c);
            } else {
                if (n4 < 57344) {
                    throw new IllegalArgumentException("isolated low surrogate");
                }
                n3 = n4;
            }
            if (!bl && UnicodeBidiAlgorithm.triggersBidi(n3)) {
                bl = true;
            }
            if ((n3 & 0xFF0000) == 0) {
                nArray[n++] = n3;
                continue;
            }
            nArray[n++] = n3;
            nArray[n++] = -1;
        }
        return bl;
    }

    private static int convertToScalar(int n, int n2) {
        if (n < 55296 || n > 56319) {
            throw new IllegalArgumentException("bad high surrogate");
        }
        if (n2 < 56320 || n2 > 57343) {
            throw new IllegalArgumentException("bad low surrogate");
        }
        return ((n & 0x3FF) << 10 | n2 & 0x3FF) + 65536;
    }

    private static boolean triggersBidi(int n) {
        switch (BidiClass.getBidiClass(n)) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private static void dump(String string, int[] nArray, int[] nArray2, int n, int[] nArray3) {
        log.debug((Object)string);
        log.debug((Object)("BD: default level(" + n + ")"));
        StringBuffer stringBuffer = new StringBuffer();
        if (nArray != null) {
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = nArray[i];
                stringBuffer.setLength(0);
                if (n3 > 32 && n3 < 127) {
                    stringBuffer.append((char)n3);
                } else {
                    stringBuffer.append(CharUtilities.charToNCRef(n3));
                }
                for (int j = stringBuffer.length(); j < 12; ++j) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(": " + UnicodeBidiAlgorithm.padRight(UnicodeBidiAlgorithm.getClassName(nArray2[i]), 4) + " " + nArray3[i]);
                log.debug((Object)stringBuffer);
            }
        } else {
            int n4 = nArray2.length;
            for (int i = 0; i < n4; ++i) {
                stringBuffer.setLength(0);
                for (int j = stringBuffer.length(); j < 12; ++j) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(": " + UnicodeBidiAlgorithm.padRight(UnicodeBidiAlgorithm.getClassName(nArray2[i]), 4) + " " + nArray3[i]);
                log.debug((Object)stringBuffer);
            }
        }
    }

    private static String getClassName(int n) {
        switch (n) {
            case 1: {
                return "L";
            }
            case 2: {
                return "LRE";
            }
            case 3: {
                return "LRO";
            }
            case 4: {
                return "R";
            }
            case 5: {
                return "AL";
            }
            case 6: {
                return "RLE";
            }
            case 7: {
                return "RLO";
            }
            case 8: {
                return "PDF";
            }
            case 9: {
                return "EN";
            }
            case 10: {
                return "ES";
            }
            case 11: {
                return "ET";
            }
            case 12: {
                return "AN";
            }
            case 13: {
                return "CS";
            }
            case 14: {
                return "NSM";
            }
            case 15: {
                return "BN";
            }
            case 16: {
                return "B";
            }
            case 17: {
                return "S";
            }
            case 18: {
                return "WS";
            }
            case 19: {
                return "ON";
            }
            case 20: {
                return "SUR";
            }
        }
        return "?";
    }

    private static String padLeft(int n, int n2) {
        return UnicodeBidiAlgorithm.padLeft(Integer.toString(n), n2);
    }

    private static String padLeft(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static String padRight(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = stringBuffer.length(); i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

