/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.complexscripts.fonts.GlyphProcessingState;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionSubtable;
import org.apache.fop.complexscripts.fonts.GlyphTable;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.ScriptContextTester;

public class GlyphSubstitutionState
extends GlyphProcessingState {
    private int[] alternatesIndex;
    private IntBuffer ogb;
    private List oal;
    private boolean predications;

    public GlyphSubstitutionState(GlyphSequence glyphSequence, String string, String string2, String string3, ScriptContextTester scriptContextTester) {
        super(glyphSequence, string, string2, string3, scriptContextTester);
        this.ogb = IntBuffer.allocate(glyphSequence.getGlyphCount());
        this.oal = new ArrayList(glyphSequence.getGlyphCount());
        this.predications = glyphSequence.getPredications();
    }

    public GlyphSubstitutionState(GlyphSubstitutionState glyphSubstitutionState) {
        super(glyphSubstitutionState);
        this.ogb = IntBuffer.allocate(this.indexLast);
        this.oal = new ArrayList(this.indexLast);
    }

    public void setAlternates(int[] nArray) {
        this.alternatesIndex = nArray;
    }

    public int getAlternatesIndex(int n) {
        if (this.alternatesIndex == null) {
            return 0;
        }
        if (n < 0 || n > this.alternatesIndex.length) {
            return 0;
        }
        return this.alternatesIndex[n];
    }

    public void putGlyph(int n, GlyphSequence.CharAssociation charAssociation, Object object) {
        if (!this.ogb.hasRemaining()) {
            this.ogb = GlyphSubstitutionState.growBuffer(this.ogb);
        }
        this.ogb.put(n);
        if (this.predications && object != null) {
            charAssociation.setPredication(this.feature, object);
        }
        this.oal.add(charAssociation);
    }

    public void putGlyphs(int[] nArray, GlyphSequence.CharAssociation[] charAssociationArray, Object object) {
        assert (nArray != null);
        assert (charAssociationArray != null);
        assert (charAssociationArray.length >= nArray.length);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this.putGlyph(nArray[i], charAssociationArray[i], object);
        }
    }

    public GlyphSequence getOutput() {
        int n = this.ogb.position();
        if (n > 0) {
            this.ogb.limit(n);
            this.ogb.rewind();
            return new GlyphSequence(this.igs.getCharacters(), this.ogb, this.oal);
        }
        return this.igs;
    }

    public boolean apply(GlyphSubstitutionSubtable glyphSubstitutionSubtable) {
        assert (glyphSubstitutionSubtable != null);
        this.updateSubtableState(glyphSubstitutionSubtable);
        boolean bl = glyphSubstitutionSubtable.substitute(this);
        this.resetSubtableState();
        return bl;
    }

    public boolean apply(GlyphTable.RuleLookup[] ruleLookupArray, int n) {
        int n2 = this.indexLast - (this.index + n);
        int n3 = 0;
        if (ruleLookupArray != null && ruleLookupArray.length > 0) {
            for (GlyphTable.RuleLookup ruleLookup : ruleLookupArray) {
                GlyphSubstitutionState glyphSubstitutionState;
                GlyphSequence glyphSequence;
                GlyphTable.LookupTable lookupTable;
                if (ruleLookup == null || (lookupTable = ruleLookup.getLookup()) == null || !this.replaceInput(0, -1, glyphSequence = lookupTable.substitute(glyphSubstitutionState = new GlyphSubstitutionState(this), ruleLookup.getSequenceIndex()))) continue;
                n3 = glyphSequence.getGlyphCount() - n2;
            }
            this.putGlyphs(this.getGlyphs(0, n3, false, null, null, null), this.getAssociations(0, n3, false, null, null, null), null);
            this.consume(n3);
            return true;
        }
        return false;
    }

    public void applyDefault() {
        super.applyDefault();
        int n = this.getGlyph();
        if (n != 65535) {
            this.putGlyph(n, this.getAssociation(), null);
        }
    }

    private static IntBuffer growBuffer(IntBuffer intBuffer) {
        int n = intBuffer.capacity();
        int n2 = n * 2;
        IntBuffer intBuffer2 = IntBuffer.allocate(n2);
        intBuffer.rewind();
        return intBuffer2.put(intBuffer);
    }
}

