/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.events;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.events.Event;
import org.apache.fop.events.EventFormatter;
import org.apache.fop.events.EventListener;
import org.apache.fop.events.model.EventSeverity;

public class LoggingEventListener
implements EventListener {
    private static Log defaultLog = LogFactory.getLog(LoggingEventListener.class);
    private Log log;
    private boolean skipFatal;
    private final Set<String> loggedMessages = new HashSet<String>();

    public LoggingEventListener() {
        this(defaultLog);
    }

    public LoggingEventListener(Log log) {
        this(log, true);
    }

    public LoggingEventListener(Log log, boolean bl) {
        this.log = log;
        this.skipFatal = bl;
    }

    public Log getLog() {
        return this.log;
    }

    public void processEvent(Event event) {
        String string = EventFormatter.format(event);
        EventSeverity eventSeverity = event.getSeverity();
        if (eventSeverity == EventSeverity.INFO) {
            this.log.info((Object)string);
        } else if (eventSeverity == EventSeverity.WARN) {
            String string2 = event.getEventGroupID();
            if (string2.equals("org.apache.fop.fonts.FontEventProducer")) {
                if (!this.loggedMessages.contains(string)) {
                    this.loggedMessages.add(string);
                    this.log.warn((Object)string);
                }
            } else {
                this.log.warn((Object)string);
            }
        } else if (eventSeverity == EventSeverity.ERROR) {
            if (event.getParam("e") != null) {
                this.log.error((Object)string, (Throwable)event.getParam("e"));
            } else {
                this.log.error((Object)string);
            }
        } else if (eventSeverity == EventSeverity.FATAL) {
            if (!this.skipFatal) {
                if (event.getParam("e") != null) {
                    this.log.fatal((Object)string, (Throwable)event.getParam("e"));
                } else {
                    this.log.fatal((Object)string);
                }
            }
        } else assert (false);
    }
}

