/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.extensions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.UnknownXMLObj;
import org.apache.fop.fo.extensions.ExternalDocument;
import org.apache.fop.fo.extensions.destination.Destination;
import org.apache.xmlgraphics.util.QName;

public class ExtensionElementMapping
extends ElementMapping {
    public static final String URI = "http://xmlgraphics.apache.org/fop/extensions";
    public static final String STANDARD_PREFIX = "fox";
    private static final Set<String> PROPERTY_ATTRIBUTES = new HashSet<String>();

    public ExtensionElementMapping() {
        this.namespaceURI = URI;
    }

    protected void initialize() {
        if (this.foObjs == null) {
            this.foObjs = new HashMap();
            this.foObjs.put("outline", new UnknownXMLObj.Maker(URI));
            this.foObjs.put("label", new UnknownXMLObj.Maker(URI));
            this.foObjs.put("destination", new DestinationMaker());
            this.foObjs.put("external-document", new ExternalDocumentMaker());
        }
    }

    public String getStandardPrefix() {
        return STANDARD_PREFIX;
    }

    public boolean isAttributeProperty(QName qName) {
        if (!URI.equals(qName.getNamespaceURI())) {
            throw new IllegalArgumentException("The namespace URIs don't match");
        }
        return PROPERTY_ATTRIBUTES.contains(qName.getLocalName());
    }

    static {
        PROPERTY_ATTRIBUTES.add("block-progression-unit");
        PROPERTY_ATTRIBUTES.add("widow-content-limit");
        PROPERTY_ATTRIBUTES.add("orphan-content-limit");
        PROPERTY_ATTRIBUTES.add("internal-destination");
        PROPERTY_ATTRIBUTES.add("disable-column-balancing");
        PROPERTY_ATTRIBUTES.add("alt-text");
    }

    static class ExternalDocumentMaker
    extends ElementMapping.Maker {
        ExternalDocumentMaker() {
        }

        public FONode make(FONode fONode) {
            return new ExternalDocument(fONode);
        }
    }

    static class DestinationMaker
    extends ElementMapping.Maker {
        DestinationMaker() {
        }

        public FONode make(FONode fONode) {
            return new Destination(fONode);
        }
    }
}

