/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.extensions.svg;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.URL;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.parser.UnitProcessor;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.extensions.svg.SVGDOMContentHandlerFactory;
import org.apache.fop.fo.extensions.svg.SVGObj;
import org.apache.fop.util.ContentHandlerFactory;
import org.w3c.dom.Element;

public class SVGElement
extends SVGObj {
    public SVGElement(FONode fONode) {
        super(fONode);
    }

    public ContentHandlerFactory getContentHandlerFactory() {
        return new SVGDOMContentHandlerFactory();
    }

    public Point2D getDimension(final Point2D point2D) {
        Object object;
        Element element = this.element;
        try {
            URL uRL = new URL(this.getUserAgent().getBaseURL() == null ? new File("").toURI().toURL().toExternalForm() : this.getUserAgent().getBaseURL());
            if (uRL != null) {
                object = (SVGOMDocument)this.doc;
                object.setURLObject(uRL);
            }
        }
        catch (Exception exception) {
            log.error((Object)"Could not set base URL for svg", (Throwable)exception);
        }
        final float f = this.getUserAgent().getSourcePixelUnitToMillimeter();
        object = new SVGContext(){

            public float getPixelToMM() {
                return f;
            }

            public float getPixelUnitToMillimeter() {
                return f;
            }

            public Rectangle2D getBBox() {
                return new Rectangle2D.Double(0.0, 0.0, point2D.getX(), point2D.getY());
            }

            public AffineTransform getScreenTransform() {
                throw new UnsupportedOperationException("NYI");
            }

            public void setScreenTransform(AffineTransform affineTransform) {
                throw new UnsupportedOperationException("NYI");
            }

            public AffineTransform getCTM() {
                return new AffineTransform();
            }

            public AffineTransform getGlobalTransform() {
                return new AffineTransform();
            }

            public float getViewportWidth() {
                return (float)point2D.getX();
            }

            public float getViewportHeight() {
                return (float)point2D.getY();
            }

            public float getFontSize() {
                return 12.0f;
            }

            public void deselectAll() {
            }
        };
        SVGOMElement sVGOMElement = (SVGOMElement)element;
        sVGOMElement.setSVGContext((SVGContext)object);
        sVGOMElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/svg");
        int n = 12;
        Point2D point2D2 = SVGElement.getSize(n, element, this.getUserAgent().getSourcePixelUnitToMillimeter());
        sVGOMElement.setSVGContext(null);
        return point2D2;
    }

    public static Point2D getSize(int n, Element element, float f) {
        PDFUnitContext pDFUnitContext = new PDFUnitContext(n, element, f);
        String string = element.getAttributeNS(null, "width");
        if (string.length() == 0) {
            string = "100%";
        }
        float f2 = UnitProcessor.svgHorizontalLengthToUserSpace((String)string, (String)"width", (UnitProcessor.Context)pDFUnitContext);
        string = element.getAttributeNS(null, "height");
        if (string.length() == 0) {
            string = "100%";
        }
        float f3 = UnitProcessor.svgVerticalLengthToUserSpace((String)string, (String)"height", (UnitProcessor.Context)pDFUnitContext);
        return new Point2D.Float(f2, f3);
    }

    public static class PDFUnitContext
    implements UnitProcessor.Context {
        private Element e;
        private int fontSize;
        private float pixeltoMM;

        public PDFUnitContext(int n, Element element, float f) {
            this.e = element;
            this.fontSize = n;
            this.pixeltoMM = f;
        }

        public Element getElement() {
            return this.e;
        }

        public UnitProcessor.Context getParentElementContext() {
            return null;
        }

        public float getPixelToMM() {
            return this.pixeltoMM;
        }

        public float getPixelUnitToMillimeter() {
            return this.pixeltoMM;
        }

        public float getFontSize() {
            return this.fontSize;
        }

        public float getXHeight() {
            return 0.5f;
        }

        public float getViewportWidth() {
            return 100.0f;
        }

        public float getViewportHeight() {
            return 100.0f;
        }
    }
}

