/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.table.TableEventProducer;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Locator;

public class TableCell
extends TableFObj
implements CommonAccessibilityHolder {
    private CommonAccessibility commonAccessibility;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private LengthRangeProperty blockProgressionDimension;
    private int columnNumber;
    private int displayAlign;
    private int emptyCells;
    private int endsRow;
    private int numberColumnsSpanned;
    private int numberRowsSpanned;
    private int startsRow;
    private Length width;
    private boolean blockItemFound = false;

    public TableCell(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.commonAccessibility = CommonAccessibility.getInstance(propertyList);
        this.commonBorderPaddingBackground = propertyList.getBorderPaddingBackgroundProps();
        this.blockProgressionDimension = propertyList.get(17).getLengthRange();
        this.displayAlign = propertyList.get(87).getEnum();
        this.emptyCells = propertyList.get(90).getEnum();
        this.startsRow = propertyList.get(235).getEnum();
        if (this.startsRow() && this.getParent().getNameId() != 79) {
            ((TablePart)this.getParent()).signalNewRow();
        }
        this.endsRow = propertyList.get(92).getEnum();
        this.columnNumber = propertyList.get(76).getNumeric().getValue();
        this.numberColumnsSpanned = propertyList.get(165).getNumeric().getValue();
        this.numberRowsSpanned = propertyList.get(166).getNumeric().getValue();
        this.width = propertyList.get(264).getLength();
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startCell(this);
    }

    protected void endOfNode() throws FOPException {
        super.endOfNode();
        this.getFOEventHandler().endCell(this);
    }

    public void finalizeNode() throws FOPException {
        if (!this.blockItemFound) {
            this.missingChildElementError("marker* (%block;)+", true);
        }
        if ((this.startsRow() || this.endsRow()) && this.getParent().getNameId() == 79) {
            TableEventProducer tableEventProducer = TableEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            tableEventProducer.startEndRowUnderTableRowWarning(this, this.getLocator());
        }
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if (string2.equals("marker")) {
                if (this.blockItemFound) {
                    this.nodesOutOfOrderError(locator, "fo:marker", "(%block;)");
                }
            } else if (!this.isBlockItem(string, string2)) {
                this.invalidChildError(locator, string, string2);
            } else {
                this.blockItemFound = true;
            }
        }
    }

    public boolean generatesReferenceAreas() {
        return true;
    }

    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public boolean showEmptyCells() {
        return this.emptyCells == 130;
    }

    public int getNumberColumnsSpanned() {
        return Math.max(this.numberColumnsSpanned, 1);
    }

    public int getNumberRowsSpanned() {
        return Math.max(this.numberRowsSpanned, 1);
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public int getDisplayAlign() {
        return this.displayAlign;
    }

    public Length getWidth() {
        return this.width;
    }

    public boolean startsRow() {
        return this.startsRow == 149;
    }

    public boolean endsRow() {
        return this.endsRow == 149;
    }

    public String getLocalName() {
        return "table-cell";
    }

    public final int getNameId() {
        return 75;
    }
}

