/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.ValidationPercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.flow.table.BorderSpecification;
import org.apache.fop.fo.flow.table.ColumnNumberManager;
import org.apache.fop.fo.flow.table.ColumnNumberManagerHolder;
import org.apache.fop.fo.flow.table.ConditionalBorder;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableEventProducer;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.EnumNumber;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.fop.layoutmgr.table.CollapsingBorderModel;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public abstract class TableFObj
extends FObj {
    private Numeric borderAfterPrecedence;
    private Numeric borderBeforePrecedence;
    private Numeric borderEndPrecedence;
    private Numeric borderStartPrecedence;
    ConditionalBorder borderBefore;
    ConditionalBorder borderAfter;
    BorderSpecification borderStart;
    BorderSpecification borderEnd;
    CollapsingBorderModel collapsingBorderModel;

    public TableFObj(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.borderAfterPrecedence = propertyList.get(20).getNumeric();
        this.borderBeforePrecedence = propertyList.get(24).getNumeric();
        this.borderEndPrecedence = propertyList.get(34).getNumeric();
        this.borderStartPrecedence = propertyList.get(48).getNumeric();
        if (this.getNameId() != 71 && this.getNameId() != 75 && this.getCommonBorderPaddingBackground().hasPadding(ValidationPercentBaseContext.getPseudoContext())) {
            TableEventProducer tableEventProducer = TableEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            tableEventProducer.paddingNotApplicable(this, this.getName(), this.getLocator());
        }
    }

    public Numeric getBorderPrecedence(int n) {
        switch (n) {
            case 0: {
                return this.borderBeforePrecedence;
            }
            case 1: {
                return this.borderAfterPrecedence;
            }
            case 2: {
                return this.borderStartPrecedence;
            }
            case 3: {
                return this.borderEndPrecedence;
            }
        }
        return null;
    }

    public Table getTable() {
        return ((TableFObj)this.parent).getTable();
    }

    public abstract CommonBorderPaddingBackground getCommonBorderPaddingBackground();

    public void processNode(String string, Locator locator, Attributes attributes, PropertyList propertyList) throws FOPException {
        super.processNode(string, locator, attributes, propertyList);
        Table table = this.getTable();
        if (!this.inMarker() && !table.isSeparateBorderModel()) {
            this.collapsingBorderModel = CollapsingBorderModel.getBorderModelFor(table.getBorderCollapse());
            this.setCollapsedBorders();
        }
    }

    protected void setCollapsedBorders() {
        this.createBorder(2);
        this.createBorder(3);
        this.createBorder(0);
        this.createBorder(1);
    }

    private void createBorder(int n) {
        BorderSpecification borderSpecification = new BorderSpecification(this.getCommonBorderPaddingBackground().getBorderInfo(n), this.getNameId());
        switch (n) {
            case 0: {
                this.borderBefore = new ConditionalBorder(borderSpecification, this.collapsingBorderModel);
                break;
            }
            case 1: {
                this.borderAfter = new ConditionalBorder(borderSpecification, this.collapsingBorderModel);
                break;
            }
            case 2: {
                this.borderStart = borderSpecification;
                break;
            }
            case 3: {
                this.borderEnd = borderSpecification;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public static class ColumnNumberPropertyMaker
    extends PropertyMaker {
        public ColumnNumberPropertyMaker(int n) {
            super(n);
        }

        public Property make(PropertyList propertyList) throws PropertyException {
            FObj fObj = propertyList.getFObj();
            return NumberProperty.getInstance(((ColumnNumberManagerHolder)((Object)fObj.getParent())).getColumnNumberManager().getCurrentColumnNumber());
        }

        public Property make(PropertyList propertyList, String string, FObj fObj) throws PropertyException {
            Property property = super.make(propertyList, string, fObj);
            int n = property.getNumeric().getValue();
            int n2 = propertyList.get(165).getNumeric().getValue();
            int n3 = propertyList.getFObj().getNameId();
            if (n3 == 76 || n3 == 75) {
                ColumnNumberManagerHolder columnNumberManagerHolder = (ColumnNumberManagerHolder)((Object)propertyList.getParentFObj());
                ColumnNumberManager columnNumberManager = columnNumberManagerHolder.getColumnNumberManager();
                int n4 = n - 1 + n2;
                for (int i = n; i <= n4; ++i) {
                    if (!columnNumberManager.isColumnNumberUsed(i)) continue;
                    TableEventProducer tableEventProducer = TableEventProducer.Provider.get(fObj.getUserAgent().getEventBroadcaster());
                    tableEventProducer.cellOverlap(this, propertyList.getFObj().getName(), i, propertyList.getFObj().getLocator());
                }
            }
            return property;
        }

        public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
            if (property instanceof EnumProperty) {
                return EnumNumber.getInstance(property);
            }
            Number number = property.getNumber();
            if (number != null) {
                int n = Math.round(number.floatValue());
                int n2 = propertyList.getFObj().getNameId();
                if (n <= 0) {
                    Object object;
                    if (n2 == 75 || n2 == 76) {
                        object = (ColumnNumberManagerHolder)((Object)propertyList.getParentFObj());
                        ColumnNumberManager columnNumberManager = object.getColumnNumberManager();
                        n = columnNumberManager.getCurrentColumnNumber();
                    } else {
                        n = 1;
                    }
                    object = TableEventProducer.Provider.get(fObj.getUserAgent().getEventBroadcaster());
                    object.forceNextColumnNumber(this, propertyList.getFObj().getName(), number, n, propertyList.getFObj().getLocator());
                }
                return NumberProperty.getInstance(n);
            }
            return this.convertPropertyDatatype(property, propertyList, fObj);
        }
    }
}

