/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CondLengthProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.util.CompareUtil;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;

public class CommonBorderPaddingBackground {
    private static final PropertyCache<CommonBorderPaddingBackground> CACHE = new PropertyCache();
    private int hash = -1;
    public final int backgroundAttachment;
    public final Color backgroundColor;
    public final String backgroundImage;
    public final int backgroundRepeat;
    public final Length backgroundPositionHorizontal;
    public final Length backgroundPositionVertical;
    private ImageInfo backgroundImageInfo;
    public static final int BEFORE = 0;
    public static final int AFTER = 1;
    public static final int START = 2;
    public static final int END = 3;
    private static final BorderInfo DEFAULT_BORDER_INFO = BorderInfo.getInstance(95, new ConditionalNullLength(), null);
    private BorderInfo[] borderInfo = new BorderInfo[4];
    private CondLengthProperty[] padding = new CondLengthProperty[4];

    public static BorderInfo getDefaultBorderInfo() {
        return DEFAULT_BORDER_INFO;
    }

    CommonBorderPaddingBackground(PropertyList propertyList) throws PropertyException {
        this.backgroundAttachment = propertyList.get(8).getEnum();
        Color color = propertyList.get(9).getColor(propertyList.getFObj().getUserAgent());
        this.backgroundColor = color.getAlpha() == 0 ? null : color;
        String string = propertyList.get(10).getString();
        if (string == null || "none".equals(string)) {
            this.backgroundImage = "";
            this.backgroundRepeat = -1;
            this.backgroundPositionHorizontal = null;
            this.backgroundPositionVertical = null;
        } else {
            this.backgroundImage = string;
            this.backgroundRepeat = propertyList.get(14).getEnum();
            this.backgroundPositionHorizontal = propertyList.get(12).getLength();
            this.backgroundPositionVertical = propertyList.get(13).getLength();
        }
        this.initBorderInfo(propertyList, 0, 23, 25, 26, 172);
        this.initBorderInfo(propertyList, 1, 19, 21, 22, 171);
        this.initBorderInfo(propertyList, 2, 47, 49, 50, 177);
        this.initBorderInfo(propertyList, 3, 33, 35, 36, 174);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommonBorderPaddingBackground getInstance(PropertyList propertyList) throws PropertyException {
        CommonBorderPaddingBackground commonBorderPaddingBackground = new CommonBorderPaddingBackground(propertyList);
        CommonBorderPaddingBackground commonBorderPaddingBackground2 = null;
        if (!(commonBorderPaddingBackground.padding[0] != null && !commonBorderPaddingBackground.padding[0].getLength().isAbsolute() || commonBorderPaddingBackground.padding[1] != null && !commonBorderPaddingBackground.padding[1].getLength().isAbsolute() || commonBorderPaddingBackground.padding[2] != null && !commonBorderPaddingBackground.padding[2].getLength().isAbsolute() || commonBorderPaddingBackground.padding[3] != null && !commonBorderPaddingBackground.padding[3].getLength().isAbsolute() || commonBorderPaddingBackground.backgroundPositionHorizontal != null && !commonBorderPaddingBackground.backgroundPositionHorizontal.isAbsolute() || commonBorderPaddingBackground.backgroundPositionVertical != null && !commonBorderPaddingBackground.backgroundPositionVertical.isAbsolute())) {
            commonBorderPaddingBackground2 = CACHE.fetch(commonBorderPaddingBackground);
        }
        String string = commonBorderPaddingBackground.backgroundImage.intern();
        synchronized (string) {
            if (!(commonBorderPaddingBackground2 != null && commonBorderPaddingBackground2 != commonBorderPaddingBackground || "".equals(commonBorderPaddingBackground.backgroundImage))) {
                String string2 = URISpecification.getURL(commonBorderPaddingBackground.backgroundImage);
                FObj fObj = propertyList.getFObj();
                FOUserAgent fOUserAgent = propertyList.getFObj().getUserAgent();
                ImageManager imageManager = fOUserAgent.getFactory().getImageManager();
                ImageSessionContext imageSessionContext = fOUserAgent.getImageSessionContext();
                try {
                    ImageInfo imageInfo;
                    commonBorderPaddingBackground.backgroundImageInfo = imageInfo = imageManager.getImageInfo(string2, imageSessionContext);
                }
                catch (ImageException imageException) {
                    ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(fObj.getUserAgent().getEventBroadcaster());
                    resourceEventProducer.imageError(fObj, string2, imageException, fObj.getLocator());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(fObj.getUserAgent().getEventBroadcaster());
                    resourceEventProducer.imageNotFound(fObj, string2, fileNotFoundException, fObj.getLocator());
                }
                catch (IOException iOException) {
                    ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(fObj.getUserAgent().getEventBroadcaster());
                    resourceEventProducer.imageIOError(fObj, string2, iOException, fObj.getLocator());
                }
            }
        }
        return commonBorderPaddingBackground2 != null ? commonBorderPaddingBackground2 : commonBorderPaddingBackground;
    }

    private void initBorderInfo(PropertyList propertyList, int n, int n2, int n3, int n4, int n5) throws PropertyException {
        this.padding[n] = propertyList.get(n5).getCondLength();
        int n6 = propertyList.get(n3).getEnum();
        if (n6 != 95) {
            FOUserAgent fOUserAgent = propertyList.getFObj().getUserAgent();
            this.setBorderInfo(BorderInfo.getInstance(n6, propertyList.get(n4).getCondLength(), propertyList.get(n2).getColor(fOUserAgent)), n);
        }
    }

    private void setBorderInfo(BorderInfo borderInfo, int n) {
        this.borderInfo[n] = borderInfo;
    }

    public BorderInfo getBorderInfo(int n) {
        if (this.borderInfo[n] == null) {
            return CommonBorderPaddingBackground.getDefaultBorderInfo();
        }
        return this.borderInfo[n];
    }

    public ImageInfo getImageInfo() {
        return this.backgroundImageInfo;
    }

    public int getBorderStartWidth(boolean bl) {
        return this.getBorderWidth(2, bl);
    }

    public int getBorderEndWidth(boolean bl) {
        return this.getBorderWidth(3, bl);
    }

    public int getBorderBeforeWidth(boolean bl) {
        return this.getBorderWidth(0, bl);
    }

    public int getBorderAfterWidth(boolean bl) {
        return this.getBorderWidth(1, bl);
    }

    public int getPaddingStart(boolean bl, PercentBaseContext percentBaseContext) {
        return this.getPadding(2, bl, percentBaseContext);
    }

    public int getPaddingEnd(boolean bl, PercentBaseContext percentBaseContext) {
        return this.getPadding(3, bl, percentBaseContext);
    }

    public int getPaddingBefore(boolean bl, PercentBaseContext percentBaseContext) {
        return this.getPadding(0, bl, percentBaseContext);
    }

    public int getPaddingAfter(boolean bl, PercentBaseContext percentBaseContext) {
        return this.getPadding(1, bl, percentBaseContext);
    }

    public int getBorderWidth(int n, boolean bl) {
        if (this.borderInfo[n] == null || this.borderInfo[n].mStyle == 95 || this.borderInfo[n].mStyle == 57 || bl && this.borderInfo[n].mWidth.isDiscard()) {
            return 0;
        }
        return this.borderInfo[n].mWidth.getLengthValue();
    }

    public Color getBorderColor(int n) {
        if (this.borderInfo[n] != null) {
            return this.borderInfo[n].getColor();
        }
        return null;
    }

    public int getBorderStyle(int n) {
        if (this.borderInfo[n] != null) {
            return this.borderInfo[n].mStyle;
        }
        return 95;
    }

    public int getPadding(int n, boolean bl, PercentBaseContext percentBaseContext) {
        if (this.padding[n] == null || bl && this.padding[n].isDiscard()) {
            return 0;
        }
        return this.padding[n].getLengthValue(percentBaseContext);
    }

    public CondLengthProperty getPaddingLengthProperty(int n) {
        return this.padding[n];
    }

    public int getIPPaddingAndBorder(boolean bl, PercentBaseContext percentBaseContext) {
        return this.getPaddingStart(bl, percentBaseContext) + this.getPaddingEnd(bl, percentBaseContext) + this.getBorderStartWidth(bl) + this.getBorderEndWidth(bl);
    }

    public int getBPPaddingAndBorder(boolean bl, PercentBaseContext percentBaseContext) {
        return this.getPaddingBefore(bl, percentBaseContext) + this.getPaddingAfter(bl, percentBaseContext) + this.getBorderBeforeWidth(bl) + this.getBorderAfterWidth(bl);
    }

    public String toString() {
        return "CommonBordersAndPadding (Before, After, Start, End):\nBorders: (" + this.getBorderBeforeWidth(false) + ", " + this.getBorderAfterWidth(false) + ", " + this.getBorderStartWidth(false) + ", " + this.getBorderEndWidth(false) + ")\n" + "Border Colors: (" + this.getBorderColor(0) + ", " + this.getBorderColor(1) + ", " + this.getBorderColor(2) + ", " + this.getBorderColor(3) + ")\n" + "Padding: (" + this.getPaddingBefore(false, null) + ", " + this.getPaddingAfter(false, null) + ", " + this.getPaddingStart(false, null) + ", " + this.getPaddingEnd(false, null) + ")\n";
    }

    public boolean hasBackground() {
        return this.backgroundColor != null || this.getImageInfo() != null;
    }

    public boolean hasBorder() {
        return this.getBorderBeforeWidth(false) + this.getBorderAfterWidth(false) + this.getBorderStartWidth(false) + this.getBorderEndWidth(false) > 0;
    }

    public boolean hasPadding(PercentBaseContext percentBaseContext) {
        return this.getPaddingBefore(false, percentBaseContext) + this.getPaddingAfter(false, percentBaseContext) + this.getPaddingStart(false, percentBaseContext) + this.getPaddingEnd(false, percentBaseContext) > 0;
    }

    public boolean hasBorderInfo() {
        return this.borderInfo[0] != null || this.borderInfo[1] != null || this.borderInfo[2] != null || this.borderInfo[3] != null;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getBackgroundAttachment() {
        return this.backgroundAttachment;
    }

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public int getBackgroundRepeat() {
        return this.backgroundRepeat;
    }

    public Length getBackgroundPositionHorizontal() {
        return this.backgroundPositionHorizontal;
    }

    public Length getBackgroundPositionVertical() {
        return this.backgroundPositionVertical;
    }

    public ImageInfo getBackgroundImageInfo() {
        return this.backgroundImageInfo;
    }

    public BorderInfo[] getBorderInfo() {
        return this.borderInfo;
    }

    public CondLengthProperty[] getPadding() {
        return this.padding;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CommonBorderPaddingBackground)) {
            return false;
        }
        CommonBorderPaddingBackground commonBorderPaddingBackground = (CommonBorderPaddingBackground)object;
        return this.backgroundAttachment == commonBorderPaddingBackground.backgroundAttachment && CompareUtil.equal(this.backgroundColor, commonBorderPaddingBackground.backgroundColor) && CompareUtil.equal(this.backgroundImage, commonBorderPaddingBackground.backgroundImage) && CompareUtil.equal(this.backgroundPositionHorizontal, this.backgroundPositionHorizontal) && CompareUtil.equal(this.backgroundPositionVertical, commonBorderPaddingBackground.backgroundPositionVertical) && this.backgroundRepeat == commonBorderPaddingBackground.backgroundRepeat && Arrays.equals(this.borderInfo, commonBorderPaddingBackground.borderInfo) && Arrays.equals(this.padding, commonBorderPaddingBackground.padding);
    }

    public int hashCode() {
        if (this.hash == -1) {
            int n = this.getHashCode(this.backgroundColor, this.backgroundImage, this.backgroundPositionHorizontal, this.backgroundPositionVertical, this.borderInfo[0], this.borderInfo[1], this.borderInfo[2], this.borderInfo[3], this.padding[0], this.padding[1], this.padding[2], this.padding[3]);
            n = 37 * n + this.backgroundAttachment;
            this.hash = n = 37 * n + this.backgroundRepeat;
        }
        return this.hash;
    }

    private int getHashCode(Object ... objectArray) {
        int n = 17;
        for (Object object : objectArray) {
            n = 37 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    private static class ConditionalNullLength
    extends CondLengthProperty {
        private ConditionalNullLength() {
        }

        public Property getComponent(int n) {
            throw new UnsupportedOperationException();
        }

        public Property getConditionality() {
            throw new UnsupportedOperationException();
        }

        public Length getLength() {
            throw new UnsupportedOperationException();
        }

        public Property getLengthComponent() {
            throw new UnsupportedOperationException();
        }

        public int getLengthValue() {
            return 0;
        }

        public int getLengthValue(PercentBaseContext percentBaseContext) {
            return 0;
        }

        public boolean isDiscard() {
            return true;
        }

        public void setComponent(int n, Property property, boolean bl) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "CondLength[0mpt, discard]";
        }
    }

    public static final class BorderInfo {
        private static final PropertyCache<BorderInfo> CACHE = new PropertyCache();
        private int mStyle;
        private Color mColor;
        private CondLengthProperty mWidth;
        private int hash = -1;

        private BorderInfo(int n, CondLengthProperty condLengthProperty, Color color) {
            this.mStyle = n;
            this.mWidth = condLengthProperty;
            this.mColor = color;
        }

        public static BorderInfo getInstance(int n, CondLengthProperty condLengthProperty, Color color) {
            return CACHE.fetch(new BorderInfo(n, condLengthProperty, color));
        }

        public int getStyle() {
            return this.mStyle;
        }

        public Color getColor() {
            return this.mColor;
        }

        public CondLengthProperty getWidth() {
            return this.mWidth;
        }

        public int getRetainedWidth() {
            if (this.mStyle == 95 || this.mStyle == 57) {
                return 0;
            }
            return this.mWidth.getLengthValue();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("BorderInfo");
            stringBuffer.append(" {");
            stringBuffer.append(this.mStyle);
            stringBuffer.append(", ");
            stringBuffer.append(this.mColor);
            stringBuffer.append(", ");
            stringBuffer.append(this.mWidth);
            stringBuffer.append("}");
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof BorderInfo)) {
                return false;
            }
            BorderInfo borderInfo = (BorderInfo)object;
            return CompareUtil.equal(this.mColor, borderInfo.mColor) && this.mStyle == borderInfo.mStyle && CompareUtil.equal(this.mWidth, borderInfo.mWidth);
        }

        public int hashCode() {
            if (this.hash == -1) {
                int n = 17;
                n = 37 * n + (this.mColor == null ? 0 : this.mColor.hashCode());
                n = 37 * n + this.mStyle;
                this.hash = n = 37 * n + (this.mWidth == null ? 0 : this.mWidth.hashCode());
            }
            return this.hash;
        }
    }
}

