/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.CompoundDatatype;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CompoundPropertyMaker;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.util.CompareUtil;

public class CondLengthProperty
extends Property
implements CompoundDatatype {
    private static final PropertyCache<CondLengthProperty> CACHE = new PropertyCache();
    private Property length;
    private EnumProperty conditionality;
    private boolean isCached = false;
    private int hash = -1;

    public void setComponent(int n, Property property, boolean bl) {
        if (this.isCached) {
            throw new IllegalStateException("CondLengthProperty.setComponent() called on a cached value!");
        }
        if (n == 2048) {
            this.length = property;
        } else if (n == 1024) {
            this.conditionality = (EnumProperty)property;
        }
    }

    public Property getComponent(int n) {
        if (n == 2048) {
            return this.length;
        }
        if (n == 1024) {
            return this.conditionality;
        }
        return null;
    }

    public Property getConditionality() {
        return this.conditionality;
    }

    public Property getLengthComponent() {
        return this.length;
    }

    public boolean isDiscard() {
        return this.conditionality.getEnum() == 32;
    }

    public int getLengthValue() {
        return this.length.getLength().getValue();
    }

    public int getLengthValue(PercentBaseContext percentBaseContext) {
        return this.length.getLength().getValue(percentBaseContext);
    }

    public String toString() {
        return "CondLength[" + this.length.getObject().toString() + ", " + (this.isDiscard() ? this.conditionality.toString().toLowerCase() : this.conditionality.toString()) + "]";
    }

    public CondLengthProperty getCondLength() {
        if (this.length.getLength().isAbsolute()) {
            CondLengthProperty condLengthProperty = CACHE.fetch(this);
            if (condLengthProperty == this) {
                this.isCached = true;
            }
            return condLengthProperty;
        }
        return this;
    }

    public Length getLength() {
        return this.length.getLength();
    }

    public Object getObject() {
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CondLengthProperty) {
            CondLengthProperty condLengthProperty = (CondLengthProperty)object;
            return CompareUtil.equal(this.length, condLengthProperty.length) && CompareUtil.equal(this.conditionality, condLengthProperty.conditionality);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == -1) {
            int n = 17;
            n = 37 * n + (this.length == null ? 0 : this.length.hashCode());
            this.hash = n = 37 * n + (this.conditionality == null ? 0 : this.conditionality.hashCode());
        }
        return this.hash;
    }

    public static class Maker
    extends CompoundPropertyMaker {
        public Maker(int n) {
            super(n);
        }

        public Property makeNewProperty() {
            return new CondLengthProperty();
        }

        public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
            if (property instanceof KeepProperty) {
                return property;
            }
            return super.convertProperty(property, propertyList, fObj);
        }
    }
}

