/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.EnumLength;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;

public abstract class LengthProperty
extends Property
implements Length,
Numeric {
    public int getDimension() {
        return 1;
    }

    public Numeric getNumeric() {
        return this;
    }

    public Length getLength() {
        return this;
    }

    public Object getObject() {
        return this;
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int n) {
            super(n);
        }

        public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
            if (property instanceof EnumProperty) {
                return new EnumLength(property);
            }
            if (property instanceof LengthProperty) {
                return property;
            }
            if (property instanceof NumberProperty) {
                float f = propertyList.getFObj().getUserAgent().getSourceResolution();
                return FixedLength.getInstance(property.getNumeric().getNumericValue(), "px", 72.0f / f);
            }
            Length length = property.getLength();
            if (length != null) {
                return (Property)((Object)length);
            }
            return this.convertPropertyDatatype(property, propertyList, fObj);
        }
    }
}

