/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.properties.LengthProperty;
import org.apache.fop.util.CompareUtil;

public class TableColLength
extends LengthProperty {
    private double tcolUnits;
    private FObj column;

    public TableColLength(double d, FObj fObj) {
        this.tcolUnits = d;
        this.column = fObj;
    }

    public double getTableUnits() {
        return this.tcolUnits;
    }

    public boolean isAbsolute() {
        return false;
    }

    public double getNumericValue() {
        throw new UnsupportedOperationException("Must call getNumericValue with PercentBaseContext");
    }

    public double getNumericValue(PercentBaseContext percentBaseContext) {
        return this.tcolUnits * (double)percentBaseContext.getBaseLength(11, this.column);
    }

    public int getValue() {
        throw new UnsupportedOperationException("Must call getValue with PercentBaseContext");
    }

    public int getValue(PercentBaseContext percentBaseContext) {
        return (int)(this.tcolUnits * (double)percentBaseContext.getBaseLength(11, this.column));
    }

    public String toString() {
        return Double.toString(this.tcolUnits) + " table-column-units";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + CompareUtil.getHashCode(this.column);
        n = 31 * n + CompareUtil.getHashCode(this.tcolUnits);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TableColLength)) {
            return false;
        }
        TableColLength tableColLength = (TableColLength)object;
        return CompareUtil.equal(this.column, tableColLength.column) && CompareUtil.equal(this.tcolUnits, tableColLength.tcolUnits);
    }
}

