/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

public final class CMapSegment {
    private final int unicodeStart;
    private final int unicodeEnd;
    private final int glyphStartIndex;

    public CMapSegment(int n, int n2, int n3) {
        this.unicodeStart = n;
        this.unicodeEnd = n2;
        this.glyphStartIndex = n3;
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.unicodeStart;
        n = 31 * n + this.unicodeEnd;
        n = 31 * n + this.glyphStartIndex;
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof CMapSegment) {
            CMapSegment cMapSegment = (CMapSegment)object;
            return cMapSegment.unicodeStart == this.unicodeStart && cMapSegment.unicodeEnd == this.unicodeEnd && cMapSegment.glyphStartIndex == this.glyphStartIndex;
        }
        return false;
    }

    public int getUnicodeStart() {
        return this.unicodeStart;
    }

    public int getUnicodeEnd() {
        return this.unicodeEnd;
    }

    public int getGlyphStartIndex() {
        return this.glyphStartIndex;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("CMapSegment: ");
        stringBuilder.append("{ UC[");
        stringBuilder.append(this.unicodeStart);
        stringBuilder.append(',');
        stringBuilder.append(this.unicodeEnd);
        stringBuilder.append("]: GC[");
        stringBuilder.append(this.glyphStartIndex);
        stringBuilder.append(',');
        stringBuilder.append(this.glyphStartIndex + (this.unicodeEnd - this.unicodeStart));
        stringBuilder.append("] }");
        return stringBuilder.toString();
    }
}

