/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

public class FontType {
    public static final FontType OTHER = new FontType("Other", 0);
    public static final FontType TYPE0 = new FontType("Type0", 1);
    public static final FontType TYPE1 = new FontType("Type1", 2);
    public static final FontType MMTYPE1 = new FontType("MMType1", 3);
    public static final FontType TYPE3 = new FontType("Type3", 4);
    public static final FontType TRUETYPE = new FontType("TrueType", 5);
    private final String name;
    private final int value;

    protected FontType(String string, int n) {
        this.name = string;
        this.value = n;
    }

    public static FontType byName(String string) {
        if (string.equalsIgnoreCase(OTHER.getName())) {
            return OTHER;
        }
        if (string.equalsIgnoreCase(TYPE0.getName())) {
            return TYPE0;
        }
        if (string.equalsIgnoreCase(TYPE1.getName())) {
            return TYPE1;
        }
        if (string.equalsIgnoreCase(MMTYPE1.getName())) {
            return MMTYPE1;
        }
        if (string.equalsIgnoreCase(TYPE3.getName())) {
            return TYPE3;
        }
        if (string.equalsIgnoreCase(TRUETYPE.getName())) {
            return TRUETYPE;
        }
        throw new IllegalArgumentException("Invalid font type: " + string);
    }

    public static FontType byValue(int n) {
        if (n == OTHER.getValue()) {
            return OTHER;
        }
        if (n == TYPE0.getValue()) {
            return TYPE0;
        }
        if (n == TYPE1.getValue()) {
            return TYPE1;
        }
        if (n == MMTYPE1.getValue()) {
            return MMTYPE1;
        }
        if (n == TYPE3.getValue()) {
            return TYPE3;
        }
        if (n == TRUETYPE.getValue()) {
            return TRUETYPE;
        }
        throw new IllegalArgumentException("Invalid font type: " + n);
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.name;
    }
}

