/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphPositioningTable;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionTable;
import org.apache.fop.complexscripts.fonts.Positionable;
import org.apache.fop.complexscripts.fonts.Substitutable;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.fonts.CIDSubset;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.util.CharUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiByteFont
extends CIDFont
implements Substitutable,
Positionable {
    private static final Log log = LogFactory.getLog(MultiByteFont.class);
    private String ttcName = null;
    private String encoding = "Identity-H";
    private int defaultWidth = 0;
    private CIDFontType cidType = CIDFontType.CIDTYPE2;
    private CIDSubset subset = new CIDSubset();
    private GlyphDefinitionTable gdef;
    private GlyphSubstitutionTable gsub;
    private GlyphPositioningTable gpos;
    private int numMapped;
    private int numUnmapped;
    private int nextPrivateUse = 57344;
    private int firstPrivate;
    private int lastPrivate;
    private int firstUnmapped;
    private int lastUnmapped;

    public MultiByteFont() {
        this.subset.setupFirstGlyph();
        this.setFontType(FontType.TYPE0);
    }

    @Override
    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    @Override
    public String getRegistry() {
        return "Adobe";
    }

    @Override
    public String getOrdering() {
        return "UCS";
    }

    @Override
    public int getSupplement() {
        return 0;
    }

    @Override
    public CIDFontType getCIDType() {
        return this.cidType;
    }

    public void setCIDType(CIDFontType cIDFontType) {
        this.cidType = cIDFontType;
    }

    @Override
    public String getEmbedFontName() {
        if (this.isEmbeddable()) {
            return FontUtil.stripWhiteSpace(super.getFontName());
        }
        return super.getFontName();
    }

    @Override
    public boolean isEmbeddable() {
        return this.getEmbedFileName() != null || this.getEmbedResourceName() != null;
    }

    @Override
    public boolean isSubsetEmbedded() {
        return true;
    }

    @Override
    public CIDSubset getCIDSubset() {
        return this.subset;
    }

    @Override
    public String getEncodingName() {
        return this.encoding;
    }

    @Override
    public int getWidth(int n, int n2) {
        if (this.isEmbeddable()) {
            int n3 = this.subset.getGlyphIndexForSubsetIndex(n);
            return n2 * this.width[n3];
        }
        return n2 * this.width[n];
    }

    @Override
    public int[] getWidths() {
        int[] nArray = new int[this.width.length];
        System.arraycopy(this.width, 0, nArray, 0, this.width.length);
        return nArray;
    }

    private int findGlyphIndex(int n) {
        int n2 = n;
        int n3 = 0;
        for (int i = 0; i < this.cmap.length && n3 == 0; ++i) {
            if (this.cmap[i].getUnicodeStart() > n2 || this.cmap[i].getUnicodeEnd() < n2) continue;
            n3 = this.cmap[i].getGlyphStartIndex() + n2 - this.cmap[i].getUnicodeStart();
        }
        return n3;
    }

    private synchronized void addPrivateUseMapping(int n, int n2) {
        assert (this.findGlyphIndex(n) == 0);
        CMapSegment[] cMapSegmentArray = this.cmap;
        int n3 = cMapSegmentArray.length;
        CMapSegment[] cMapSegmentArray2 = new CMapSegment[n3 + 1];
        System.arraycopy(cMapSegmentArray, 0, cMapSegmentArray2, 0, n3);
        cMapSegmentArray2[n3] = new CMapSegment(n, n, n2);
        this.cmap = cMapSegmentArray2;
    }

    private int createPrivateUseMapping(int n) {
        while (this.nextPrivateUse < 63744 && this.findGlyphIndex(this.nextPrivateUse) != 0) {
            ++this.nextPrivateUse;
        }
        if (this.nextPrivateUse < 63744) {
            int n2 = this.nextPrivateUse;
            this.addPrivateUseMapping(n2, n);
            if (this.firstPrivate == 0) {
                this.firstPrivate = n2;
            }
            this.lastPrivate = n2;
            ++this.numMapped;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create private use mapping from " + CharUtilities.format(n2) + " to glyph index " + n + " in font '" + this.getFullName() + "'"));
            }
            return n2;
        }
        if (this.firstUnmapped == 0) {
            this.firstUnmapped = n;
        }
        this.lastUnmapped = n;
        ++this.numUnmapped;
        log.warn((Object)("Exhausted private use area: unable to map " + this.numUnmapped + " glyphs in glyph index range [" + this.firstUnmapped + "," + this.lastUnmapped + "] (inclusive) of font '" + this.getFullName() + "'"));
        return 0;
    }

    private int findCharacterFromGlyphIndex(int n, boolean bl) {
        int n2 = 0;
        for (CMapSegment cMapSegment : this.cmap) {
            int n3 = cMapSegment.getGlyphStartIndex();
            int n4 = n3 + (cMapSegment.getUnicodeEnd() - cMapSegment.getUnicodeStart());
            if (n < n3 || n > n4) continue;
            n2 = cMapSegment.getUnicodeStart() + (n - n3);
            break;
        }
        if (n2 == 0 && bl) {
            n2 = this.createPrivateUseMapping(n);
        }
        return n2;
    }

    private int findCharacterFromGlyphIndex(int n) {
        return this.findCharacterFromGlyphIndex(n, true);
    }

    @Override
    public char mapChar(char c) {
        this.notifyMapOperation();
        int n = this.findGlyphIndex(c);
        if (n == 0) {
            this.warnMissingGlyph(c);
            n = this.findGlyphIndex(35);
        }
        if (this.isEmbeddable()) {
            n = this.subset.mapSubsetChar(n, c);
        }
        return (char)n;
    }

    @Override
    public boolean hasChar(char c) {
        return this.findGlyphIndex(c) != 0;
    }

    public void setDefaultWidth(int n) {
        this.defaultWidth = n;
    }

    public String getTTCName() {
        return this.ttcName;
    }

    public void setTTCName(String string) {
        this.ttcName = string;
    }

    public void setWidthArray(int[] nArray) {
        this.width = nArray;
    }

    public Map<Integer, Integer> getUsedGlyphs() {
        return this.subset.getSubsetGlyphs();
    }

    public char[] getCharsUsed() {
        if (!this.isEmbeddable()) {
            return null;
        }
        return this.subset.getSubsetChars();
    }

    public void setGDEF(GlyphDefinitionTable glyphDefinitionTable) {
        if (this.gdef != null && glyphDefinitionTable != null) {
            throw new IllegalStateException("font already associated with GDEF table");
        }
        this.gdef = glyphDefinitionTable;
    }

    public GlyphDefinitionTable getGDEF() {
        return this.gdef;
    }

    public void setGSUB(GlyphSubstitutionTable glyphSubstitutionTable) {
        if (this.gsub != null && glyphSubstitutionTable != null) {
            throw new IllegalStateException("font already associated with GSUB table");
        }
        this.gsub = glyphSubstitutionTable;
    }

    public GlyphSubstitutionTable getGSUB() {
        return this.gsub;
    }

    public void setGPOS(GlyphPositioningTable glyphPositioningTable) {
        if (this.gpos != null && glyphPositioningTable != null) {
            throw new IllegalStateException("font already associated with GPOS table");
        }
        this.gpos = glyphPositioningTable;
    }

    public GlyphPositioningTable getGPOS() {
        return this.gpos;
    }

    @Override
    public boolean performsSubstitution() {
        return this.gsub != null;
    }

    @Override
    public CharSequence performSubstitution(CharSequence charSequence, String string, String string2) {
        if (this.gsub != null) {
            GlyphSequence glyphSequence = this.mapCharsToGlyphs(charSequence);
            GlyphSequence glyphSequence2 = this.gsub.substitute(glyphSequence, string, string2);
            CharSequence charSequence2 = this.mapGlyphsToChars(glyphSequence2);
            return charSequence2;
        }
        return charSequence;
    }

    @Override
    public CharSequence reorderCombiningMarks(CharSequence charSequence, int[][] nArray, String string, String string2) {
        if (this.gdef != null) {
            GlyphSequence glyphSequence = this.mapCharsToGlyphs(charSequence);
            GlyphSequence glyphSequence2 = this.gdef.reorderCombiningMarks(glyphSequence, nArray, string, string2);
            CharSequence charSequence2 = this.mapGlyphsToChars(glyphSequence2);
            return charSequence2;
        }
        return charSequence;
    }

    @Override
    public boolean performsPositioning() {
        return this.gpos != null;
    }

    @Override
    public int[][] performPositioning(CharSequence charSequence, String string, String string2, int n) {
        if (this.gpos != null) {
            int[][] nArray;
            GlyphSequence glyphSequence = this.mapCharsToGlyphs(charSequence);
            if (this.gpos.position(glyphSequence, string, string2, n, this.width, nArray = new int[glyphSequence.getGlyphCount()][4])) {
                return this.scaleAdjustments(nArray, n);
            }
            return null;
        }
        return null;
    }

    @Override
    public int[][] performPositioning(CharSequence charSequence, String string, String string2) {
        throw new UnsupportedOperationException();
    }

    private int[][] scaleAdjustments(int[][] nArray, int n) {
        if (nArray != null) {
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                int[] nArray2 = nArray[i];
                for (int j = 0; j < 4; ++j) {
                    nArray2[j] = nArray2[j] * n / 1000;
                }
            }
            return nArray;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GlyphSequence mapCharsToGlyphs(CharSequence charSequence) {
        IntBuffer intBuffer = IntBuffer.allocate(charSequence.length());
        IntBuffer intBuffer2 = IntBuffer.allocate(charSequence.length());
        int n = this.findGlyphIndex(35);
        int n2 = charSequence.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = charSequence.charAt(i);
            if (n3 >= 55296 && n3 < 56320) {
                char c;
                if (i + 1 >= n2) throw new IllegalArgumentException("ill-formed UTF-16 sequence, contains isolated high surrogate at end of sequence");
                int n4 = n3;
                if ((c = charSequence.charAt(++i)) < '\udc00' || c >= '\ue000') throw new IllegalArgumentException("ill-formed UTF-16 sequence, contains isolated high surrogate at index " + i);
                n3 = 65536 + (n4 - 55296 << 10) + (c - 56320 << 0);
            } else if (n3 >= 56320 && n3 < 57344) {
                throw new IllegalArgumentException("ill-formed UTF-16 sequence, contains isolated low surrogate at index " + i);
            }
            this.notifyMapOperation();
            int n5 = this.findGlyphIndex(n3);
            if (n5 == 0) {
                this.warnMissingGlyph((char)n3);
                n5 = n;
            }
            intBuffer.put(n3);
            intBuffer2.put(n5);
        }
        intBuffer.flip();
        intBuffer2.flip();
        return new GlyphSequence(intBuffer, intBuffer2, null);
    }

    private CharSequence mapGlyphsToChars(GlyphSequence glyphSequence) {
        int n = glyphSequence.getGlyphCount();
        CharBuffer charBuffer = CharBuffer.allocate(n);
        int n2 = 35;
        int n3 = n;
        for (int i = 0; i < n3; ++i) {
            int n4 = glyphSequence.getGlyph(i);
            int n5 = this.findCharacterFromGlyphIndex(n4);
            if (n5 == 0 || n5 > 0x10FFFF) {
                n5 = n2;
                log.warn((Object)("Unable to map glyph index " + n4 + " to Unicode scalar in font '" + this.getFullName() + "', substituting missing character '" + (char)n5 + "'"));
            }
            if (n5 > 65535) {
                int n6 = ((n5 -= 65536) >> 10 & 0x3FF) + 55296;
                int n7 = (n5 >> 0 & 0x3FF) + 56320;
                charBuffer.put((char)n6);
                charBuffer.put((char)n7);
                continue;
            }
            charBuffer.put((char)n5);
        }
        charBuffer.flip();
        return charBuffer;
    }
}

