/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.fonts.truetype.TTFFile;

class TTFMtxEntry {
    private int wx;
    private int lsb;
    private String name = "";
    private int index;
    private List unicodeIndex = new ArrayList();
    private int[] boundingBox = new int[4];
    private long offset;
    private byte found = 0;

    TTFMtxEntry() {
    }

    public String toString(TTFFile tTFFile) {
        return "Glyph " + this.name + " index: " + this.getIndexAsString() + " bbox [" + tTFFile.convertTTFUnit2PDFUnit(this.boundingBox[0]) + " " + tTFFile.convertTTFUnit2PDFUnit(this.boundingBox[1]) + " " + tTFFile.convertTTFUnit2PDFUnit(this.boundingBox[2]) + " " + tTFFile.convertTTFUnit2PDFUnit(this.boundingBox[3]) + "] wx: " + tTFFile.convertTTFUnit2PDFUnit(this.wx);
    }

    public int[] getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(int[] nArray) {
        this.boundingBox = nArray;
    }

    public byte getFound() {
        return this.found;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isIndexReserved() {
        return this.getIndex() >= 32768 && this.getIndex() <= 65535;
    }

    public String getIndexAsString() {
        if (this.isIndexReserved()) {
            return Integer.toString(this.getIndex()) + " (reserved)";
        }
        return Integer.toString(this.getIndex());
    }

    public int getLsb() {
        return this.lsb;
    }

    public String getName() {
        return this.name;
    }

    public long getOffset() {
        return this.offset;
    }

    public List getUnicodeIndex() {
        return this.unicodeIndex;
    }

    public int getWx() {
        return this.wx;
    }

    public void setFound(byte by) {
        this.found = by;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void setLsb(int n) {
        this.lsb = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOffset(long l) {
        this.offset = l;
    }

    public void setWx(int n) {
        this.wx = n;
    }
}

