/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.awt.geom.RectangularShape;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.SingleByteEncoding;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.type1.AFMCharMetrics;
import org.apache.fop.fonts.type1.AFMFile;
import org.apache.fop.fonts.type1.AFMParser;
import org.apache.fop.fonts.type1.PFMFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type1FontLoader
extends FontLoader {
    private SingleByteFont singleFont;
    private static final String[] AFM_EXTENSIONS = new String[]{".AFM", ".afm", ".Afm"};

    public Type1FontLoader(String string, boolean bl, boolean bl2, FontResolver fontResolver) throws IOException {
        super(string, bl, bl2, true, fontResolver);
    }

    private String getPFMURI(String string) {
        String string2 = string.substring(string.length() - 3, string.length());
        String string3 = string2.substring(0, 2) + (Character.isUpperCase(string2.charAt(2)) ? "M" : "m");
        return string.substring(0, string.length() - 4) + "." + string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void read() throws IOException {
        AFMFile aFMFile = null;
        PFMFile pFMFile = null;
        InputStream inputStream = null;
        String string = null;
        for (int i = 0; i < AFM_EXTENSIONS.length; ++i) {
            try {
                string = this.fontFileURI.substring(0, this.fontFileURI.length() - 4) + AFM_EXTENSIONS[i];
                inputStream = Type1FontLoader.openFontUri(this.resolver, string);
                if (inputStream == null) continue;
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                AFMParser aFMParser = new AFMParser();
                aFMFile = aFMParser.parse(inputStream, string);
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
        String string2 = this.getPFMURI(this.fontFileURI);
        InputStream inputStream2 = null;
        try {
            inputStream2 = Type1FontLoader.openFontUri(this.resolver, string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (inputStream2 != null) {
            try {
                pFMFile = new PFMFile();
                pFMFile.load(inputStream2);
            }
            catch (IOException iOException) {
                if (aFMFile == null) {
                    throw iOException;
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream2);
            }
        }
        if (aFMFile == null && pFMFile == null) {
            throw new FileNotFoundException("Neither an AFM nor a PFM file was found for " + this.fontFileURI);
        }
        this.buildFont(aFMFile, pFMFile);
        this.loaded = true;
    }

    private void buildFont(AFMFile aFMFile, PFMFile pFMFile) {
        if (aFMFile == null && pFMFile == null) {
            throw new IllegalArgumentException("Need at least an AFM or a PFM!");
        }
        this.singleFont = new SingleByteFont();
        this.singleFont.setFontType(FontType.TYPE1);
        this.singleFont.setResolver(this.resolver);
        if (this.embedded) {
            this.singleFont.setEmbedFileName(this.fontFileURI);
        }
        this.returnFont = this.singleFont;
        this.handleEncoding(aFMFile, pFMFile);
        this.handleFontName(aFMFile, pFMFile);
        this.handleMetrics(aFMFile, pFMFile);
    }

    private void handleEncoding(AFMFile aFMFile, PFMFile pFMFile) {
        if (aFMFile != null) {
            String string = aFMFile.getEncodingScheme();
            this.singleFont.setUseNativeEncoding(true);
            if ("AdobeStandardEncoding".equals(string)) {
                this.singleFont.setEncoding("StandardEncoding");
                this.addUnencodedBasedOnEncoding(aFMFile);
            } else {
                String string2 = "FontSpecific".equals(string) ? aFMFile.getFontName() + "Encoding" : string;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unusual font encoding encountered: " + string + " -> " + string2));
                }
                CodePointMapping codePointMapping = this.buildCustomEncoding(string2, aFMFile);
                this.singleFont.setEncoding(codePointMapping);
                this.addUnencodedBasedOnAFM(aFMFile);
            }
        } else if (pFMFile.getCharSet() >= 0 && pFMFile.getCharSet() <= 2) {
            this.singleFont.setEncoding(pFMFile.getCharSetName() + "Encoding");
        } else {
            log.warn((Object)("The PFM reports an unsupported encoding (" + pFMFile.getCharSetName() + "). The font may not work as expected."));
            this.singleFont.setEncoding("WinAnsiEncoding");
        }
    }

    private Set<String> toGlyphSet(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray) {
            hashSet.add(string);
        }
        return hashSet;
    }

    private void addUnencodedBasedOnEncoding(AFMFile aFMFile) {
        SingleByteEncoding singleByteEncoding = this.singleFont.getEncoding();
        Set<String> set = this.toGlyphSet(singleByteEncoding.getCharNameMap());
        List<AFMCharMetrics> list = aFMFile.getCharMetrics();
        for (AFMCharMetrics aFMCharMetrics : list) {
            String string = aFMCharMetrics.getCharName();
            if (string == null || set.contains(string)) continue;
            this.singleFont.addUnencodedCharacter(aFMCharMetrics.getCharacter(), (int)Math.round(aFMCharMetrics.getWidthX()));
        }
    }

    private void addUnencodedBasedOnAFM(AFMFile aFMFile) {
        List<AFMCharMetrics> list = aFMFile.getCharMetrics();
        int n = aFMFile.getCharCount();
        for (int i = 0; i < n; ++i) {
            AFMCharMetrics aFMCharMetrics = list.get(i);
            if (aFMCharMetrics.hasCharCode() || aFMCharMetrics.getCharacter() == null) continue;
            this.singleFont.addUnencodedCharacter(aFMCharMetrics.getCharacter(), (int)Math.round(aFMCharMetrics.getWidthX()));
        }
    }

    private void handleFontName(AFMFile aFMFile, PFMFile pFMFile) {
        if (aFMFile != null) {
            this.returnFont.setFontName(aFMFile.getFontName());
            this.returnFont.setFullName(aFMFile.getFullName());
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(aFMFile.getFamilyName());
            this.returnFont.setFamilyNames(hashSet);
        } else {
            this.returnFont.setFontName(pFMFile.getPostscriptName());
            String string = pFMFile.getPostscriptName();
            string = string.replace('-', ' ');
            this.returnFont.setFullName(string);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(pFMFile.getWindowsName());
            this.returnFont.setFamilyNames(hashSet);
        }
    }

    private void handleMetrics(AFMFile aFMFile, PFMFile pFMFile) {
        Object object;
        AFMCharMetrics aFMCharMetrics;
        if (aFMFile != null) {
            if (aFMFile.getCapHeight() != null) {
                this.returnFont.setCapHeight(aFMFile.getCapHeight().intValue());
            }
            if (aFMFile.getXHeight() != null) {
                this.returnFont.setXHeight(aFMFile.getXHeight().intValue());
            }
            if (aFMFile.getAscender() != null) {
                this.returnFont.setAscender(aFMFile.getAscender().intValue());
            }
            if (aFMFile.getDescender() != null) {
                this.returnFont.setDescender(aFMFile.getDescender().intValue());
            }
            this.returnFont.setFontBBox(aFMFile.getFontBBoxAsIntArray());
            if (aFMFile.getStdVW() != null) {
                this.returnFont.setStemV(aFMFile.getStdVW().intValue());
            } else {
                this.returnFont.setStemV(80);
            }
            this.returnFont.setItalicAngle((int)aFMFile.getWritingDirectionMetrics(0).getItalicAngle());
        } else {
            this.returnFont.setFontBBox(pFMFile.getFontBBox());
            this.returnFont.setStemV(pFMFile.getStemV());
            this.returnFont.setItalicAngle(pFMFile.getItalicAngle());
        }
        if (pFMFile != null) {
            if (this.returnFont.getCapHeight() == 0) {
                this.returnFont.setCapHeight(pFMFile.getCapHeight());
            }
            if (this.returnFont.getXHeight(1) == 0) {
                this.returnFont.setXHeight(pFMFile.getXHeight());
            }
            if (this.returnFont.getAscender() == 0) {
                this.returnFont.setAscender(pFMFile.getLowerCaseAscent());
            }
            if (this.returnFont.getDescender() == 0) {
                this.returnFont.setDescender(pFMFile.getLowerCaseDescent());
            }
        }
        if (this.returnFont.getXHeight(1) == 0) {
            int n;
            int string;
            boolean s = false;
            if (aFMFile != null && (aFMCharMetrics = aFMFile.getChar("x")) != null && (object = aFMCharMetrics.getBBox()) != null) {
                string = (int)Math.round(((RectangularShape)object).getMinX());
            }
            if (string == 0) {
                n = Math.round((float)this.returnFont.getFontBBox()[3] * 0.6f);
            }
            this.returnFont.setXHeight(n);
        }
        if (this.returnFont.getAscender() == 0) {
            int n;
            int n2;
            boolean bl = false;
            if (aFMFile != null && (aFMCharMetrics = aFMFile.getChar("d")) != null && (object = aFMCharMetrics.getBBox()) != null) {
                n2 = (int)Math.round(((RectangularShape)object).getMinX());
            }
            if (n2 == 0) {
                n = Math.round((float)this.returnFont.getFontBBox()[3] * 0.9f);
            }
            this.returnFont.setAscender(n);
        }
        if (this.returnFont.getDescender() == 0) {
            int n;
            int n3;
            boolean bl = false;
            if (aFMFile != null && (aFMCharMetrics = aFMFile.getChar("p")) != null && (object = aFMCharMetrics.getBBox()) != null) {
                n3 = (int)Math.round(((RectangularShape)object).getMinX());
            }
            if (n3 == 0) {
                n = this.returnFont.getFontBBox()[1];
            }
            this.returnFont.setDescender(n);
        }
        if (this.returnFont.getCapHeight() == 0) {
            this.returnFont.setCapHeight(this.returnFont.getAscender());
        }
        if (aFMFile != null) {
            String string = aFMFile.getCharacterSet();
            int n = 0;
            n = "Special".equals(string) ? (n |= 4) : (this.singleFont.getEncoding().mapChar('A') == 'A' ? (n |= 0x20) : (n |= 4));
            if (aFMFile.getWritingDirectionMetrics(0).isFixedPitch()) {
                n |= 1;
            }
            if (aFMFile.getWritingDirectionMetrics(0).getItalicAngle() != 0.0) {
                n |= 0x40;
            }
            this.returnFont.setFlags(n);
            this.returnFont.setFirstChar(aFMFile.getFirstChar());
            this.returnFont.setLastChar(aFMFile.getLastChar());
            for (AFMCharMetrics aFMCharMetrics2 : aFMFile.getCharMetrics()) {
                if (!aFMCharMetrics2.hasCharCode()) continue;
                this.singleFont.setWidth(aFMCharMetrics2.getCharCode(), (int)Math.round(aFMCharMetrics2.getWidthX()));
            }
            if (this.useKerning) {
                this.returnFont.replaceKerningMap(aFMFile.createXKerningMapEncoded());
            }
        } else {
            short s;
            this.returnFont.setFlags(pFMFile.getFlags());
            this.returnFont.setFirstChar(pFMFile.getFirstChar());
            this.returnFont.setLastChar(pFMFile.getLastChar());
            short s2 = pFMFile.getFirstChar();
            while (s <= pFMFile.getLastChar()) {
                this.singleFont.setWidth(s, pFMFile.getCharWidth(s));
                s = (short)(s + true);
            }
            if (this.useKerning) {
                this.returnFont.replaceKerningMap(pFMFile.getKerning());
            }
        }
    }

    private CodePointMapping buildCustomEncoding(String string, AFMFile aFMFile) {
        int n = 0;
        List<AFMCharMetrics> list = aFMFile.getCharMetrics();
        for (AFMCharMetrics stringArray2 : list) {
            String n2;
            if (stringArray2.getCharCode() < 0 || (n2 = stringArray2.getUnicodeSequence()) == null || n2.length() != 1) continue;
            ++n;
        }
        Object object = new int[n * 2];
        String[] stringArray = new String[256];
        int n2 = 0;
        for (AFMCharMetrics aFMCharMetrics : list) {
            if (aFMCharMetrics.getCharCode() < 0) continue;
            stringArray[aFMCharMetrics.getCharCode()] = aFMCharMetrics.getCharName();
            String string2 = aFMCharMetrics.getUnicodeSequence();
            if (string2 == null) {
                log.info((Object)("No Unicode mapping for glyph: " + aFMCharMetrics));
                continue;
            }
            if (string2.length() == 1) {
                object[n2] = aFMCharMetrics.getCharCode();
                object[++n2] = string2.charAt(0);
                ++n2;
                continue;
            }
            log.warn((Object)("Multi-character representation of glyph not currently supported: " + aFMCharMetrics));
        }
        return new CodePointMapping(string, (int[])object, stringArray);
    }
}

