/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.hyphenation;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.fop.hyphenation.HyphenationTree;

public class HyphenationTreeCache {
    private Hashtable hyphenTrees = new Hashtable();
    private Set missingHyphenationTrees;

    public HyphenationTree getHyphenationTree(String string, String string2) {
        String string3 = HyphenationTreeCache.constructLlccKey(string, string2);
        if (this.hyphenTrees.containsKey(string3)) {
            return (HyphenationTree)this.hyphenTrees.get(string3);
        }
        if (this.hyphenTrees.containsKey(string)) {
            return (HyphenationTree)this.hyphenTrees.get(string);
        }
        return null;
    }

    public static String constructLlccKey(String string, String string2) {
        String string3 = string;
        if (string2 != null && !string2.equals("none")) {
            string3 = string3 + "_" + string2;
        }
        return string3;
    }

    public static String constructUserKey(String string, String string2, Map map) {
        String string3 = null;
        if (map != null) {
            String string4 = HyphenationTreeCache.constructLlccKey(string, string2);
            string4 = string4.replace('_', '-');
            string3 = (String)map.get(string4);
        }
        return string3;
    }

    public void cache(String string, HyphenationTree hyphenationTree) {
        this.hyphenTrees.put(string, hyphenationTree);
    }

    public void noteMissing(String string) {
        if (this.missingHyphenationTrees == null) {
            this.missingHyphenationTrees = new HashSet();
        }
        this.missingHyphenationTrees.add(string);
    }

    public boolean isMissing(String string) {
        return this.missingHyphenationTrees != null && this.missingHyphenationTrees.contains(string);
    }
}

