/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.layoutmgr.Adjustment;
import org.apache.fop.layoutmgr.BlockKnuthSequence;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BreakingAlgorithm;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.ListUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBreaker {
    protected static final Log log = LogFactory.getLog(AbstractBreaker.class);
    private List<BlockSequence> blockLists;
    private boolean empty = true;
    protected int alignment;
    private int alignmentLast;
    protected MinOptMax footnoteSeparatorLength = MinOptMax.ZERO;

    static String getBreakClassName(int n) {
        switch (n) {
            case 5: {
                return "ALL";
            }
            case 8: {
                return "ANY";
            }
            case 9: {
                return "AUTO";
            }
            case 28: {
                return "COLUMN";
            }
            case 44: {
                return "EVEN PAGE";
            }
            case 75: {
                return "LINE";
            }
            case 95: {
                return "NONE";
            }
            case 100: {
                return "ODD PAGE";
            }
            case 104: {
                return "PAGE";
            }
        }
        return "??? (" + String.valueOf(n) + ")";
    }

    protected abstract int getCurrentDisplayAlign();

    protected abstract boolean hasMoreContent();

    protected abstract void addAreas(PositionIterator var1, LayoutContext var2);

    protected abstract LayoutManager getTopLevelLM();

    protected abstract LayoutManager getCurrentChildLM();

    protected boolean isPartOverflowRecoveryActivated() {
        return true;
    }

    protected boolean isSinglePartFavored() {
        return false;
    }

    protected PageProvider getPageProvider() {
        return null;
    }

    protected PageBreakingAlgorithm.PageBreakingLayoutListener createLayoutListener() {
        return null;
    }

    protected abstract List<KnuthElement> getNextKnuthElements(LayoutContext var1, int var2);

    protected List<KnuthElement> getNextKnuthElements(LayoutContext layoutContext, int n, Position position, LayoutManager layoutManager) {
        throw new UnsupportedOperationException("TODO: implement acceptable fallback");
    }

    public boolean isEmpty() {
        return this.empty;
    }

    protected void startPart(BlockSequence blockSequence, int n) {
    }

    protected void handleEmptyContent() {
    }

    protected abstract void finishPart(PageBreakingAlgorithm var1, PageBreakPosition var2);

    protected LayoutContext createLayoutContext() {
        return new LayoutContext(0);
    }

    protected void updateLayoutContext(LayoutContext layoutContext) {
    }

    protected void observeElementList(List list) {
        ElementListObserver.observe(list, "breaker", null);
    }

    public void doLayout(int n, boolean bl) {
        LayoutContext layoutContext = this.createLayoutContext();
        layoutContext.setStackLimitBP(MinOptMax.getInstance(n));
        this.alignment = this.getCurrentDisplayAlign() == 162 ? 70 : (this.getCurrentDisplayAlign() == 163 ? 70 : 135);
        this.alignmentLast = 135;
        if (this.isSinglePartFavored() && this.alignment == 70) {
            this.alignmentLast = 70;
        }
        layoutContext.setBPAlignment(this.alignment);
        this.blockLists = new ArrayList<BlockSequence>();
        log.debug((Object)("PLM> flow BPD =" + n));
        int n2 = 8;
        while (this.hasMoreContent()) {
            this.blockLists.clear();
            n2 = this.getNextBlockList(layoutContext, n2);
            this.empty = this.empty && this.blockLists.size() == 0;
            log.debug((Object)("PLM> blockLists.size() = " + this.blockLists.size()));
            for (int i = 0; i < this.blockLists.size(); ++i) {
                BlockSequence blockSequence = this.blockLists.get(i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  blockListIndex = " + i));
                    log.debug((Object)("  sequence starts on " + AbstractBreaker.getBreakClassName(blockSequence.startOn)));
                }
                this.observeElementList(blockSequence);
                log.debug((Object)("PLM> start of algorithm (" + this.getClass().getName() + "), flow BPD =" + n));
                PageBreakingAlgorithm pageBreakingAlgorithm = new PageBreakingAlgorithm(this.getTopLevelLM(), this.getPageProvider(), this.createLayoutListener(), this.alignment, this.alignmentLast, this.footnoteSeparatorLength, this.isPartOverflowRecoveryActivated(), bl, this.isSinglePartFavored());
                BlockSequence blockSequence2 = this.getCurrentDisplayAlign() == 162 ? this.justifyBoxes(blockSequence, pageBreakingAlgorithm, n) : blockSequence;
                pageBreakingAlgorithm.setConstantLineWidth(n);
                int n3 = pageBreakingAlgorithm.findBreakingPoints(blockSequence2, 1.0, true, 0);
                if (Math.abs(pageBreakingAlgorithm.getIPDdifference()) > 1) {
                    this.addAreas(pageBreakingAlgorithm, n3, blockSequence, blockSequence2);
                    log.trace((Object)("IPD changes after page " + n3));
                    this.blockLists.clear();
                    n2 = this.getNextBlockListChangedIPD(layoutContext, pageBreakingAlgorithm, blockSequence2);
                    i = -1;
                    continue;
                }
                log.debug((Object)("PLM> optimalPageCount= " + n3 + " pageBreaks.size()= " + pageBreakingAlgorithm.getPageBreaks().size()));
                this.doPhase3(pageBreakingAlgorithm, n3, blockSequence, blockSequence2);
            }
        }
        this.blockLists = null;
    }

    private boolean containsNonRestartableLM(Position position) {
        LayoutManager layoutManager = position.getLM();
        if (layoutManager != null && !layoutManager.isRestartable()) {
            return true;
        }
        Position position2 = position.getPosition();
        return position2 != null && this.containsNonRestartableLM(position2);
    }

    protected abstract void doPhase3(PageBreakingAlgorithm var1, int var2, BlockSequence var3, BlockSequence var4);

    protected void addAreas(PageBreakingAlgorithm pageBreakingAlgorithm, int n, BlockSequence blockSequence, BlockSequence blockSequence2) {
        this.addAreas(pageBreakingAlgorithm, 0, n, blockSequence, blockSequence2);
    }

    protected void addAreas(PageBreakingAlgorithm pageBreakingAlgorithm, int n, int n2, BlockSequence blockSequence, BlockSequence blockSequence2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        for (int i = n; i < n + n2; ++i) {
            int n6;
            PageBreakPosition pageBreakPosition = pageBreakingAlgorithm.getPageBreaks().get(i);
            if (i == 0) {
                n6 = blockSequence2.getStartOn();
            } else {
                ListElement listElement = blockSequence2.getElement(n4);
                if (listElement.isPenalty()) {
                    KnuthPenalty knuthPenalty = (KnuthPenalty)listElement;
                    n6 = knuthPenalty.getBreakClass();
                } else {
                    n6 = 28;
                }
            }
            n4 = pageBreakPosition.getLeafPos();
            log.debug((Object)("PLM> part: " + (i + 1) + ", start at pos " + (n3 += n3 == 0 ? blockSequence2.ignoreAtStart : 0) + ", break at pos " + n4 + ", break class = " + AbstractBreaker.getBreakClassName(n6)));
            this.startPart(blockSequence2, n6);
            int n7 = this.getCurrentDisplayAlign();
            int n8 = n4;
            if (((KnuthElement)blockSequence2.get(n4 -= n4 == blockSequence.size() - 1 ? blockSequence2.ignoreAtEnd : 0)).isGlue()) {
                --n4;
            }
            ListIterator listIterator = blockSequence2.listIterator(n3);
            while (listIterator.hasNext() && !((KnuthElement)listIterator.next()).isBox()) {
                ++n3;
            }
            if (n3 <= n4) {
                int n9;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("     addAreas from " + n3 + " to " + n4));
                }
                LayoutContext layoutContext = new LayoutContext(0);
                layoutContext.setSpaceAdjust(pageBreakPosition.bpdAdjust);
                if (pageBreakPosition.difference != 0 && n7 == 23) {
                    layoutContext.setSpaceBefore(pageBreakPosition.difference / 2);
                } else if (pageBreakPosition.difference != 0 && n7 == 3) {
                    layoutContext.setSpaceBefore(pageBreakPosition.difference);
                } else if (pageBreakPosition.difference != 0 && n7 == 163 && i < n2 - 1) {
                    n9 = 0;
                    listIterator = blockSequence2.listIterator(n3);
                    while (listIterator.nextIndex() <= n4) {
                        KnuthElement knuthElement = (KnuthElement)listIterator.next();
                        if (!knuthElement.isBox() || knuthElement.getWidth() <= 0) continue;
                        ++n9;
                    }
                    if (n9 >= 2) {
                        layoutContext.setSpaceAfter(pageBreakPosition.difference / (n9 - 1));
                    }
                }
                if (n7 == 162 && (n9 = this.optimizeLineLength(blockSequence2, n3, n4)) != 0) {
                    layoutContext.setStackLimitBP(MinOptMax.getInstance(n9));
                }
                SpaceResolver.performConditionalsNotification(blockSequence2, n3, n8, n5);
                this.addAreas(new KnuthPossPosIter(blockSequence2, n3, n4 + 1), layoutContext);
            } else {
                this.handleEmptyContent();
            }
            this.finishPart(pageBreakingAlgorithm, pageBreakPosition);
            n5 = n4;
            n3 = pageBreakPosition.getLeafPos() + 1;
        }
    }

    protected int handleSpanChange(LayoutContext layoutContext, int n) {
        return n;
    }

    protected int getNextBlockList(LayoutContext layoutContext, int n) {
        return this.getNextBlockList(layoutContext, n, null, null, null);
    }

    protected int getNextBlockList(LayoutContext layoutContext, int n, Position position, LayoutManager layoutManager, List<KnuthElement> list) {
        Object object;
        List<KnuthElement> list2;
        this.updateLayoutContext(layoutContext);
        layoutContext.signalSpanChange(0);
        if (list == null) {
            list2 = this.getNextKnuthElements(layoutContext, this.alignment);
        } else if (position == null) {
            list2 = list;
            object = list2.listIterator(list2.size());
            for (int i = 0; i < 3; ++i) {
                object.previous();
                object.remove();
            }
        } else {
            list2 = this.getNextKnuthElements(layoutContext, this.alignment, position, layoutManager);
            list2.addAll(0, list);
        }
        if (list2 != null) {
            if (list2.isEmpty()) {
                n = this.handleSpanChange(layoutContext, n);
                return n;
            }
            BlockSequence blockSequence = new BlockSequence(n, this.getCurrentDisplayAlign());
            n = this.handleSpanChange(layoutContext, n);
            object = null;
            if (ElementListUtils.endsWithForcedBreak(list2)) {
                KnuthPenalty knuthPenalty = (KnuthPenalty)ListUtil.removeLast(list2);
                object = knuthPenalty.getPosition();
                log.debug((Object)("PLM> break - " + AbstractBreaker.getBreakClassName(knuthPenalty.getBreakClass())));
                switch (knuthPenalty.getBreakClass()) {
                    case 104: {
                        n = 8;
                        break;
                    }
                    case 28: {
                        n = 28;
                        break;
                    }
                    case 100: {
                        n = 100;
                        break;
                    }
                    case 44: {
                        n = 44;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid break class: " + knuthPenalty.getBreakClass());
                    }
                }
            }
            blockSequence.addAll(list2);
            BlockSequence blockSequence2 = blockSequence.endBlockSequence((Position)object);
            if (blockSequence2 != null) {
                this.blockLists.add(blockSequence2);
            }
        }
        return n;
    }

    private int getNextBlockListChangedIPD(LayoutContext layoutContext, PageBreakingAlgorithm pageBreakingAlgorithm, BlockSequence blockSequence) {
        Object object;
        ListIterator listIterator;
        BreakingAlgorithm.KnuthNode knuthNode = pageBreakingAlgorithm.getBestNodeBeforeIPDChange();
        int n = knuthNode.position;
        log.trace((Object)("IPD changes at index " + n));
        KnuthElement knuthElement = pageBreakingAlgorithm.getElement(n);
        Position position = knuthElement.getPosition();
        if (!(position instanceof SpaceResolver.SpaceHandlingBreakPosition)) {
            throw new UnsupportedOperationException("Don't know how to restart at position " + position);
        }
        position = position.getPosition();
        LayoutManager layoutManager = null;
        List<KnuthElement> list = Collections.emptyList();
        if (this.containsNonRestartableLM(position)) {
            if (pageBreakingAlgorithm.getIPDdifference() > 0) {
                EventBroadcaster eventBroadcaster = this.getCurrentChildLM().getFObj().getUserAgent().getEventBroadcaster();
                listIterator = BlockLevelEventProducer.Provider.get(eventBroadcaster);
                listIterator.nonRestartableContentFlowingToNarrowerPage(this);
            }
            list = new LinkedList();
            boolean bl = false;
            listIterator = blockSequence.listIterator(n + 1);
            object = null;
            while (listIterator.hasNext() && (object == null || this.containsNonRestartableLM((Position)object))) {
                ++n;
                KnuthElement knuthElement2 = (KnuthElement)listIterator.next();
                object = knuthElement2.getPosition();
                if (knuthElement2.isBox()) {
                    bl = true;
                    list.add(knuthElement2);
                    continue;
                }
                if (!bl) continue;
                list.add(knuthElement2);
            }
            position = object instanceof SpaceResolver.SpaceHandlingBreakPosition ? ((Position)object).getPosition() : null;
        }
        if (position != null && position.getIndex() == -1) {
            Position position2;
            listIterator = blockSequence.listIterator(n + 1);
            while ((position2 = ((ListElement)(object = (KnuthElement)listIterator.next())).getPosition()) == null || position2 instanceof SpaceResolver.SpaceHandlingPosition || position2 instanceof SpaceResolver.SpaceHandlingBreakPosition && position2.getPosition().getIndex() == -1) {
            }
            object = position.getLM();
            while (position2.getLM() != object) {
                position2 = position2.getPosition();
            }
            layoutManager = position2.getPosition().getLM();
        }
        int n2 = this.getNextBlockList(layoutContext, 28, position, layoutManager, list);
        return n2;
    }

    private int optimizeLineLength(KnuthSequence knuthSequence, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        ListIterator listIterator = knuthSequence.listIterator(n);
        while (listIterator.nextIndex() <= n2) {
            KnuthElement knuthElement = (KnuthElement)listIterator.next();
            if (!(knuthElement instanceof KnuthBlockBox)) continue;
            KnuthBlockBox knuthBlockBox = (KnuthBlockBox)knuthElement;
            if (knuthBlockBox.getBPD() > 0) {
                log.debug((Object)("PSLM> nominal length of line = " + knuthBlockBox.getBPD()));
                log.debug((Object)("      range = " + knuthBlockBox.getIPDRange()));
                ++n3;
                n4 += ((KnuthBlockBox)knuthElement).getBPD();
            }
            if (knuthBlockBox.getIPDRange().getMin() <= n5) continue;
            n5 = knuthBlockBox.getIPDRange().getMin();
        }
        int n6 = 0;
        if (n4 > 0 && n3 > 0) {
            n6 = n4 / n3;
            log.debug((Object)("Average line length = " + n6));
            if (n6 < n5) {
                n6 = n5;
                log.debug((Object)("  Correction to: " + n6));
            }
        }
        return n6;
    }

    private BlockSequence justifyBoxes(BlockSequence blockSequence, PageBreakingAlgorithm pageBreakingAlgorithm, int n) {
        Object object;
        pageBreakingAlgorithm.setConstantLineWidth(n);
        int n2 = pageBreakingAlgorithm.findBreakingPoints(blockSequence, 1.0, true, 0);
        log.debug((Object)("PLM> optimalPageCount= " + n2));
        ListIterator listIterator = blockSequence.listIterator();
        ListIterator listIterator2 = pageBreakingAlgorithm.getPageBreaks().listIterator();
        KnuthElement knuthElement = null;
        while (listIterator2.hasNext()) {
            PageBreakPosition pageBreakPosition = (PageBreakPosition)listIterator2.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("| first page: break= " + pageBreakPosition.getLeafPos() + " difference= " + pageBreakPosition.difference + " ratio= " + pageBreakPosition.bpdAdjust));
            }
            int n3 = 0;
            while (listIterator.hasNext() && !((ListElement)(object = (KnuthElement)listIterator.next())).isBox()) {
                log.debug((Object)"PLM> ignoring glue or penalty element at the beginning of the sequence");
                if (!((ListElement)object).isGlue()) continue;
                ((BlockLevelLayoutManager)((ListElement)object).getLayoutManager()).discardSpace((KnuthGlue)object);
            }
            listIterator.previous();
            MinOptMax minOptMax = MinOptMax.ZERO;
            MinOptMax minOptMax2 = MinOptMax.ZERO;
            LinkedList<KnuthGlue> linkedList = new LinkedList<KnuthGlue>();
            LinkedList<KnuthGlue> linkedList2 = new LinkedList<KnuthGlue>();
            LinkedList<KnuthGlue> linkedList3 = new LinkedList<KnuthGlue>();
            boolean bl = false;
            while (listIterator.hasNext() && listIterator.nextIndex() <= pageBreakPosition.getLeafPos()) {
                KnuthGlue knuthGlue;
                knuthElement = (KnuthElement)listIterator.next();
                if (knuthElement.isGlue()) {
                    knuthGlue = (KnuthGlue)knuthElement;
                    Adjustment adjustment = knuthGlue.getAdjustmentClass();
                    if (adjustment.equals(Adjustment.SPACE_BEFORE_ADJUSTMENT) || adjustment.equals(Adjustment.SPACE_AFTER_ADJUSTMENT)) {
                        linkedList2.add(knuthGlue);
                        continue;
                    }
                    if (adjustment.equals(Adjustment.LINE_NUMBER_ADJUSTMENT)) {
                        minOptMax = minOptMax.plusMax(knuthElement.getStretch());
                        minOptMax = minOptMax.minusMin(knuthElement.getShrink());
                        linkedList3.add(knuthGlue);
                        continue;
                    }
                    if (!adjustment.equals(Adjustment.LINE_HEIGHT_ADJUSTMENT)) continue;
                }
                if (!knuthElement.isBox()) continue;
                if (!bl) {
                    bl = true;
                    continue;
                }
                while (!linkedList2.isEmpty()) {
                    knuthGlue = (KnuthGlue)linkedList2.removeFirst();
                    minOptMax2 = minOptMax2.plusMax(knuthGlue.getStretch());
                    minOptMax2 = minOptMax2.minusMin(knuthGlue.getShrink());
                    linkedList.add(knuthGlue);
                }
            }
            log.debug((Object)("| line number adj= " + minOptMax));
            log.debug((Object)("| space adj      = " + minOptMax2));
            if (knuthElement.isPenalty() && knuthElement.getWidth() > 0) {
                log.debug((Object)"  mandatory variation to the number of lines!");
                ((BlockLevelLayoutManager)knuthElement.getLayoutManager()).negotiateBPDAdjustment(knuthElement.getWidth(), knuthElement);
            }
            if (pageBreakPosition.bpdAdjust != 0.0 && pageBreakPosition.difference > 0 && pageBreakPosition.difference <= minOptMax2.getMax() || pageBreakPosition.difference < 0 && pageBreakPosition.difference >= minOptMax2.getMin()) {
                log.debug((Object)("single space: " + ((n3 += this.adjustBlockSpaces(linkedList, pageBreakPosition.difference, pageBreakPosition.difference > 0 ? minOptMax2.getMax() : -minOptMax2.getMin())) == pageBreakPosition.difference || pageBreakPosition.bpdAdjust == 0.0 ? "ok" : "ERROR")));
                continue;
            }
            if (pageBreakPosition.bpdAdjust == 0.0) continue;
            log.debug((Object)("lines and space: " + ((n3 += this.adjustBlockSpaces(linkedList, pageBreakPosition.difference - (n3 += this.adjustLineNumbers(linkedList3, pageBreakPosition.difference, pageBreakPosition.difference > 0 ? minOptMax.getMax() : -minOptMax.getMin())), pageBreakPosition.difference - n3 > 0 ? minOptMax2.getMax() : -minOptMax2.getMin())) == pageBreakPosition.difference || pageBreakPosition.bpdAdjust == 0.0 ? "ok" : "ERROR")));
        }
        object = new BlockSequence(blockSequence.getStartOn(), blockSequence.getDisplayAlign());
        ((ArrayList)object).addAll(this.getCurrentChildLM().getChangedKnuthElements(blockSequence.subList(0, blockSequence.size() - blockSequence.ignoreAtEnd), 0));
        ((BlockSequence)object).endSequence();
        ElementListObserver.observe((List)object, "breaker-effective", null);
        pageBreakingAlgorithm.getPageBreaks().clear();
        return object;
    }

    private int adjustBlockSpaces(LinkedList<KnuthGlue> linkedList, int n, int n2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AdjustBlockSpaces: difference " + n + " / " + n2 + " on " + linkedList.size() + " spaces in block"));
        }
        ListIterator listIterator = linkedList.listIterator();
        int n3 = 0;
        int n4 = 0;
        while (listIterator.hasNext()) {
            KnuthGlue knuthGlue = (KnuthGlue)listIterator.next();
            n4 += n > 0 ? knuthGlue.getStretch() : knuthGlue.getShrink();
            if (log.isDebugEnabled()) {
                log.debug((Object)("available = " + n4 + " / " + n2));
                log.debug((Object)("competenza  = " + ((int)((float)n4 * (float)n / (float)n2) - n3) + " / " + n));
            }
            int n5 = ((BlockLevelLayoutManager)knuthGlue.getLayoutManager()).negotiateBPDAdjustment((int)((float)n4 * (float)n / (float)n2) - n3, knuthGlue);
            n3 += n5;
        }
        return n3;
    }

    private int adjustLineNumbers(LinkedList<KnuthGlue> linkedList, int n, int n2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AdjustLineNumbers: difference " + n + " / " + n2 + " on " + linkedList.size() + " elements"));
        }
        ListIterator listIterator = linkedList.listIterator();
        int n3 = 0;
        int n4 = 0;
        while (listIterator.hasNext()) {
            KnuthGlue knuthGlue = (KnuthGlue)listIterator.next();
            int n5 = ((BlockLevelLayoutManager)knuthGlue.getLayoutManager()).negotiateBPDAdjustment((int)((float)(n4 += n > 0 ? knuthGlue.getStretch() : knuthGlue.getShrink()) * (float)n / (float)n2) - n3, knuthGlue);
            n3 += n5;
        }
        return n3;
    }

    public class BlockSequence
    extends BlockKnuthSequence {
        private static final long serialVersionUID = -5348831120146774118L;
        int ignoreAtStart = 0;
        int ignoreAtEnd = 0;
        private int startOn;
        private int displayAlign;

        public BlockSequence(int n, int n2) {
            this.startOn = n;
            this.displayAlign = n2;
        }

        public int getStartOn() {
            return this.startOn;
        }

        public int getDisplayAlign() {
            return this.displayAlign;
        }

        public KnuthSequence endSequence() {
            return this.endSequence(null);
        }

        public KnuthSequence endSequence(Position position) {
            while (this.size() > this.ignoreAtStart && !((KnuthElement)ListUtil.getLast(this)).isBox()) {
                ListUtil.removeLast(this);
            }
            if (this.size() > this.ignoreAtStart) {
                if (this.getDisplayAlign() == 163 && AbstractBreaker.this.isSinglePartFavored()) {
                    this.add(new KnuthPenalty(0, -1000, false, position, false));
                    this.ignoreAtEnd = 1;
                } else {
                    this.add(new KnuthPenalty(0, 1000, false, null, false));
                    this.add(new KnuthGlue(0, 10000000, 0, null, false));
                    this.add(new KnuthPenalty(0, -1000, false, position, false));
                    this.ignoreAtEnd = 3;
                }
                return this;
            }
            this.clear();
            return null;
        }

        public BlockSequence endBlockSequence(Position position) {
            KnuthSequence knuthSequence = this.endSequence(position);
            if (knuthSequence != null) {
                BlockSequence blockSequence = new BlockSequence(this.startOn, this.displayAlign);
                blockSequence.addAll(knuthSequence);
                blockSequence.ignoreAtEnd = this.ignoreAtEnd;
                return blockSequence;
            }
            return null;
        }
    }

    public static class PageBreakPosition
    extends LeafPosition {
        double bpdAdjust;
        int difference;
        int footnoteFirstListIndex;
        int footnoteFirstElementIndex;
        int footnoteLastListIndex;
        int footnoteLastElementIndex;

        PageBreakPosition(LayoutManager layoutManager, int n, int n2, int n3, int n4, int n5, double d, int n6) {
            super(layoutManager, n);
            this.bpdAdjust = d;
            this.difference = n6;
            this.footnoteFirstListIndex = n2;
            this.footnoteFirstElementIndex = n3;
            this.footnoteLastListIndex = n4;
            this.footnoteLastElementIndex = n5;
        }
    }
}

