/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.PageViewport;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.RetrieveMarker;
import org.apache.fop.layoutmgr.AbstractBaseLayoutManager;
import org.apache.fop.layoutmgr.FlowLayoutManager;
import org.apache.fop.layoutmgr.LMiter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.Page;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLayoutManager
extends AbstractBaseLayoutManager
implements Constants {
    private static Log log = LogFactory.getLog(AbstractLayoutManager.class);
    protected LayoutManager parentLayoutManager;
    protected List<LayoutManager> childLMs;
    protected ListIterator fobjIter;
    private Map<String, Marker> markers;
    private boolean isFinished;
    protected LayoutManager curChildLM;
    protected ListIterator<LayoutManager> childLMiter;
    private int lastGeneratedPosition = -1;
    private int smallestPosNumberChecked = Integer.MAX_VALUE;

    public AbstractLayoutManager() {
    }

    public AbstractLayoutManager(FObj fObj) {
        super(fObj);
        if (fObj == null) {
            throw new IllegalStateException("Null formatting object found.");
        }
        this.markers = fObj.getMarkers();
        this.fobjIter = fObj.getChildNodes();
        this.childLMiter = new LMiter(this);
    }

    @Override
    public void setParent(LayoutManager layoutManager) {
        this.parentLayoutManager = layoutManager;
    }

    @Override
    public LayoutManager getParent() {
        return this.parentLayoutManager;
    }

    @Override
    public void initialize() {
    }

    protected LayoutManager getChildLM() {
        if (this.curChildLM != null && !this.curChildLM.isFinished()) {
            return this.curChildLM;
        }
        if (this.childLMiter.hasNext()) {
            this.curChildLM = this.childLMiter.next();
            this.curChildLM.initialize();
            return this.curChildLM;
        }
        return null;
    }

    protected void setCurrentChildLM(LayoutManager layoutManager) {
        this.curChildLM = layoutManager;
        this.childLMiter = new LMiter(this);
        do {
            this.curChildLM = this.childLMiter.next();
        } while (this.curChildLM != layoutManager);
    }

    protected boolean hasNextChildLM() {
        return this.childLMiter.hasNext();
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void setFinished(boolean bl) {
        this.isFinished = bl;
    }

    @Override
    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
    }

    @Override
    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        log.warn((Object)"null implementation of getNextKnuthElements() called!");
        this.setFinished(true);
        return null;
    }

    @Override
    public List getChangedKnuthElements(List list, int n) {
        log.warn((Object)"null implementation of getChangeKnuthElement() called!");
        return null;
    }

    @Override
    public Area getParentArea(Area area) {
        return null;
    }

    @Override
    public void addChildArea(Area area) {
    }

    protected List<LayoutManager> createChildLMs(int n) {
        if (this.fobjIter == null) {
            return null;
        }
        ArrayList<LayoutManager> arrayList = new ArrayList<LayoutManager>(n);
        while (this.fobjIter.hasNext() && arrayList.size() < n) {
            Object e = this.fobjIter.next();
            if (!(e instanceof FONode)) continue;
            FONode fONode = (FONode)e;
            if (fONode instanceof RetrieveMarker) {
                fONode = this.getPSLM().resolveRetrieveMarker((RetrieveMarker)fONode);
            }
            if (fONode == null) continue;
            this.getPSLM().getLayoutManagerMaker().makeLayoutManagers(fONode, arrayList);
        }
        return arrayList;
    }

    @Override
    public PageSequenceLayoutManager getPSLM() {
        return this.parentLayoutManager.getPSLM();
    }

    public Page getCurrentPage() {
        return this.getPSLM().getCurrentPage();
    }

    public PageViewport getCurrentPV() {
        return this.getPSLM().getCurrentPage().getPageViewport();
    }

    @Override
    public boolean createNextChildLMs(int n) {
        List<LayoutManager> list = this.createChildLMs(n + 1 - this.childLMs.size());
        this.addChildLMs(list);
        return n < this.childLMs.size();
    }

    @Override
    public List<LayoutManager> getChildLMs() {
        if (this.childLMs == null) {
            this.childLMs = new ArrayList<LayoutManager>(10);
        }
        return this.childLMs;
    }

    @Override
    public void addChildLM(LayoutManager layoutManager) {
        if (layoutManager == null) {
            return;
        }
        layoutManager.setParent(this);
        if (this.childLMs == null) {
            this.childLMs = new ArrayList<LayoutManager>(10);
        }
        this.childLMs.add(layoutManager);
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.getClass().getName() + ": Adding child LM " + layoutManager.getClass().getName()));
        }
    }

    @Override
    public void addChildLMs(List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            this.addChildLM((LayoutManager)listIterator.next());
        }
    }

    @Override
    public Position notifyPos(Position position) {
        if (position.getIndex() >= 0) {
            throw new IllegalStateException("Position already got its index");
        }
        position.setIndex(++this.lastGeneratedPosition);
        return position;
    }

    private void verifyNonNullPosition(Position position) {
        if (position == null || position.getIndex() < 0) {
            throw new IllegalArgumentException("Only non-null Positions with an index can be checked");
        }
    }

    public boolean isFirst(Position position) {
        this.verifyNonNullPosition(position);
        if (position.getIndex() == this.smallestPosNumberChecked) {
            return true;
        }
        if (position.getIndex() < this.smallestPosNumberChecked) {
            this.smallestPosNumberChecked = position.getIndex();
            return true;
        }
        return false;
    }

    public boolean isLast(Position position) {
        this.verifyNonNullPosition(position);
        return position.getIndex() == this.lastGeneratedPosition && this.isFinished();
    }

    protected void transferForeignAttributes(AreaTreeObject areaTreeObject) {
        Map map = this.fobj.getForeignAttributes();
        areaTreeObject.setForeignAttributes(map);
    }

    protected void transferExtensionAttachments(AreaTreeObject areaTreeObject) {
        if (this.fobj.hasExtensionAttachments()) {
            areaTreeObject.setExtensionAttachments(this.fobj.getExtensionAttachments());
        }
    }

    protected void transferExtensions(AreaTreeObject areaTreeObject) {
        this.transferForeignAttributes(areaTreeObject);
        this.transferExtensionAttachments(areaTreeObject);
    }

    protected void addMarkersToPage(boolean bl, boolean bl2, boolean bl3) {
        if (this.markers != null) {
            this.getCurrentPV().addMarkers(this.markers, bl, bl2, bl3);
        }
    }

    protected void addId() {
        if (this.fobj != null) {
            this.getPSLM().addIDToPage(this.fobj.getId());
        }
    }

    protected void notifyEndOfLayout() {
        if (this.fobj != null) {
            this.getPSLM().notifyEndOfLayout(this.fobj.getId());
        }
    }

    protected void checkEndOfLayout(Position position) {
        if (position != null && position.getLM() == this && this.isLast(position)) {
            this.notifyEndOfLayout();
            this.childLMs = null;
            this.curChildLM = null;
            this.childLMiter = null;
            this.markers = null;
            LayoutManager layoutManager = this.parentLayoutManager;
            while (!(layoutManager instanceof FlowLayoutManager) && !(layoutManager instanceof PageSequenceLayoutManager)) {
                layoutManager = layoutManager.getParent();
            }
            if (layoutManager instanceof FlowLayoutManager) {
                this.fobj.clearChildNodes();
                this.fobjIter = null;
            }
        }
    }

    public String toString() {
        return super.toString() + (this.fobj != null ? "{fobj = " + this.fobj.toString() + "}" : "");
    }

    @Override
    public void reset() {
        this.isFinished = false;
        this.curChildLM = null;
        this.childLMiter = new LMiter(this);
        for (LayoutManager layoutManager : this.getChildLMs()) {
            layoutManager.reset();
        }
        if (this.fobj != null) {
            this.markers = this.fobj.getMarkers();
        }
        this.lastGeneratedPosition = -1;
    }
}

