/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.layoutmgr.BreakingAlgorithm;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.traits.MinOptMax;

public class BalancingColumnBreakingAlgorithm
extends PageBreakingAlgorithm {
    private static final Log LOG = LogFactory.getLog(BalancingColumnBreakingAlgorithm.class);
    private int columnCount;
    private int fullLen;
    private int idealPartLen;

    public BalancingColumnBreakingAlgorithm(LayoutManager layoutManager, PageProvider pageProvider, PageBreakingAlgorithm.PageBreakingLayoutListener pageBreakingLayoutListener, int n, int n2, MinOptMax minOptMax, boolean bl, int n3) {
        super(layoutManager, pageProvider, pageBreakingLayoutListener, n, n2, minOptMax, bl, false, false);
        this.columnCount = n3;
        this.considerTooShort = true;
    }

    protected double computeDemerits(BreakingAlgorithm.KnuthNode knuthNode, KnuthElement knuthElement, int n, double d) {
        double d2;
        double d3 = super.computeDemerits(knuthNode, knuthElement, n, d);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("original demerit=" + d3 + " " + this.totalWidth + " line=" + knuthNode.line + "/" + this.columnCount + " pos=" + knuthNode.position + "/" + (this.par.size() - 1)));
        }
        int n2 = this.columnCount - knuthNode.line;
        int n3 = this.par.indexOf(knuthElement);
        if (this.fullLen == 0) {
            this.fullLen = ElementListUtils.calcContentLength(this.par, knuthNode.position, this.par.size() - 1);
            this.idealPartLen = this.fullLen / this.columnCount;
        }
        int n4 = ElementListUtils.calcContentLength(this.par, knuthNode.position, n3 - 1);
        int n5 = ElementListUtils.calcContentLength(this.par, n3 - 1, this.par.size() - 1);
        int n6 = 0;
        if (n2 > 0) {
            n6 = n5 / n2;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("remaining parts: " + n2 + " rest len: " + n5 + " avg=" + n6));
        }
        double d4 = (float)(this.idealPartLen - n4) / 1000.0f;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("balance=" + d4));
        }
        d3 = d2 = Math.abs(d4);
        if (this.columnCount > 2) {
            if (d4 > 0.0) {
                d3 *= (double)1.2f;
            }
        } else if (d4 < 0.0) {
            d3 *= (double)1.2f;
        }
        d3 += (double)((float)n6 / 1000.0f);
        if (knuthNode.line >= this.columnCount) {
            d3 = Double.MAX_VALUE;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("effective dem=" + d3 + " " + this.totalWidth));
        }
        return d3;
    }
}

