/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.layoutmgr.Position;

public class LineLayoutPossibilities {
    private static final Log LOG = LogFactory.getLog(LineLayoutPossibilities.class);
    private List possibilitiesList = new ArrayList();
    private List savedPossibilities = new ArrayList();
    private int minimumIndex;
    private int optimumIndex = -1;
    private int maximumIndex;
    private int chosenIndex;
    private int savedOptLineCount;

    public void addPossibility(int n, double d) {
        this.possibilitiesList.add(new Possibility(n, d));
        if (this.possibilitiesList.size() == 1) {
            this.minimumIndex = 0;
            this.optimumIndex = 0;
            this.maximumIndex = 0;
            this.chosenIndex = 0;
        } else {
            if (d < ((Possibility)this.possibilitiesList.get(this.optimumIndex)).getDemerits()) {
                this.chosenIndex = this.optimumIndex = this.possibilitiesList.size() - 1;
            }
            if (n < ((Possibility)this.possibilitiesList.get(this.minimumIndex)).getLineCount()) {
                this.minimumIndex = this.possibilitiesList.size() - 1;
            }
            if (n > ((Possibility)this.possibilitiesList.get(this.maximumIndex)).getLineCount()) {
                this.maximumIndex = this.possibilitiesList.size() - 1;
            }
        }
    }

    public void savePossibilities(boolean bl) {
        this.savedOptLineCount = bl ? this.getOptLineCount() : 0;
        this.savedPossibilities = this.possibilitiesList;
        this.possibilitiesList = new ArrayList();
    }

    public void restorePossibilities() {
        int n = 0;
        while (this.savedPossibilities.size() > 0) {
            Possibility possibility = (Possibility)this.savedPossibilities.remove(0);
            if (possibility.getLineCount() < this.getMinLineCount()) {
                this.possibilitiesList.add(0, possibility);
                this.minimumIndex = 0;
                ++this.optimumIndex;
                ++this.maximumIndex;
                ++this.chosenIndex;
            } else if (possibility.getLineCount() > this.getMaxLineCount()) {
                this.possibilitiesList.add(this.possibilitiesList.size(), possibility);
                n = this.maximumIndex = this.possibilitiesList.size() - 1;
            } else {
                while (n < this.maximumIndex && this.getLineCount(n) < possibility.getLineCount()) {
                    ++n;
                }
                if (this.getLineCount(n) == possibility.getLineCount()) {
                    this.possibilitiesList.set(n, possibility);
                } else {
                    LOG.error((Object)("LineLayoutPossibilities restorePossibilities(), min= " + this.getMinLineCount() + " max= " + this.getMaxLineCount() + " restored= " + possibility.getLineCount()));
                    return;
                }
            }
            if (!(this.savedOptLineCount == 0 && this.getDemerits(this.optimumIndex) > possibility.getDemerits()) && (this.savedOptLineCount == 0 || possibility.getLineCount() != this.savedOptLineCount)) continue;
            this.chosenIndex = this.optimumIndex = n;
        }
    }

    public void addBreakPosition(Position position, int n) {
        ((Possibility)this.possibilitiesList.get(n)).addBreakPosition(position);
    }

    public boolean canUseMoreLines() {
        return this.getOptLineCount() < this.getMaxLineCount();
    }

    public boolean canUseLessLines() {
        return this.getMinLineCount() < this.getOptLineCount();
    }

    public int getMinLineCount() {
        return this.getLineCount(this.minimumIndex);
    }

    public int getOptLineCount() {
        return this.getLineCount(this.optimumIndex);
    }

    public int getMaxLineCount() {
        return this.getLineCount(this.maximumIndex);
    }

    public int getChosenLineCount() {
        return this.getLineCount(this.chosenIndex);
    }

    public int getLineCount(int n) {
        return ((Possibility)this.possibilitiesList.get(n)).getLineCount();
    }

    public double getChosenDemerits() {
        return this.getDemerits(this.chosenIndex);
    }

    public double getDemerits(int n) {
        return ((Possibility)this.possibilitiesList.get(n)).getDemerits();
    }

    public int getPossibilitiesNumber() {
        return this.possibilitiesList.size();
    }

    public Position getChosenPosition(int n) {
        return ((Possibility)this.possibilitiesList.get(this.chosenIndex)).getBreakPosition(n);
    }

    public int applyLineCountAdjustment(int n) {
        if (n >= this.getMinLineCount() - this.getChosenLineCount() && n <= this.getMaxLineCount() - this.getChosenLineCount() && this.getLineCount(this.chosenIndex + n) == this.getChosenLineCount() + n) {
            this.chosenIndex += n;
            LOG.debug((Object)("chosenLineCount= " + (this.getChosenLineCount() - n) + " adjustment= " + n + " => chosenLineCount= " + this.getLineCount(this.chosenIndex)));
            return n;
        }
        LOG.warn((Object)"Cannot apply the desired line count adjustment.");
        return 0;
    }

    public void printAll() {
        System.out.println("++++++++++");
        System.out.println(" " + this.possibilitiesList.size() + " possibility':");
        for (int i = 0; i < this.possibilitiesList.size(); ++i) {
            System.out.println("   " + ((Possibility)this.possibilitiesList.get(i)).getLineCount() + (i == this.optimumIndex ? " *" : "") + (i == this.minimumIndex ? " -" : "") + (i == this.maximumIndex ? " +" : ""));
        }
        System.out.println("++++++++++");
    }

    private final class Possibility {
        private int lineCount;
        private double demerits;
        private List breakPositions;

        private Possibility(int n, double d) {
            this.lineCount = n;
            this.demerits = d;
            this.breakPositions = new ArrayList(n);
        }

        private int getLineCount() {
            return this.lineCount;
        }

        private double getDemerits() {
            return this.demerits;
        }

        private void addBreakPosition(Position position) {
            this.breakPositions.add(0, position);
        }

        private Position getBreakPosition(int n) {
            return (Position)this.breakPositions.get(n);
        }
    }
}

